/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.eventlog;

import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogHook;
import net.lukemurphey.nsia.eventlog.EventLogHookException;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.eventlog.EventLogSeverity;
import net.lukemurphey.nsia.response.Action;
import net.lukemurphey.nsia.response.ActionFailedException;

public class SiteGroupStatusEventLogHook
extends EventLogHook {
    private static final long serialVersionUID = 1L;
    private Action action;
    private String siteGroupID;
    private int siteGroupIDInt;
    private EventLogSeverity minimumSeverity;

    public SiteGroupStatusEventLogHook(Action action, int siteGroupID, EventLogSeverity minimumSeverity) {
        if (action == null) {
            throw new IllegalArgumentException("The action to perform cannot be null");
        }
        if (minimumSeverity == null) {
            throw new IllegalArgumentException("The minimum severity level cannot be null");
        }
        if (siteGroupID < 0) {
            throw new IllegalArgumentException("The identifier of the site group must be greater than zero");
        }
        this.action = action;
        this.minimumSeverity = minimumSeverity;
        this.siteGroupID = Long.toString(siteGroupID);
        this.siteGroupIDInt = siteGroupID;
    }

    public int getSiteGroupID() {
        return this.siteGroupIDInt;
    }

    @Override
    public void processEvent(EventLogMessage message) throws EventLogHookException, ActionFailedException {
        EventLogField field;
        if (message == null) {
            return;
        }
        if (message.getSeverity().toInt() < this.minimumSeverity.toInt()) {
            return;
        }
        if ((message.getEventType() == EventLogMessage.EventType.RULE_COMPLETE_REJECTED || message.getEventType() == EventLogMessage.EventType.RULE_COMPLETE_FAILED) && (field = message.getField(EventLogField.FieldName.SITE_GROUP_ID)) != null && field.getValue().equals(this.siteGroupID)) {
            this.action.execute(message);
            this.logActionCompletion(this.action, field);
        }
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    public static SiteGroupStatusEventLogHook[] getSiteGroupEventLogHooks(Application app, long siteGroupID) {
        EventLogHook[] allHooks = app.getEventLog().getHooks();
        Vector<SiteGroupStatusEventLogHook> siteGroupHooks = new Vector<SiteGroupStatusEventLogHook>();
        int c = 0;
        while (c < allHooks.length) {
            if (allHooks[c] instanceof SiteGroupStatusEventLogHook && (long)((SiteGroupStatusEventLogHook)allHooks[c]).getSiteGroupID() == siteGroupID) {
                siteGroupHooks.add((SiteGroupStatusEventLogHook)allHooks[c]);
            }
            ++c;
        }
        SiteGroupStatusEventLogHook[] hooksArray = new SiteGroupStatusEventLogHook[siteGroupHooks.size()];
        siteGroupHooks.toArray(hooksArray);
        return hooksArray;
    }
}

