/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.eventlog;

import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.eventlog.EventLogHook;
import net.lukemurphey.nsia.eventlog.EventLogHookException;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.eventlog.EventLogSeverity;
import net.lukemurphey.nsia.response.Action;
import net.lukemurphey.nsia.response.ActionFailedException;

public class SystemStatusEventLogHook
extends EventLogHook {
    private static final long serialVersionUID = 1L;
    private Action action;
    private EventLogSeverity minimumSeverity;

    public SystemStatusEventLogHook(Action action, EventLogSeverity minimumSeverity) {
        if (action == null) {
            throw new IllegalArgumentException("The action to perform cannot be null");
        }
        if (minimumSeverity == null) {
            throw new IllegalArgumentException("The minimum severity level cannot be null");
        }
        this.action = action;
        this.minimumSeverity = minimumSeverity;
    }

    @Override
    public void processEvent(EventLogMessage message) throws EventLogHookException {
        if (message == null) {
            return;
        }
        if (message.getSeverity().toInt() < this.minimumSeverity.toInt()) {
            return;
        }
        try {
            if (message.getEventType() == EventLogMessage.EventType.SCANNER_STOPPED) {
                this.action.execute(message);
            }
        }
        catch (ActionFailedException e) {
            throw new EventLogHookException(e);
        }
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    public static SystemStatusEventLogHook[] getSystemStatusEventLogHooks(Application app) {
        EventLogHook[] allHooks = app.getEventLog().getHooks();
        Vector<SystemStatusEventLogHook> ruleHooks = new Vector<SystemStatusEventLogHook>();
        int c = 0;
        while (c < allHooks.length) {
            if (allHooks[c] instanceof SystemStatusEventLogHook) {
                ruleHooks.add((SystemStatusEventLogHook)allHooks[c]);
            }
            ++c;
        }
        SystemStatusEventLogHook[] hooksArray = new SystemStatusEventLogHook[ruleHooks.size()];
        ruleHooks.toArray(hooksArray);
        return hooksArray;
    }
}

