/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.extension;

import java.util.Vector;
import net.lukemurphey.nsia.extension.Extension;
import net.lukemurphey.nsia.extension.ExtensionType;
import net.lukemurphey.nsia.response.CommandActionExtension;
import net.lukemurphey.nsia.response.EmailActionExtension;
import net.lukemurphey.nsia.response.LogFileActionExtension;
import net.lukemurphey.nsia.response.SSHCommandActionExtension;

public class ExtensionManager {
    private Vector<Extension> extensions = new Vector();
    private static ExtensionManager globalExtensionManager = null;

    private ExtensionManager() {
        this.addExtension(new CommandActionExtension());
        this.addExtension(new LogFileActionExtension());
        this.addExtension(new SSHCommandActionExtension());
        this.addExtension(new EmailActionExtension());
    }

    public Extension[] getAllExtensions() {
        Extension[] ext = new Extension[this.extensions.size()];
        this.extensions.toArray(ext);
        return ext;
    }

    public Extension[] getExtensions(ExtensionType extensionType) {
        Vector<Extension> matchingExtensions = new Vector<Extension>();
        for (Extension ext : this.extensions) {
            if (extensionType != ext.getExtensionType()) continue;
            matchingExtensions.add(ext);
        }
        Extension[] tmp = new Extension[this.extensions.size()];
        matchingExtensions.toArray(tmp);
        return tmp;
    }

    public Extension getExtension(ExtensionType extensionType, String name) {
        for (Extension ext : this.extensions) {
            if (extensionType != ext.getExtensionType() || !ext.getName().equals(name)) continue;
            return ext;
        }
        return null;
    }

    private void addExtension(Extension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("The extension to add cannot be null");
        }
        this.extensions.add(extension);
    }

    public static ExtensionManager getExtensionManager() {
        if (globalExtensionManager == null) {
            globalExtensionManager = new ExtensionManager();
        }
        return globalExtensionManager;
    }
}

