/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.extension;

import java.io.File;
import net.lukemurphey.nsia.extension.FieldValidator;

public class FileFieldValidator
implements FieldValidator {
    private boolean ensureFileExists;
    private boolean acceptFolder;
    private boolean acceptFile;

    public FileFieldValidator(boolean ensureFileExists, boolean acceptFolder, boolean acceptFile) {
        if (!acceptFolder && !acceptFile) {
            throw new IllegalArgumentException("This validator must accept either a file or folder (or both); this validator was set to reject both files and folders and will therefore reject everything");
        }
        this.ensureFileExists = ensureFileExists;
        this.acceptFolder = acceptFolder;
        this.acceptFile = acceptFile;
    }

    @Override
    public FieldValidator.FieldValidatorResult validate(String value) {
        File file = new File(value);
        if (value == null || value.trim().length() == 0) {
            if (this.acceptFile && this.acceptFolder) {
                return new FieldValidator.FieldValidatorResult("The location cannot be empty", false);
            }
            if (this.acceptFile) {
                return new FieldValidator.FieldValidatorResult("The file cannot be empty", false);
            }
            return new FieldValidator.FieldValidatorResult("The directory cannot be empty", false);
        }
        if (this.ensureFileExists && !file.exists()) {
            if (this.acceptFolder && this.acceptFile) {
                return new FieldValidator.FieldValidatorResult("The given location does not exist", false);
            }
            if (this.acceptFolder) {
                return new FieldValidator.FieldValidatorResult("The directory does not exist", false);
            }
            return new FieldValidator.FieldValidatorResult("The file does not exist", false);
        }
        if (file.isDirectory() && !this.acceptFolder) {
            return new FieldValidator.FieldValidatorResult("The path given is a file (not a folder)", false);
        }
        if (!file.isDirectory() && !this.acceptFile) {
            return new FieldValidator.FieldValidatorResult("The path given is a folder (not a file)", false);
        }
        return new FieldValidator.FieldValidatorResult(true);
    }
}

