/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.extension;

import net.lukemurphey.nsia.extension.FieldValidator;
import org.apache.commons.lang.StringUtils;

public abstract class PrototypeField
implements Cloneable {
    private int layoutWidth = 1;
    private String name;
    private String title;
    private String help;
    private String overrideValue = null;

    public PrototypeField(String name, String title) {
        this.setName(name);
        this.setTitle(title);
        this.setLayoutWidth(1);
    }

    public PrototypeField(String name, String title, String help) {
        this.setName(name);
        this.setTitle(title);
        this.setHelp(help);
        this.setLayoutWidth(1);
    }

    public PrototypeField(String name, String title, String help, int layoutWidth) {
        this.setName(name);
        this.setTitle(title);
        this.setHelp(help);
        this.setLayoutWidth(layoutWidth);
    }

    public PrototypeField(String name, String title, int layoutWidth) {
        this.setName(name);
        this.setTitle(title);
        this.setLayoutWidth(layoutWidth);
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public String getHelp() {
        return this.help;
    }

    public int getLayoutWidth() {
        return this.layoutWidth;
    }

    public String getDefaultValue() {
        return this.overrideValue;
    }

    public void setDefaultValue(String value) {
        this.overrideValue = value;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void setLayoutWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("The width must be at least one");
        }
        this.layoutWidth = width;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("The name cannot be blank");
        }
        this.name = name;
    }

    public abstract String getType();

    public void setTitle(String title) {
        this.title = title;
    }

    public abstract FieldValidator.FieldValidatorResult validate(String var1);

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

