/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.response;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.extension.ArgumentFieldsInvalidException;
import net.lukemurphey.nsia.extension.FieldLayout;
import net.lukemurphey.nsia.extension.FieldText;
import net.lukemurphey.nsia.extension.FileFieldValidator;
import net.lukemurphey.nsia.response.Action;
import net.lukemurphey.nsia.response.ActionFailedException;
import net.lukemurphey.nsia.scan.ScanResult;

public class CommandAction
extends Action {
    private static final long serialVersionUID = 1L;
    private String command;
    private File workingDirectory = null;
    private static final String USER_DESCRIPTION = "Run a Program";

    public CommandAction(Hashtable<String, String> arguments) throws ArgumentFieldsInvalidException {
        super("Command", USER_DESCRIPTION);
        this.configure(arguments);
    }

    public CommandAction(String command, File workingDirectory) {
        super("Command", USER_DESCRIPTION);
        if (command == null) {
            throw new IllegalArgumentException("The command to execute cannot be null");
        }
        if (workingDirectory == null) {
            throw new IllegalArgumentException("The working directory cannot be null");
        }
        this.command = command;
        this.workingDirectory = workingDirectory;
    }

    public CommandAction(String command) {
        super("Command", USER_DESCRIPTION);
        if (command == null) {
            throw new IllegalArgumentException("The command to execute cannot be null");
        }
        this.command = command;
        this.workingDirectory = null;
    }

    @Override
    public Hashtable<String, String> getValues() {
        Hashtable<String, String> values = new Hashtable<String, String>();
        if (this.command != null) {
            values.put("Command", this.command);
        } else {
            values.put("Command", "");
        }
        if (this.workingDirectory != null) {
            values.put("WorkingDirectory", this.workingDirectory.getAbsolutePath());
        }
        return values;
    }

    @Override
    protected void setField(String name, String value) {
        if ("Command".equals(name)) {
            this.command = value;
        } else if ("WorkingDirectory".equals(name)) {
            this.workingDirectory = value.length() == 0 ? null : new File(value);
        }
    }

    private void runCommand(String command, File workingDirectory) throws ActionFailedException {
        try {
            if (workingDirectory == null) {
                Runtime.getRuntime().exec(command);
            } else {
                Runtime.getRuntime().exec(command, new String[0], workingDirectory);
            }
        }
        catch (IOException e) {
            throw new ActionFailedException("Attempt to run command (" + command + ") failed: " + e.getMessage(), e);
        }
    }

    @Override
    public FieldLayout getLayoutWithValues() {
        FieldLayout layout = CommandAction.getLayout();
        layout.setFieldsValues(this.getValues());
        return layout;
    }

    public static FieldLayout getLayout() {
        FieldLayout layout = new FieldLayout(1);
        layout.addField(new FieldText("Command", "Command", "Enter the full path to the executable to run on the local system", 1, 1, new FileFieldValidator(true, false, true)));
        layout.addField(new FieldText("WorkingDirectory", "Working Directory", "Enter the path that the executable ought to run within", 1, 1, new FileFieldValidator(true, true, false)));
        return layout;
    }

    @Override
    public void execute(EventLogMessage logMessage) throws ActionFailedException {
        this.runCommand(this.command, this.workingDirectory);
    }

    @Override
    public String getConfigDescription() {
        return this.command;
    }

    @Override
    public void execute(ScanResult scanResult) throws ActionFailedException {
        String commandProcessed = this.getMessage(this.command, scanResult);
        this.runCommand(commandProcessed, this.workingDirectory);
    }
}

