/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.response;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.extension.ArgumentFieldsInvalidException;
import net.lukemurphey.nsia.extension.FieldLayout;
import net.lukemurphey.nsia.extension.FieldText;
import net.lukemurphey.nsia.extension.FieldValidator;
import net.lukemurphey.nsia.extension.FileFieldValidator;
import net.lukemurphey.nsia.extension.MessageValidator;
import net.lukemurphey.nsia.extension.PrototypeField;
import net.lukemurphey.nsia.response.Action;
import net.lukemurphey.nsia.response.ActionFailedException;
import net.lukemurphey.nsia.scan.ScanResult;

public class LogFileAction
extends Action {
    private static final long serialVersionUID = 1L;
    private File file;
    private String template;
    public static final String USER_DESCRIPTION = "Append a message to a file";

    public LogFileAction(Hashtable<String, String> arguments) throws ArgumentFieldsInvalidException {
        super("Log to File", USER_DESCRIPTION);
        this.configure(arguments);
    }

    public LogFileAction(long actionID, Application application) {
        super("Log to File", USER_DESCRIPTION);
    }

    public LogFileAction(File file, String template) {
        super("Log to File", USER_DESCRIPTION);
        if (file == null) {
            throw new IllegalArgumentException("The file to append to cannot be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("The template cannot be null");
        }
        this.file = file;
        this.template = template;
    }

    @Override
    public Hashtable<String, String> getValues() {
        Hashtable<String, String> values = new Hashtable<String, String>();
        values.put("File", this.file.getAbsolutePath());
        values.put("Message", this.template);
        return values;
    }

    @Override
    public FieldLayout getLayoutWithValues() {
        FieldLayout layout = LogFileAction.getLayout();
        layout.setFieldsValues(this.getValues());
        return layout;
    }

    @Override
    protected void setField(String name, String value) {
        if ("File".equals(name)) {
            this.file = new File(value);
        } else if ("Message".equals(name)) {
            this.template = value;
        }
    }

    public static FieldLayout getLayout() {
        FieldLayout layout = new FieldLayout(1);
        layout.addField(new FieldText("Message", "Message", "Enter the text to write to append to the log file. Note: you can use substitution variables to add in details such as the specimen/URL ($specimen), number of deviations detected ($deviation_count) or date of the finding ($date).", 1, 5, new MessageValidator()));
        layout.addField(new FieldText("File", "File", "Enter the full path of the file to append the log entry to", 1, 1, new FileFieldValidator(false, false, true)));
        return layout;
    }

    @Override
    public void configure(Hashtable<String, String> arguments) throws ArgumentFieldsInvalidException {
        PrototypeField[] fields;
        FieldLayout layout = LogFileAction.getLayout();
        PrototypeField[] prototypeFieldArray = fields = layout.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            PrototypeField field = prototypeFieldArray[n2];
            String value = arguments.get(field.getName());
            if (value == null) {
                throw new ArgumentFieldsInvalidException("The " + field.getName() + " field was not provided", field);
            }
            FieldValidator.FieldValidatorResult result = field.validate(value);
            if (!result.validated()) {
                if (result.getMessage() == null) {
                    throw new ArgumentFieldsInvalidException("The " + field.getName() + " field is invalid", field);
                }
                throw new ArgumentFieldsInvalidException(result.getMessage(), field);
            }
            this.setField(field.getName(), value);
            ++n2;
        }
    }

    public static void appendFile(File file, String text) throws ActionFailedException {
        if (file == null) {
            throw new ActionFailedException("The file provided is invalid (null)");
        }
        if (text == null) {
            throw new ActionFailedException("The text provided is invalid (null)");
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file, true));
            out.write(text);
            out.close();
        }
        catch (IOException e) {
            throw new ActionFailedException("The file could not be appended: " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "Log to File";
    }

    @Override
    public void execute(EventLogMessage logMessage) throws ActionFailedException {
        Vector<Action.MessageVariable> vars = Action.MessageVariable.getMessageVariables(logMessage);
        String text = Action.MessageVariable.processMessageTemplate(this.template, vars);
        LogFileAction.appendFile(this.file, text);
    }

    @Override
    public String getConfigDescription() {
        return this.file.getAbsolutePath();
    }

    @Override
    public void execute(ScanResult scanResult) throws ActionFailedException {
        String text = this.getMessage(this.template, scanResult);
        LogFileAction.appendFile(this.file, text);
    }
}

