/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.lukemurphey.nsia.rest.EndpointIndex;
import net.lukemurphey.nsia.rest.RESTEndpointClient;
import net.lukemurphey.nsia.rest.RESTRequestFailedException;
import net.lukemurphey.nsia.scan.DefinitionSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefinitionsInfo
extends RESTEndpointClient {
    public DefinitionsInfo(URL endPointURL) {
        this.setEndpointURL(endPointURL);
    }

    public DefinitionsInfo() throws RESTRequestFailedException {
        this.setEndpointURL(EndpointIndex.getEndpoint("definitions_version").getURL());
    }

    private DefinitionSet.DefinitionVersionID parseDefinitionsData(Document doc) throws MalformedURLException, ParseException {
        Element el = doc.getDocumentElement();
        if (el.getNodeName().equalsIgnoreCase("Definitions")) {
            String version = el.getAttribute("Version");
            String dateString = el.getAttribute("Date");
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss Z yyyy");
            Date date = dateFormat.parse(dateString);
            return new DefinitionSet.DefinitionVersionID(version, date);
        }
        return null;
    }

    public static DefinitionSet.DefinitionVersionID getCurrentDefinitionsVersion(URL url) throws RESTRequestFailedException {
        DefinitionsInfo definitionsInfo = new DefinitionsInfo(url);
        return definitionsInfo.getCurrentDefinitionsVersion();
    }

    public DefinitionSet.DefinitionVersionID getCurrentDefinitionsVersion() throws RESTRequestFailedException {
        Document doc = this.doGet();
        try {
            return this.parseDefinitionsData(doc);
        }
        catch (MalformedURLException e) {
            throw new RESTRequestFailedException("Unable to obtain definitions version information", e);
        }
        catch (ParseException e) {
            throw new RESTRequestFailedException("Unable to parse definition set date", e);
        }
    }
}

