/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import net.lukemurphey.nsia.LicenseDescriptor;
import net.lukemurphey.nsia.rest.EndpointIndex;
import net.lukemurphey.nsia.rest.RESTEndpointClient;
import net.lukemurphey.nsia.rest.RESTRequestFailedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LicenseInfo
extends RESTEndpointClient {
    public LicenseInfo(String id, String password) throws RESTRequestFailedException {
        this.setEndpointURL(EndpointIndex.getEndpoint("license").getURL());
        this.id = id;
        this.password = password;
    }

    public LicenseInfo(URL endPointURL, String id, String password) {
        this.setEndpointURL(endPointURL);
        this.id = id;
        this.password = password;
    }

    private LicenseDescriptor parseLicenseData(Document doc) throws MalformedURLException, ParseException {
        Element el = doc.getDocumentElement();
        if (el.getNodeName().equalsIgnoreCase("License")) {
            String licensee = el.getAttribute("Licensee");
            String expirationDateString = el.getAttribute("ExpirationDate");
            Date expirationDate = LicenseInfo.parseStandardDateFormat(expirationDateString);
            String status_string = el.getAttribute("Status");
            LicenseDescriptor.LicenseStatus status = LicenseDescriptor.LicenseStatus.valueOf(status_string);
            String key = el.getAttribute("Key");
            String type_string = el.getAttribute("Type");
            LicenseDescriptor.Type type = LicenseDescriptor.Type.valueOf(type_string);
            String licenseExpiredString = el.getAttribute("Expired");
            boolean isExpired = false;
            if (status == LicenseDescriptor.LicenseStatus.EXPIRED) {
                isExpired = true;
            } else if (licenseExpiredString == null || licenseExpiredString.length() == 0) {
                isExpired = false;
            } else if (licenseExpiredString.equalsIgnoreCase("True")) {
                isExpired = true;
            }
            if (isExpired && status == LicenseDescriptor.LicenseStatus.ACTIVE) {
                status = LicenseDescriptor.LicenseStatus.EXPIRED;
            }
            return new LicenseDescriptor(licensee, key, expirationDate, type, status, isExpired);
        }
        return null;
    }

    public static LicenseDescriptor getLicenseInformation(URL url, String licenseKey, String installationID) throws RESTRequestFailedException {
        LicenseInfo licenseInfo = new LicenseInfo(url, installationID, licenseKey);
        return licenseInfo.getLicenseInformation();
    }

    public LicenseDescriptor getLicenseInformation() throws RESTRequestFailedException {
        Document doc = this.doGet();
        try {
            return this.parseLicenseData(doc);
        }
        catch (MalformedURLException e) {
            throw new RESTRequestFailedException("Unable to obtain license information", e);
        }
        catch (ParseException e) {
            throw new RESTRequestFailedException("Unable to parse expiration date", e);
        }
    }
}

