/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.scan.DataSpecimen;
import net.lukemurphey.nsia.scan.Evaluator;
import net.lukemurphey.nsia.scan.InvalidEvaluatorException;

public class ByteTestEvaluator
extends Evaluator {
    private int length;
    private double operand;
    private Operator operator;
    private DataType dataType;
    private boolean bigEndian = true;
    private int base = 10;
    private boolean useAbsoluteValue = false;
    private static final Pattern BYTE_TEST_REGEX = Pattern.compile("[ ]*([0-9]+)[ ]+(digits|bytes|byte|digit)[ ]*(=|>|<=|>=|<)[ ]*([0-9]+)\\s*(\\(([-A-Za-z0-9, ]*)\\))?", 8);

    private ByteTestEvaluator() {
    }

    public ByteTestEvaluator(int length, Operator operator, DataType dataType, double operand) throws InvalidEvaluatorException {
        if (length <= 0) {
            throw new IllegalArgumentException("The length must be greater than zero");
        }
        if (operator == null) {
            throw new IllegalArgumentException("The operator must not be null");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("The dataType must not be null");
        }
        this.length = length;
        this.operator = operator;
        this.dataType = dataType;
        this.operand = operand;
        this.checkConfiguration();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int evaluate(DataSpecimen data, int lastMatch, boolean useBasicEncoding) {
        start = this.computeStartLocation(lastMatch);
        if (this.dataType == DataType.STRING) {
            dataString = useBasicEncoding != false ? data.getBasicEncodedString() : data.getString();
            endLocation = Math.min(dataString.length(), start + this.length);
            number = dataString.substring(start, endLocation);
            try {
                value = this.base == 16 ? (double)Integer.valueOf(number, 16).intValue() : (this.base == 8 ? (double)Integer.valueOf(number, 8).intValue() : Double.parseDouble(number));
                if (!this.useAbsoluteValue) ** GOTO lbl22
                value = Math.abs(value);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        } else {
            bytes = data.getBytes();
            if (start >= bytes.length) {
                return -1;
            }
            endLocation = Math.min(start + this.length, bytes.length - 1);
            if (start >= bytes.length) {
                return -1;
            }
            bytesToBeAnalyzed = new byte[endLocation - start];
            System.arraycopy(bytes, start, bytesToBeAnalyzed, 0, endLocation - start);
            value = this.bigEndian != false ? ByteTestEvaluator.getBigEndianValue(bytesToBeAnalyzed) : ByteTestEvaluator.getLittleEndianValue(bytesToBeAnalyzed);
        }
lbl22:
        // 3 sources

        if (ByteTestEvaluator.matches(value, this.operator, this.operand)) {
            return endLocation - 1;
        }
        return -1;
    }

    private static boolean matches(double observedValue, Operator operator, double expected) {
        if (operator == Operator.EQUALS) {
            return observedValue == expected;
        }
        if (operator == Operator.GREATER_OR_EQUAL) {
            return observedValue >= expected;
        }
        if (operator == Operator.GREATER_THAN) {
            return observedValue > expected;
        }
        if (operator == Operator.LESS_THAN) {
            return observedValue < expected;
        }
        if (operator == Operator.LESSER_OR_EQUAL) {
            return observedValue <= expected;
        }
        return false;
    }

    public static double getMaxValue(int byteCount) {
        if (byteCount <= 0) {
            return 0.0;
        }
        return Math.pow(256.0, byteCount) - 1.0;
    }

    public static ByteTestEvaluator parse(String value) throws InvalidEvaluatorException {
        if (value == null) {
            throw new IllegalArgumentException("The ByteTest evaluator rule cannot be null");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException("The ByteTest evaluator rule cannot be empty");
        }
        ByteTestEvaluator byteTest = new ByteTestEvaluator();
        Matcher matcher = BYTE_TEST_REGEX.matcher(value);
        if (!matcher.find()) {
            throw new InvalidEvaluatorException("The ByteTest evaluator rule does not appear to be valid");
        }
        try {
            byteTest.length = Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException e) {
            throw new InvalidEvaluatorException("The ByteTest evaluator rule does not appear to be valid (number format of byte count is not valid)");
        }
        if (matcher.group(2) == null) {
            throw new InvalidEvaluatorException("The ByteTest evaluator rule does not appear to be valid (missing data type)");
        }
        if (matcher.group(2).equalsIgnoreCase("bytes")) {
            byteTest.dataType = DataType.BYTES;
        } else if (matcher.group(2).equalsIgnoreCase("digits")) {
            byteTest.dataType = DataType.STRING;
        } else if (matcher.group(2).equalsIgnoreCase("byte")) {
            byteTest.dataType = DataType.BYTES;
        } else if (matcher.group(2).equalsIgnoreCase("digit")) {
            byteTest.dataType = DataType.STRING;
        } else {
            throw new InvalidEvaluatorException("The ByteTest evaluator rule does not appear to be valid (data type is not valid)");
        }
        if (matcher.group(3) == null) {
            throw new InvalidEvaluatorException("The ByteTest evaluator rule does not appear to be valid (missing operator)");
        }
        if (matcher.group(3).equalsIgnoreCase("=")) {
            byteTest.operator = Operator.EQUALS;
        } else if (matcher.group(3).equalsIgnoreCase(">=")) {
            byteTest.operator = Operator.GREATER_OR_EQUAL;
        } else if (matcher.group(3).equalsIgnoreCase(">")) {
            byteTest.operator = Operator.GREATER_THAN;
        } else if (matcher.group(3).equalsIgnoreCase("<")) {
            byteTest.operator = Operator.LESS_THAN;
        } else if (matcher.group(3).equalsIgnoreCase("<=")) {
            byteTest.operator = Operator.LESSER_OR_EQUAL;
        } else {
            throw new InvalidEvaluatorException("The ByteTest evaluator rule does not appear to be valid (operator is not valid)");
        }
        try {
            byteTest.operand = Long.parseLong(matcher.group(4));
        }
        catch (NumberFormatException e) {
            throw new InvalidEvaluatorException("The ByteTest evaluator rule does not appear to be valid (number format of test value is not valid)");
        }
        if (matcher.group(6) != null) {
            String[] otherOptions = matcher.group(6).split(",");
            int c = 0;
            while (c < otherOptions.length) {
                if (otherOptions[c].trim().equalsIgnoreCase("big-endian") || otherOptions[c].trim().equalsIgnoreCase("bigendian")) {
                    byteTest.bigEndian = true;
                } else if (otherOptions[c].trim().equalsIgnoreCase("little-endian") || otherOptions[c].trim().equalsIgnoreCase("littleendian")) {
                    byteTest.bigEndian = false;
                } else if (otherOptions[c].trim().equalsIgnoreCase("hex") || otherOptions[c].trim().equalsIgnoreCase("hexadecimal")) {
                    byteTest.base = 16;
                } else if (otherOptions[c].trim().equalsIgnoreCase("abs") || otherOptions[c].trim().equalsIgnoreCase("absolute-value") || otherOptions[c].trim().equalsIgnoreCase("absolutevalue")) {
                    byteTest.useAbsoluteValue = true;
                }
                ++c;
            }
        }
        byteTest.checkConfiguration();
        return byteTest;
    }

    private void checkConfiguration() throws InvalidEvaluatorException {
        double maximumValuePossible = this.dataType == DataType.BYTES ? ByteTestEvaluator.getMaxValue(this.length) : Math.pow(this.base, this.length);
        if (this.operator == Operator.GREATER_OR_EQUAL && this.operand > maximumValuePossible) {
            throw new InvalidEvaluatorException("This evaluator has no purpose, it will never match the input because the length of the input is not sufficient to trigger the evaluator (the maximum possible is " + maximumValuePossible + ")");
        }
        if (this.operator == Operator.GREATER_THAN && this.operand >= maximumValuePossible) {
            throw new InvalidEvaluatorException("This evaluator has no purpose, it will never match the input because the length of the input is not sufficient to trigger the evaluator (the maximum possible is " + maximumValuePossible + ")");
        }
        if (this.operator == Operator.EQUALS && this.operand > maximumValuePossible) {
            throw new InvalidEvaluatorException("This evaluator has no purpose, it will never match the input because the length of the input is not sufficient to trigger the evaluator (the maximum possible is " + maximumValuePossible + ")");
        }
        if (this.operator == Operator.LESS_THAN && this.operand > maximumValuePossible) {
            throw new InvalidEvaluatorException("This evaluator has no purpose, it will always match the input because the length of the input is not sufficient to exceed the value given (the maximum possible is " + maximumValuePossible + ")");
        }
        if (this.operator == Operator.LESSER_OR_EQUAL && this.operand > maximumValuePossible) {
            throw new InvalidEvaluatorException("This evaluator has no purpose, it will always match the input because the length of the input is not sufficient to exceed the value given (the maximum possible is " + maximumValuePossible + ")");
        }
    }

    @Override
    public Evaluator.ReturnType getReturnType() {
        if (this.dataType == DataType.BYTES) {
            return Evaluator.ReturnType.BYTE_LOCATION;
        }
        return Evaluator.ReturnType.CHARACTER_LOCATION;
    }

    public static enum DataType {
        STRING,
        BYTES;

    }

    public static enum Operator {
        EQUALS,
        GREATER_THAN,
        LESS_THAN,
        GREATER_OR_EQUAL,
        LESSER_OR_EQUAL;

    }
}

