/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import net.lukemurphey.nsia.scan.EncodingDetectionFailedException;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class CharsetDetector
extends nsDetector {
    private CharsetDetectorObserver observer = new CharsetDetectorObserver();

    public static String detectCharset(byte[] sample) throws EncodingDetectionFailedException {
        return CharsetDetector.detectCharset(sample, sample.length);
    }

    public static String detectCharset(byte[] sample, int length) throws EncodingDetectionFailedException {
        CharsetDetector charsetDetect = new CharsetDetector();
        if (charsetDetect.isAscii(sample, sample.length)) {
            return "ASCII";
        }
        charsetDetect.DoIt(sample, length, false);
        if (charsetDetect.observer.found) {
            return charsetDetect.observer.detectedCharset;
        }
        throw new EncodingDetectionFailedException();
    }

    private CharsetDetector() {
        super.Init((nsICharsetDetectionObserver)this.observer);
    }

    private static class CharsetDetectorObserver
    implements nsICharsetDetectionObserver {
        public String detectedCharset;
        public boolean found = false;

        private CharsetDetectorObserver() {
        }

        public void Notify(String charset) {
            this.detectedCharset = charset;
            this.found = true;
        }
    }
}

