/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.scan.InvalidDefinitionException;

public abstract class Definition {
    protected Vector<Reference> references = new Vector();
    private static final Pattern RULE_NAME_REGEX = Pattern.compile("([-a-zA-Z0-9_]+).([-a-zA-Z0-9_]+).([-a-zA-Z0-9@_]+)");
    protected String category;
    protected String subCategory;
    protected String name;
    protected String definitionType;
    protected String message;
    protected Severity severity = Severity.UNDEFINED;
    protected int revision;
    protected int id = -1;
    protected Action action;
    protected int localId = -1;

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return String.valueOf(this.category) + "." + this.subCategory + "." + this.name;
    }

    public Action getAction() {
        return this.action;
    }

    public String getMessage() {
        return this.message;
    }

    public Reference[] getReferences() {
        Reference[] refs = new Reference[this.references.size()];
        this.references.toArray(refs);
        return refs;
    }

    public String getCategoryName() {
        return this.category;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getSubCategoryName() {
        return this.subCategory;
    }

    public int getID() {
        return this.id;
    }

    public boolean isOfficial() {
        return this.id < 1000000 && this.id > -1;
    }

    public int getLocalID() {
        return this.localId;
    }

    public int getRevision() {
        return this.revision;
    }

    public static String[] parseName(String name) throws InvalidDefinitionException {
        if (name == null) {
            throw new InvalidDefinitionException("A name for the definition must be provided");
        }
        Matcher matcher = RULE_NAME_REGEX.matcher(name);
        if (!matcher.find()) {
            throw new InvalidDefinitionException("The name is not a valid threat definition name");
        }
        String[] result = new String[]{matcher.group(1), matcher.group(2), matcher.group(3)};
        if (result[2].length() < 1) {
            throw new InvalidDefinitionException("The name is not a valid threat definition name");
        }
        if (result[0].length() < 1) {
            throw new InvalidDefinitionException("The name is not a valid threat definition name");
        }
        if (result[1].length() < 1) {
            throw new InvalidDefinitionException("The name is not a valid threat definition name");
        }
        return result;
    }

    protected void parseFullName(String name) throws InvalidDefinitionException {
        if (name == null) {
            throw new InvalidDefinitionException("A name for the definition must be provided");
        }
        Matcher matcher = RULE_NAME_REGEX.matcher(name);
        if (!matcher.find()) {
            throw new InvalidDefinitionException("The name is not a valid threat definition name");
        }
        this.category = matcher.group(1);
        this.subCategory = matcher.group(2);
        this.name = matcher.group(3);
        if (name.length() < 1) {
            throw new InvalidDefinitionException("The name is not a valid threat definition name");
        }
        if (this.category.length() < 1) {
            throw new InvalidDefinitionException("The name is not a valid threat definition name");
        }
        if (this.subCategory.length() < 1) {
            throw new InvalidDefinitionException("The name is not a valid threat definition name");
        }
    }

    public String getType() {
        return this.definitionType;
    }

    public String toString() {
        return this.getFullName();
    }

    public static enum Action {
        ALERT,
        BLOCK,
        EVAL;

    }

    public static class Reference {
        public static final Type BUGTRAQ = new Type(1, "http://www.securityfocus.com/bid/");
        public static final Type CVE = new Type(2, "http://cve.mitre.org/cgi-bin/cvename.cgi?name=");
        public static final Type NESSUS = new Type(3, "http://cgi.nessus.org/plugins/dump.php3?id=");
        public static final Type ARACHNIDS = new Type(4, "http://www.whitehats.com/info/IDS");
        public static final Type MCAFEE = new Type(5, "http://vil.nai.com/vil/dispVirus.asp?virus_k=");
        public static final Type URL = new Type(6, "http://");
        public static final Type OSVDB = new Type(7, "http://osvdb.org/show/osvdb/", "/discuss");
        public static final Type USN = new Type(8, "http://www.ubuntu.com/usn/usn-");
        public static final Type MILWORM = new Type(9, "http://milw0rm.com/exploits");
        public static final Type SECUNIA = new Type(10, "http://secunia.com/advisories/", "/");
        public static final Type RHSA = new Type(11, "http://rhn.redhat.com/errata/", ".html");
        public static final Type MICROSOFT_KB = new Type(12, "http://support.microsoft.com/kb/");
        public static final Type MICROSOFT_SB = new Type(13, "http://www.microsoft.com/technet/security/bulletin/", ".mspx");
        public static final Type CWE = new Type(14, "http://cwe.mitre.org/data/definitions/", ".html");
        private Type type;
        private String value;

        public Reference(Type type, String value) {
            this.type = type;
            this.value = value;
        }

        public static Reference parse(String value) throws InvalidDefinitionException {
            int firstComma = value.indexOf(44);
            if (firstComma < 0) {
                throw new InvalidDefinitionException("Reference is invalid");
            }
            String type = value.substring(0, firstComma).trim();
            String argument = value.substring(firstComma + 1).trim();
            if (type.equalsIgnoreCase("bugtraq")) {
                return new Reference(BUGTRAQ, argument);
            }
            if (type.equalsIgnoreCase("cve")) {
                return new Reference(CVE, argument);
            }
            if (type.equalsIgnoreCase("nessus")) {
                return new Reference(NESSUS, argument);
            }
            if (type.equalsIgnoreCase("arachnids")) {
                return new Reference(ARACHNIDS, argument);
            }
            if (type.equalsIgnoreCase("mcafee")) {
                return new Reference(MCAFEE, argument);
            }
            if (type.equalsIgnoreCase("url")) {
                return new Reference(URL, argument);
            }
            if (type.equalsIgnoreCase("osvdb")) {
                return new Reference(OSVDB, argument);
            }
            if (type.equalsIgnoreCase("usn")) {
                return new Reference(USN, argument);
            }
            if (type.equalsIgnoreCase("milworm")) {
                return new Reference(MILWORM, argument);
            }
            if (type.equalsIgnoreCase("secunia")) {
                return new Reference(SECUNIA, argument);
            }
            if (type.equalsIgnoreCase("rhsa")) {
                return new Reference(RHSA, argument);
            }
            if (type.equalsIgnoreCase("microsoft_kb")) {
                return new Reference(MICROSOFT_KB, argument);
            }
            if (type.equalsIgnoreCase("microsoft_bulletin")) {
                return new Reference(MICROSOFT_SB, argument);
            }
            if (type.equalsIgnoreCase("cwe")) {
                return new Reference(CWE, argument);
            }
            throw new InvalidDefinitionException("Reference name (\"" + type + "\" is invalid");
        }

        public String toString() {
            if (this.type.getUrlSuffix() == null) {
                return String.valueOf(this.type.getUrlPrefix()) + this.value;
            }
            return String.valueOf(this.type.getUrlPrefix()) + this.value + this.type.getUrlSuffix();
        }

        public Type getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public static class Type {
            private int id;
            private String urlPrefix;
            private String urlSuffix = null;

            protected Type(int id, String urlPrefix) {
                this.id = id;
                this.urlPrefix = urlPrefix;
            }

            protected Type(int id, String urlPrefix, String urlSuffix) {
                this.id = id;
                this.urlPrefix = urlPrefix;
                this.urlSuffix = urlSuffix;
            }

            public String getUrlPrefix() {
                return this.urlPrefix;
            }

            public String getUrlSuffix() {
                return this.urlSuffix;
            }

            public boolean equals(Object type) {
                if (type == null) {
                    throw new IllegalArgumentException("Type cannot be null");
                }
                if (type instanceof Type) {
                    return ((Type)type).id == this.id;
                }
                return false;
            }
        }
    }

    public static enum Severity {
        UNDEFINED,
        LOW,
        MEDIUM,
        HIGH;

    }
}

