/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionError;
import net.lukemurphey.nsia.scan.DefinitionSet;

public class DefinitionErrorList {
    protected Vector<DefinitionError> definitionsErrors = new Vector();
    private static Boolean errorsNoted = null;

    public static synchronized boolean errorsNoted(Application application) throws NoDatabaseConnectionException, SQLException {
        if (errorsNoted == null) {
            DefinitionErrorList errors = DefinitionErrorList.load(application);
            errorsNoted = errors != null && errors.getErrorsList() != null && errors.getErrorsList().length > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return errorsNoted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOutdatedErrors(DefinitionSet set) throws NoDatabaseConnectionException, SQLException {
        Vector<DefinitionError> vector = this.definitionsErrors;
        synchronized (vector) {
            Iterator<DefinitionError> it = this.definitionsErrors.iterator();
            Connection connection = null;
            try {
                connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                while (it.hasNext()) {
                    DefinitionError definitionError = it.next();
                    try {
                        Definition definition = set.getDefinition(definitionError.getDefinitionID());
                        if (definition.revision == definitionError.definitionVersion) continue;
                        definitionError.clear(connection);
                        it.remove();
                    }
                    catch (NotFoundException e) {
                        definitionError.clear(connection);
                        it.remove();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        if (this.definitionsErrors.size() == 0) {
            errorsNoted = false;
        }
    }

    public DefinitionError[] getErrorsList() {
        DefinitionError[] errors = new DefinitionError[this.definitionsErrors.size()];
        this.definitionsErrors.toArray(errors);
        return errors;
    }

    public static void logError(String definitionName, int definitionVersion, String errorName, String notes, int definitionID, int localDefinitionID) {
        DefinitionError error = new DefinitionError(definitionName, definitionVersion, new Date(), errorName, notes, definitionID, localDefinitionID);
        try {
            error.save();
            errorsNoted = null;
        }
        catch (NoDatabaseConnectionException e) {
            Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.DATABASE_FAILURE), e);
        }
        catch (SQLException e) {
            Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.SQL_EXCEPTION), e);
        }
    }

    public static DefinitionErrorList load(Application app) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            connection = app.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Select * from DefinitionErrorLog where Relevant = 1");
            DefinitionErrorList list = new DefinitionErrorList();
            result = statement.executeQuery();
            while (result.next()) {
                list.definitionsErrors.add(DefinitionError.loadFromResult(result));
            }
            DefinitionErrorList definitionErrorList = list;
            return definitionErrorList;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }
}

