/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionMatch;
import net.lukemurphey.nsia.scan.InvalidDefinitionException;
import org.apache.commons.lang.StringEscapeUtils;

public class DefinitionPolicyDescriptor {
    private int siteGroupId = -1;
    private int ruleId = -1;
    private String definitionName;
    private String definitionCategory;
    private String definitionSubCategory;
    private URL url;
    private DefinitionPolicyAction action = DefinitionPolicyAction.EXCLUDE;
    private DefinitionPolicyScope scope;
    private int definitionPolicyEntryId = -1;

    public DefinitionPolicyDescriptor(int siteGroupId, int ruleId, String definitionName, String definitionCategory, String definitionSubCategory, URL url, DefinitionPolicyAction action) {
        this.siteGroupId = siteGroupId;
        this.ruleId = ruleId;
        this.definitionName = definitionName;
        this.definitionCategory = definitionCategory;
        this.definitionSubCategory = definitionSubCategory;
        this.url = url;
        this.action = action;
        this.scope = ruleId >= 0 ? DefinitionPolicyScope.RULE : (siteGroupId >= 0 ? DefinitionPolicyScope.SITEGROUP : DefinitionPolicyScope.GLOBAL);
    }

    public int getSiteGroupID() {
        return this.siteGroupId;
    }

    public static DefinitionPolicyDescriptor createDefinitionPolicy(String definitionCategory, String definitionSubCategory, String definitionName, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(-1, -1, definitionName, definitionCategory, definitionSubCategory, null, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createDefinitionPolicy(int siteGroupId, int ruleID, String definitionCategory, String definitionSubCategory, String definitionName, URL url, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupId, ruleID, definitionName, definitionCategory, definitionSubCategory, url, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createDefinitionPolicy(int siteGroupId, String definitionCategory, String definitionSubCategory, String definitionName, URL url, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupId, -1, definitionName, definitionCategory, definitionSubCategory, url, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createDefinitionPolicy(int siteGroupId, String definitionCategory, String definitionSubCategory, String definitionName, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupId, -1, definitionName, definitionCategory, definitionSubCategory, null, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createDefinitionPolicy(int ruleId, DefinitionMatch match, URL url, DefinitionPolicyAction action) {
        try {
            String[] name = Definition.parseName(match.getDefinitionName());
            String definitionCategory = name[0];
            String definitionSubCategory = name[1];
            String definitionName = name[2];
            DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(-1, ruleId, definitionName, definitionCategory, definitionSubCategory, url, action);
            return exception;
        }
        catch (InvalidDefinitionException e) {
            return null;
        }
    }

    public static DefinitionPolicyDescriptor createDefinitionPolicy(String definitionCategory, String definitionSubCategory, String definitionName, URL url, DefinitionPolicyAction action, int ruleId) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(-1, ruleId, definitionName, definitionCategory, definitionSubCategory, url, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createDefinitionPolicy(String definitionCategory, String definitionSubCategory, String definitionName, URL url, DefinitionPolicyAction action, int ruleId, int siteGroupID) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupID, ruleId, definitionName, definitionCategory, definitionSubCategory, url, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createDefinitionPolicy(String definitionCategory, String definitionSubCategory, String definitionName, URL url, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(-1, -1, definitionName, definitionCategory, definitionSubCategory, url, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createCategoryPolicy(String definitionCategory, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(-1, -1, null, definitionCategory, null, null, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createCategoryPolicy(int siteGroupId, String definitionCategory, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupId, -1, null, definitionCategory, null, null, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createCategoryPolicy(String definitionCategory, URL url, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(-1, -1, null, definitionCategory, null, url, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createCategoryPolicy(int siteGroupId, int ruleID, String definitionCategory, URL url, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupId, ruleID, null, definitionCategory, null, url, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createCategoryPolicy(int siteGroupId, int ruleID, String definitionCategory, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupId, ruleID, null, definitionCategory, null, null, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createCategoryPolicy(int siteGroupId, String definitionCategory, URL url, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupId, -1, null, definitionCategory, null, url, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createSubCategoryPolicy(int siteGroupId, int ruleID, String category, String subCategory, URL url, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupId, ruleID, null, category, subCategory, url, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createSubCategoryPolicy(int siteGroupId, String category, String subCategory, URL url, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupId, -1, null, category, subCategory, url, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createSubCategoryPolicy(int siteGroupId, int ruleID, String category, String subCategory, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupId, ruleID, null, category, subCategory, null, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createSubCategoryPolicy(int siteGroupId, String categoryName, String subCategory, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupId, -1, null, categoryName, subCategory, null, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createDefinitionNamePolicy(int siteGroupId, String definitionName, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(siteGroupId, -1, definitionName, null, null, null, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createSubCategoryPolicy(String category, String subCategory, URL url, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(-1, -1, null, category, subCategory, url, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createSubCategoryPolicy(String categoryName, String subCategory, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(-1, -1, null, categoryName, subCategory, null, action);
        return exception;
    }

    public static DefinitionPolicyDescriptor createSignatureNamePolicy(String definitionName, DefinitionPolicyAction action) {
        DefinitionPolicyDescriptor exception = new DefinitionPolicyDescriptor(-1, -1, definitionName, null, null, null, action);
        return exception;
    }

    private DefinitionPolicyDescriptor() {
    }

    public DefinitionPolicyAction getAction() {
        return this.action;
    }

    public DefinitionPolicyType getPolicyType() {
        if (this.definitionName != null) {
            return DefinitionPolicyType.NAME;
        }
        if (this.definitionSubCategory != null) {
            return DefinitionPolicyType.SUBCATEGORY;
        }
        if (this.definitionCategory != null) {
            return DefinitionPolicyType.CATEGORY;
        }
        if (this.url != null) {
            return DefinitionPolicyType.URL;
        }
        return DefinitionPolicyType.URL;
    }

    public DefinitionPolicyScope getPolicyScope() {
        return this.scope;
    }

    public int getPolicyID() {
        return this.definitionPolicyEntryId;
    }

    public int getPolicyRuleID() {
        return this.ruleId;
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public String getDefinitionCategory() {
        return this.definitionCategory;
    }

    public String getDefinitionSubCategory() {
        return this.definitionSubCategory;
    }

    public URL getURL() {
        return this.url;
    }

    protected static DefinitionPolicyDescriptor loadFromResult(ResultSet resultSet) throws SQLException, MalformedURLException {
        DefinitionPolicyDescriptor ruleFilter = new DefinitionPolicyDescriptor();
        ruleFilter.siteGroupId = DefinitionPolicyDescriptor.defaultIfNull(resultSet, "SiteGroupID", -1);
        ruleFilter.ruleId = DefinitionPolicyDescriptor.defaultIfNull(resultSet, "RuleID", -1);
        ruleFilter.definitionName = resultSet.getString("DefinitionName");
        ruleFilter.definitionCategory = resultSet.getString("DefinitionCategory");
        ruleFilter.definitionSubCategory = resultSet.getString("DefinitionSubCategory");
        ruleFilter.definitionPolicyEntryId = resultSet.getInt("DefinitionPolicyID");
        ruleFilter.action = DefinitionPolicyAction.fromInt(resultSet.getInt("Action"));
        String url = resultSet.getString("URL");
        if (url != null) {
            ruleFilter.url = new URL(url);
        }
        ruleFilter.scope = ruleFilter.ruleId >= 0 ? DefinitionPolicyScope.RULE : (ruleFilter.siteGroupId >= 0 ? DefinitionPolicyScope.SITEGROUP : DefinitionPolicyScope.GLOBAL);
        return ruleFilter;
    }

    private void addAnd(StringBuffer where, String appendStatement) {
        if (where.length() > 0) {
            where.append(" AND ");
        }
        where.append(appendStatement);
    }

    private void purgeIdenticalEntries(Connection connection) throws SQLException {
        StringBuffer whereClause = new StringBuffer();
        if (this.siteGroupId >= 0) {
            this.addAnd(whereClause, " SiteGroupID = ");
            whereClause.append(this.siteGroupId);
        } else {
            this.addAnd(whereClause, " (SiteGroupID is null or SiteGroupID = -1)");
        }
        if (this.ruleId >= 0) {
            this.addAnd(whereClause, " RuleID = ");
            whereClause.append(this.ruleId);
        } else {
            this.addAnd(whereClause, " (RuleID is null or RuleID = -1)");
        }
        if (this.definitionName != null) {
            this.addAnd(whereClause, " DefinitionName = ");
            whereClause.append("'" + StringEscapeUtils.escapeSql((String)this.definitionName) + "'");
        } else {
            this.addAnd(whereClause, " DefinitionName is null ");
        }
        if (this.definitionCategory != null) {
            this.addAnd(whereClause, " DefinitionCategory = ");
            whereClause.append("'" + StringEscapeUtils.escapeSql((String)this.definitionCategory) + "'");
        } else {
            this.addAnd(whereClause, " DefinitionCategory is null ");
        }
        if (this.definitionSubCategory != null) {
            this.addAnd(whereClause, " DefinitionSubCategory = ");
            whereClause.append("'" + StringEscapeUtils.escapeSql((String)this.definitionSubCategory) + "'");
        } else {
            this.addAnd(whereClause, " DefinitionSubCategory is null ");
        }
        if (this.url != null) {
            this.addAnd(whereClause, " URL = ");
            whereClause.append("'" + StringEscapeUtils.escapeSql((String)this.url.toString()) + "'");
        } else {
            this.addAnd(whereClause, " URL is null ");
        }
        Statement statement = null;
        try {
            statement = connection.prepareStatement("Delete from DefinitionPolicy where " + whereClause.toString());
            statement.execute();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    public void saveToDatabase(Connection connection) throws SQLException {
        Statement statement = null;
        ResultSet keys = null;
        try {
            connection.setAutoCommit(false);
            this.purgeIdenticalEntries(connection);
            if (this.definitionPolicyEntryId < 0) {
                statement = connection.prepareStatement("Insert into DefinitionPolicy (SiteGroupID, RuleID, DefinitionName, DefinitionCategory, DefinitionSubCategory, URL, Action) values (?, ?, ?, ?, ?, ?, ?)", 1);
                statement.setLong(1, this.siteGroupId);
                statement.setLong(2, this.ruleId);
                if (this.definitionName == null) {
                    statement.setNull(3, 12);
                } else {
                    statement.setString(3, this.definitionName);
                }
                if (this.definitionCategory == null) {
                    statement.setNull(4, 12);
                } else {
                    statement.setString(4, this.definitionCategory);
                }
                if (this.definitionSubCategory == null) {
                    statement.setNull(5, 12);
                } else {
                    statement.setString(5, this.definitionSubCategory);
                }
                if (this.url == null) {
                    statement.setNull(6, 12);
                } else {
                    statement.setString(6, this.url.toString());
                }
                statement.setInt(7, this.action.ordinal());
                statement.executeUpdate();
                keys = statement.getGeneratedKeys();
                if (keys.next()) {
                    this.definitionPolicyEntryId = keys.getInt(1);
                }
            } else {
                statement = connection.prepareStatement("Update DefinitionPolicy set (SiteGroupID = ?, DefinitionID = ?, DefinitionName= ?, DefinitionCategory= ?, DefinitionSubCategory= ?, URL= ?, Action = ?) where DefinitionPolicyID = ?", 1);
                statement.setLong(1, this.siteGroupId);
                statement.setLong(2, this.ruleId);
                if (this.definitionName == null) {
                    statement.setNull(3, 12);
                } else {
                    statement.setString(3, this.definitionName);
                }
                if (this.definitionCategory == null) {
                    statement.setNull(4, 12);
                } else {
                    statement.setString(4, this.definitionCategory);
                }
                if (this.definitionSubCategory == null) {
                    statement.setNull(5, 12);
                } else {
                    statement.setString(5, this.definitionSubCategory);
                }
                if (this.url == null) {
                    statement.setNull(5, 12);
                } else {
                    statement.setString(5, this.url.toString());
                }
                statement.setInt(6, this.action.ordinal());
                statement.setInt(7, this.definitionPolicyEntryId);
                statement.executeUpdate();
            }
            connection.commit();
        }
        finally {
            connection.setAutoCommit(true);
            if (statement != null) {
                statement.close();
            }
            if (keys != null) {
                keys.close();
            }
        }
    }

    private static int defaultIfNull(ResultSet resultSet, String columnName, int defaultValue) throws SQLException {
        int value = resultSet.getInt(columnName);
        if (resultSet.wasNull()) {
            value = defaultValue;
        }
        return value;
    }

    public DefinitionPolicyAction getActionIfMatches(long siteGroupId, long ruleId, String ruleName, String ruleCategory, String ruleSubCategory, String url) {
        return this.matchesInternal(siteGroupId, ruleId, ruleName, ruleCategory, ruleSubCategory, url);
    }

    public DefinitionPolicyAction getActionIfMatches(long siteGroupId, int ruleId, String ruleName, String ruleCategory, String ruleSubCategory) {
        return this.matchesInternal(siteGroupId, ruleId, ruleName, ruleCategory, ruleSubCategory, null);
    }

    private DefinitionPolicyAction matchesInternal(long siteGroupId, long ruleId, String ruleName, String ruleCategory, String ruleSubCategory, String url) {
        if (this.siteGroupId > 0 && (long)this.siteGroupId != siteGroupId) {
            return null;
        }
        if (this.ruleId > 0 && (long)this.ruleId != ruleId) {
            return null;
        }
        if (this.definitionName != null && !this.definitionName.equalsIgnoreCase(ruleName)) {
            return null;
        }
        if (this.definitionCategory != null && !this.definitionCategory.equalsIgnoreCase(ruleCategory)) {
            return null;
        }
        if (this.definitionSubCategory != null && !this.definitionSubCategory.equalsIgnoreCase(ruleSubCategory)) {
            return null;
        }
        if (this.url != null && !this.url.toString().equalsIgnoreCase(url)) {
            return null;
        }
        return this.action;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.definitionCategory != null) {
            buffer.append(this.definitionCategory);
        }
        if (this.definitionSubCategory != null) {
            buffer.append(".");
            buffer.append(this.definitionSubCategory);
        }
        if (this.definitionName != null) {
            buffer.append(".");
            buffer.append(this.definitionName);
        }
        if (this.url != null) {
            if (buffer.length() > 0) {
                buffer.append(" for ");
            }
            buffer.append(this.url);
        }
        return buffer.toString();
    }

    public DefinitionPolicyAction getActionIfMatches(long siteGroupId, long ruleId, String ruleName, String ruleCategory, String ruleSubCategory, URL url) {
        if (url != null) {
            return this.matchesInternal(siteGroupId, ruleId, ruleName, ruleCategory, ruleSubCategory, url.toString());
        }
        return this.matchesInternal(siteGroupId, ruleId, ruleName, ruleCategory, ruleSubCategory, null);
    }

    public static enum DefinitionPolicyAction {
        INCLUDE,
        EXCLUDE;


        public static DefinitionPolicyAction fromInt(int i) {
            if (i == INCLUDE.ordinal()) {
                return INCLUDE;
            }
            if (i == EXCLUDE.ordinal()) {
                return EXCLUDE;
            }
            return EXCLUDE;
        }
    }

    public static enum DefinitionPolicyScope {
        GLOBAL,
        SITEGROUP,
        RULE;

    }

    public static enum DefinitionPolicyType {
        NAME,
        CATEGORY,
        SUBCATEGORY,
        URL;

    }
}

