/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.MaxMinCount;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionPolicyDescriptor;

public class DefinitionPolicySet {
    private Vector<DefinitionPolicyDescriptor> definitionPolicies = new Vector();

    private DefinitionPolicySet() {
    }

    public DefinitionPolicySet(Vector<DefinitionPolicyDescriptor> descriptors) {
        this.definitionPolicies.addAll(descriptors);
        this.sort();
    }

    public DefinitionPolicySet(DefinitionPolicyDescriptor ... descriptors) {
        DefinitionPolicyDescriptor[] definitionPolicyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            DefinitionPolicyDescriptor descriptor = definitionPolicyDescriptorArray[n2];
            if (descriptor != null) {
                this.definitionPolicies.add(descriptor);
            }
            ++n2;
        }
        this.sort();
    }

    public static MaxMinCount getScanPolicyInfoForRule(Connection connection, int ruleID) throws SQLException {
        return DefinitionPolicySet.getScanPolicyInfoForRule(connection, ruleID);
    }

    public static MaxMinCount getScanPolicyInfoForRule(Connection connection, int ruleID, String searchText) throws SQLException {
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            if (searchText != null && searchText.trim().length() > 0) {
                String[] parsedName = searchText.split("[.]", 3);
                if (parsedName.length == 1) {
                    statement = connection.prepareStatement("Select max(DefinitionPolicyID), min(DefinitionPolicyID), count(*) from DefinitionPolicy where RuleID = ? and (DefinitionName like ? or DefinitionCategory like ? or DefinitionSubCategory like ? or URL like ?)");
                    statement.setString(2, "%" + parsedName[0] + "%");
                    statement.setString(3, "%" + parsedName[0] + "%");
                    statement.setString(4, "%" + parsedName[0] + "%");
                    statement.setString(5, "%" + searchText + "%");
                } else if (parsedName.length == 2) {
                    statement = connection.prepareStatement("Select max(DefinitionPolicyID), min(DefinitionPolicyID), count(*) from DefinitionPolicy where RuleID = ? and ( (DefinitionCategory like ? and DefinitionSubCategory like ?) or URL like ?)");
                    statement.setString(2, "%" + parsedName[0]);
                    statement.setString(3, String.valueOf(parsedName[1]) + "%");
                    statement.setString(4, "%" + searchText + "%");
                } else {
                    statement = connection.prepareStatement("Select max(DefinitionPolicyID), min(DefinitionPolicyID), count(*) from DefinitionPolicy where RuleID = ? and ( (DefinitionName like ? and DefinitionCategory like ? and DefinitionSubCategory like ?) or URL like ?)");
                    statement.setString(2, String.valueOf(parsedName[2]) + "%");
                    statement.setString(3, "%" + parsedName[0]);
                    statement.setString(4, parsedName[1]);
                    statement.setString(5, "%" + searchText + "%");
                }
            } else {
                statement = connection.prepareStatement("Select max(DefinitionPolicyID), min(DefinitionPolicyID), count(*) from DefinitionPolicy where RuleID = ?");
            }
            statement.setInt(1, ruleID);
            result = statement.executeQuery();
            if (result.next()) {
                MaxMinCount maxMinCount = new MaxMinCount(result.getInt(1), result.getInt(2), result.getInt(3));
                return maxMinCount;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
        return null;
    }

    public static DefinitionPolicySet getPolicySetForRule(Connection connection, int ruleID) throws SQLException {
        return DefinitionPolicySet.getPolicySetForRule(connection, ruleID, 100000, 1);
    }

    public static DefinitionPolicySet getPolicySetForRule(Connection connection, int ruleID, int recordCount, int page) throws SQLException {
        return DefinitionPolicySet.getPolicySetForRule(connection, ruleID, recordCount, page, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DefinitionPolicySet getPolicySetForRule(Connection connection, int ruleID, int recordCount, int page, String searchText) throws SQLException {
        if (recordCount <= 0) {
            recordCount = 25;
        }
        if (page <= 0) {
            page = 1;
        }
        Statement statement = null;
        ResultSet result = null;
        DefinitionPolicySet filterSet = new DefinitionPolicySet();
        try {
            block14: {
                block16: {
                    if (searchText == null || searchText.trim().length() <= 0) break block16;
                    String[] parsedName = searchText.split("[.]", 3);
                    if (parsedName.length == 1) {
                        statement = connection.prepareStatement("Select * from DefinitionPolicy where RuleID = ? and (DefinitionName like ? or DefinitionCategory like ? or DefinitionSubCategory like ? or URL like ?) order by DefinitionPolicyID asc", 1004, 1007);
                        statement.setString(2, "%" + parsedName[0] + "%");
                        statement.setString(3, "%" + parsedName[0] + "%");
                        statement.setString(4, "%" + parsedName[0] + "%");
                        statement.setString(5, "%" + searchText + "%");
                        break block14;
                    } else if (parsedName.length == 2) {
                        statement = connection.prepareStatement("Select * from DefinitionPolicy where RuleID = ? and ( (DefinitionCategory like ? and DefinitionSubCategory like ?) or URL like ?) order by DefinitionPolicyID asc", 1004, 1007);
                        statement.setString(2, "%" + parsedName[0]);
                        statement.setString(3, String.valueOf(parsedName[1]) + "%");
                        statement.setString(4, "%" + searchText + "%");
                        break block14;
                    } else {
                        statement = connection.prepareStatement("Select * from DefinitionPolicy where RuleID = ? and ( (DefinitionName like ? and DefinitionCategory like ? and DefinitionSubCategory like ?) or URL like ?) order by DefinitionPolicyID asc", 1004, 1007);
                        statement.setString(2, String.valueOf(parsedName[2]) + "%");
                        statement.setString(3, "%" + parsedName[0]);
                        statement.setString(4, parsedName[1]);
                        statement.setString(5, "%" + searchText + "%");
                    }
                    break block14;
                }
                statement = connection.prepareStatement("Select * from DefinitionPolicy where RuleID = ? order by DefinitionPolicyID asc", 1004, 1007);
            }
            statement.setInt(1, ruleID);
            result = statement.executeQuery();
            result.setFetchSize(recordCount);
            result.absolute((page - 1) * recordCount);
            while (result.next() && filterSet.definitionPolicies.size() <= recordCount) {
                try {
                    filterSet.definitionPolicies.add(DefinitionPolicyDescriptor.loadFromResult(result));
                }
                catch (MalformedURLException e) {
                    Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Invalid URL was observed when loading definition policy")), (Throwable)e);
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
        filterSet.sort();
        return filterSet;
    }

    public static DefinitionPolicySet getPolicySetForSiteGroup(Connection connection, int siteGroupId, int ruleID) throws SQLException {
        PreparedStatement statement = null;
        ResultSet result = null;
        DefinitionPolicySet filterSet = new DefinitionPolicySet();
        try {
            statement = connection.prepareStatement("Select * from DefinitionPolicy where (SiteGroupID is null or SiteGroupID = ? or SiteGroupID = -1) and RuleID = ?");
            statement.setInt(1, siteGroupId);
            statement.setInt(2, ruleID);
            result = statement.executeQuery();
            while (result.next()) {
                try {
                    filterSet.definitionPolicies.add(DefinitionPolicyDescriptor.loadFromResult(result));
                }
                catch (MalformedURLException e) {
                    Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Invalid URL was observed when loading definition policy")), (Throwable)e);
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
        filterSet.sort();
        return filterSet;
    }

    public static DefinitionPolicySet getPolicySetForSiteGroup(Connection connection, long siteGroupId) throws SQLException {
        PreparedStatement statement = null;
        ResultSet result = null;
        DefinitionPolicySet filterSet = new DefinitionPolicySet();
        try {
            statement = connection.prepareStatement("Select * from DefinitionPolicy where SiteGroupID is null or SiteGroupID = -1 or SiteGroupID = ?");
            statement.setLong(1, siteGroupId);
            result = statement.executeQuery();
            while (result.next()) {
                try {
                    filterSet.definitionPolicies.add(DefinitionPolicyDescriptor.loadFromResult(result));
                }
                catch (MalformedURLException e) {
                    Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Invalid URL was observed when loading definition policy")), (Throwable)e);
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
        filterSet.sort();
        return filterSet;
    }

    private void sort() {
        Collections.sort(this.definitionPolicies, new DefinitionPolicyComparator());
    }

    public static DefinitionPolicySet getPolicySet(Connection connection) throws SQLException {
        PreparedStatement statement = null;
        ResultSet result = null;
        DefinitionPolicySet filterSet = new DefinitionPolicySet();
        try {
            statement = connection.prepareStatement("Select * from DefinitionPolicy");
            result = statement.executeQuery();
            while (result.next()) {
                try {
                    filterSet.definitionPolicies.add(DefinitionPolicyDescriptor.loadFromResult(result));
                }
                catch (MalformedURLException e) {
                    Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Invalid URL was observed when loading definition policy")), (Throwable)e);
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
        filterSet.sort();
        return filterSet;
    }

    public DefinitionPolicyDescriptor[] getRuleFiltersArray() {
        DefinitionPolicyDescriptor[] filters = new DefinitionPolicyDescriptor[this.definitionPolicies.size()];
        this.definitionPolicies.toArray(filters);
        return filters;
    }

    public DefinitionPolicyDescriptor get(int c) {
        return this.definitionPolicies.get(c);
    }

    public int size() {
        return this.definitionPolicies.size();
    }

    public int getExcludePolicyCount() {
        return this.getPolicyTypeCount(DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE);
    }

    public int getIncludePolicyCount() {
        return this.getPolicyTypeCount(DefinitionPolicyDescriptor.DefinitionPolicyAction.INCLUDE);
    }

    public int getPolicyTypeCount(DefinitionPolicyDescriptor.DefinitionPolicyAction action) {
        int c = 0;
        for (DefinitionPolicyDescriptor policy : this.definitionPolicies) {
            if (policy.getAction() != action) continue;
            ++c;
        }
        return c;
    }

    public DefinitionPolicyDescriptor getMatchingPolicy(long siteGroupId, long ruleId, String ruleName, String ruleCategory, String ruleSubCategory, String url) {
        int c = 0;
        while (c < this.definitionPolicies.size()) {
            DefinitionPolicyDescriptor.DefinitionPolicyAction action = this.definitionPolicies.get(c).getActionIfMatches(siteGroupId, ruleId, ruleName, ruleCategory, ruleSubCategory, url);
            if (action != null) {
                return this.definitionPolicies.get(c);
            }
            ++c;
        }
        return null;
    }

    public DefinitionPolicyDescriptor.DefinitionPolicyAction getPolicyAction(long siteGroupId, long ruleId, String ruleName, String ruleCategory, String ruleSubCategory, String url) {
        int c = 0;
        while (c < this.definitionPolicies.size()) {
            DefinitionPolicyDescriptor.DefinitionPolicyAction action = this.definitionPolicies.get(c).getActionIfMatches(siteGroupId, ruleId, ruleName, ruleCategory, ruleSubCategory, url);
            if (action != null) {
                return action;
            }
            ++c;
        }
        return null;
    }

    public boolean isFiltered(long ruleId, Definition definition, String url) {
        int c = 0;
        while (c < this.definitionPolicies.size()) {
            DefinitionPolicyDescriptor.DefinitionPolicyAction action = this.definitionPolicies.get(c).getActionIfMatches(-1L, ruleId, definition.getName(), definition.getCategoryName(), definition.getSubCategoryName(), url);
            if (action != null) {
                if (action == DefinitionPolicyDescriptor.DefinitionPolicyAction.INCLUDE) {
                    return false;
                }
                if (action == DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE) {
                    return true;
                }
            }
            ++c;
        }
        return false;
    }

    public boolean isFiltered(long siteGroupId, long ruleId, Definition definition, String url) {
        int c = 0;
        while (c < this.definitionPolicies.size()) {
            DefinitionPolicyDescriptor.DefinitionPolicyAction action = this.definitionPolicies.get(c).getActionIfMatches(siteGroupId, ruleId, definition.getName(), definition.getCategoryName(), definition.getSubCategoryName(), url);
            if (action != null) {
                if (action == DefinitionPolicyDescriptor.DefinitionPolicyAction.INCLUDE) {
                    return false;
                }
                if (action == DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE) {
                    return true;
                }
            }
            ++c;
        }
        return false;
    }

    public boolean isFiltered(long siteGroupId, long ruleId, Definition definition, URL url) {
        int c = 0;
        while (c < this.definitionPolicies.size()) {
            DefinitionPolicyDescriptor.DefinitionPolicyAction action = this.definitionPolicies.get(c).getActionIfMatches(siteGroupId, ruleId, definition.getName(), definition.getCategoryName(), definition.getSubCategoryName(), url);
            if (action != null) {
                if (action == DefinitionPolicyDescriptor.DefinitionPolicyAction.INCLUDE) {
                    return false;
                }
                if (action == DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE) {
                    return true;
                }
            }
            ++c;
        }
        return false;
    }

    public boolean isFiltered(long siteGroupId, long ruleId, String ruleName, String ruleCategory, String ruleSubCategory, URL url) {
        int c = 0;
        while (c < this.definitionPolicies.size()) {
            DefinitionPolicyDescriptor.DefinitionPolicyAction action = this.definitionPolicies.get(c).getActionIfMatches(siteGroupId, ruleId, ruleName, ruleCategory, ruleSubCategory, url);
            if (action != null) {
                if (action == DefinitionPolicyDescriptor.DefinitionPolicyAction.INCLUDE) {
                    return false;
                }
                if (action == DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE) {
                    return true;
                }
            }
            ++c;
        }
        return false;
    }

    public boolean isFiltered(long ruleId, String ruleName, String ruleCategory, String ruleSubCategory, URL url) {
        int c = 0;
        while (c < this.definitionPolicies.size()) {
            DefinitionPolicyDescriptor.DefinitionPolicyAction action = this.definitionPolicies.get(c).getActionIfMatches(-1L, ruleId, ruleName, ruleCategory, ruleSubCategory, url);
            if (action != null) {
                if (action == DefinitionPolicyDescriptor.DefinitionPolicyAction.INCLUDE) {
                    return false;
                }
                if (action == DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE) {
                    return true;
                }
            }
            ++c;
        }
        return false;
    }

    private static class DefinitionPolicyComparator
    implements Comparator<DefinitionPolicyDescriptor> {
        private DefinitionPolicyComparator() {
        }

        @Override
        public int compare(DefinitionPolicyDescriptor first, DefinitionPolicyDescriptor second) {
            if (first == null) {
                return 1;
            }
            if (second == null) {
                return -1;
            }
            if (first.getPolicyScope() == second.getPolicyScope()) {
                return 0;
            }
            if (first.getPolicyScope() == DefinitionPolicyDescriptor.DefinitionPolicyScope.RULE) {
                return -1;
            }
            if (second.getPolicyScope() == DefinitionPolicyDescriptor.DefinitionPolicyScope.RULE) {
                return 1;
            }
            if (first.getPolicyScope() == DefinitionPolicyDescriptor.DefinitionPolicyScope.SITEGROUP) {
                return -1;
            }
            if (second.getPolicyScope() == DefinitionPolicyDescriptor.DefinitionPolicyScope.SITEGROUP) {
                return 1;
            }
            if (first.getPolicyScope() == DefinitionPolicyDescriptor.DefinitionPolicyScope.GLOBAL) {
                return -1;
            }
            if (second.getPolicyScope() == DefinitionPolicyDescriptor.DefinitionPolicyScope.GLOBAL) {
                return 1;
            }
            return 0;
        }
    }
}

