/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DuplicateEntryException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.DataSpecimen;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionEvaluationException;
import net.lukemurphey.nsia.scan.DefinitionMatch;
import net.lukemurphey.nsia.scan.DefinitionPolicyDescriptor;
import net.lukemurphey.nsia.scan.DefinitionPolicySet;
import net.lukemurphey.nsia.scan.DefinitionSetLoadException;
import net.lukemurphey.nsia.scan.HttpResponseData;
import net.lukemurphey.nsia.scan.InvalidDefinitionException;
import net.lukemurphey.nsia.scan.PatternDefinition;
import net.lukemurphey.nsia.scan.ScriptDefinition;
import net.lukemurphey.nsia.scan.URLToScan;
import net.lukemurphey.nsia.scan.UnpurposedDefinitionException;
import net.lukemurphey.nsia.scan.scriptenvironment.Result;
import net.lukemurphey.nsia.scan.scriptenvironment.Variables;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefinitionSet {
    private Vector<Definition> definitions = new Vector();
    private Date definitionSetDate = null;
    private String definitionVersionString = null;
    private int countOfCustomDefinitions = -1;
    public static final String DEFINITION_SET_DATE_FORMAT = "MMM dd HH:mm:ss Z yyyy";

    public DefinitionSet(Date definitionSetDate, Definition[] definitions, String versionIdentifier) {
        if (definitions == null) {
            throw new IllegalArgumentException("The definitions given must not be null");
        }
        int c = 0;
        while (c < definitions.length) {
            this.definitions.add(definitions[c]);
            ++c;
        }
        this.definitionVersionString = versionIdentifier;
        this.definitionSetDate = definitionSetDate != null ? (Date)definitionSetDate.clone() : null;
        this.getCustomDefinitionsCount();
    }

    public DefinitionSet(Date definitionSetDate, Vector<Definition> definitions, String version) {
        if (definitions == null) {
            throw new IllegalArgumentException("The definitions given must not be null");
        }
        this.definitions = definitions;
        this.definitionVersionString = version;
        this.definitionSetDate = definitionSetDate != null ? (Date)definitionSetDate.clone() : null;
        this.getCustomDefinitionsCount();
    }

    public DefinitionVersionID getVersionID() {
        if (this.definitionVersionString == null) {
            return null;
        }
        return new DefinitionVersionID(this.definitionVersionString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition[] getDefinitionsSorted() {
        Vector<Definition> sortedList = new Vector<Definition>(this.definitions.size());
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            sortedList.addAll(this.definitions);
        }
        Collections.sort(sortedList, new DefinitionComparator());
        Definition[] definitionsArray = new Definition[sortedList.size()];
        sortedList.toArray(definitionsArray);
        return definitionsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition[] getDefinitions() {
        Definition[] sigsArray = new Definition[this.definitions.size()];
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            this.definitions.toArray(sigsArray);
        }
        return sigsArray;
    }

    public Date getDefinitionSetDate() {
        if (this.definitionSetDate == null) {
            return null;
        }
        return (Date)this.definitionSetDate.clone();
    }

    private static String getTextContent(Node element) {
        if (element.getNodeType() == 9 || element.getNodeType() == 10 || element.getNodeType() == 12) {
            return null;
        }
        if (element.getNodeType() == 3 || element.getNodeType() == 4 || element.getNodeType() == 8 || element.getNodeType() == 7) {
            return element.getNodeValue();
        }
        StringBuffer buffer = new StringBuffer();
        NodeList nodes = element.getChildNodes();
        int c = 0;
        while (c < nodes.getLength()) {
            buffer.append(DefinitionSet.getTextContent(nodes.item(c)));
            ++c;
        }
        return buffer.toString();
    }

    public static DefinitionSet loadFromXml(Document document) throws DefinitionSetLoadException {
        DefinitionSet sigSet;
        if (document == null) {
            throw new IllegalArgumentException("The XML document cannot be null");
        }
        Element rootElement = document.getDocumentElement();
        String date = rootElement.getAttribute("Date");
        String version = rootElement.getAttribute("Version");
        if (date == null || date.length() == 0) {
            throw new DefinitionSetLoadException("Definition set date is invalid (is empty)");
        }
        if (version == null || version.length() == 0) {
            throw new DefinitionSetLoadException("Definition set version is invalid (is empty)");
        }
        Vector<ScriptDefinition> sigs = new Vector<ScriptDefinition>();
        NodeList definitionNodes = rootElement.getElementsByTagName("Definition");
        int c = 0;
        while (c < definitionNodes.getLength()) {
            Element element = (Element)definitionNodes.item(c);
            String type = element.getAttribute("Type");
            Text text = (Text)element.getFirstChild();
            String code = text.getNodeValue();
            try {
                Definition contentSig;
                if (type == null) {
                    throw new DefinitionSetLoadException("The type field cannot be null");
                }
                if (type.equalsIgnoreCase("Script")) {
                    contentSig = ScriptDefinition.parse(code);
                    sigs.add((ScriptDefinition)contentSig);
                } else if (type.equalsIgnoreCase("Pattern")) {
                    contentSig = PatternDefinition.parse(code);
                    sigs.add((ScriptDefinition)contentSig);
                }
            }
            catch (UnpurposedDefinitionException e) {
                throw new DefinitionSetLoadException("Invalid definition observed (has no purpose): " + DefinitionSet.getTextContent(element), e);
            }
            catch (InvalidDefinitionException e) {
                throw new DefinitionSetLoadException("Invalid definition detected (could not be parsed): " + DefinitionSet.getTextContent(element), e);
            }
            ++c;
        }
        Definition[] definitions = new Definition[sigs.size()];
        sigs.toArray(definitions);
        if (definitions.length == 0) {
            throw new DefinitionSetLoadException("No definitions were found to import");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFINITION_SET_DATE_FORMAT);
        try {
            sigSet = new DefinitionSet(dateFormat.parse(date), definitions, version);
            return sigSet;
        }
        catch (ParseException e) {
            sigSet = new DefinitionSet(null, definitions, version);
            return sigSet;
        }
    }

    public Definition getDefinition(int id) throws NotFoundException {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            for (Definition definition : this.definitions) {
                if (definition.id != id) continue;
                return definition;
            }
            throw new NotFoundException("No definition could be found with the given identifier");
        }
    }

    public Definition getDefinitionByLocalID(int id) throws NotFoundException {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            for (Definition definition : this.definitions) {
                if (definition.localId != id) continue;
                return definition;
            }
            throw new NotFoundException("No definition could be found with the given identifier");
        }
    }

    public Definition getDefinition(String name) throws NotFoundException {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            for (Definition definition : this.definitions) {
                if (!definition.getFullName().equals(name)) continue;
                return definition;
            }
            throw new NotFoundException("No definition could be found with the given identifier");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefinition(Definition newDefinition) throws SQLException, NoDatabaseConnectionException {
        if (newDefinition == null) {
            throw new IllegalArgumentException("The definition to add cannot be null");
        }
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            this.definitions.add(newDefinition);
        }
        this.getCustomDefinitionsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importPatternDefinitions(String input) throws SQLException, NoDatabaseConnectionException, InvalidDefinitionException, UnpurposedDefinitionException {
        PatternDefinition[] definitions = PatternDefinition.parseAll(input);
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            int c = 0;
            while (c < definitions.length) {
                this.addDefinition(definitions[c]);
                ++c;
            }
        }
        this.getCustomDefinitionsCount();
    }

    public int getOfficialDefinitionsCount() {
        return this.definitions.size() - this.getCustomDefinitionsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCustomDefinitionsCount() {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            this.countOfCustomDefinitions = 0;
            for (Definition definition : this.definitions) {
                if (definition.isOfficial()) continue;
                ++this.countOfCustomDefinitions;
            }
            return this.countOfCustomDefinitions;
        }
    }

    public String getAsXML() {
        return this.getAsXML(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAsXML(boolean getLocalOnly) {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DEFINITION_SET_DATE_FORMAT);
            StringBuffer xml = new StringBuffer();
            if (getLocalOnly) {
                xml.append("<Definitions Type=\"Custom\" Date=\"" + dateFormat.format(this.definitionSetDate) + "\" Version=\"" + this.definitionVersionString + "\" >\n");
            } else {
                xml.append("<Definitions Date=\"" + dateFormat.format(this.definitionSetDate) + "\" Version=\"" + this.definitionVersionString + "\" >\n");
            }
            for (Definition definition : this.definitions) {
                if (getLocalOnly && definition.isOfficial()) continue;
                if (definition instanceof PatternDefinition) {
                    PatternDefinition pattern = (PatternDefinition)definition;
                    xml.append("<Definition Type=\"Pattern\" " + DefinitionSet.getAttributes(pattern) + ">");
                    xml.append(StringEscapeUtils.escapeXml((String)pattern.getRuleCode()));
                    xml.append("</Definition>");
                    continue;
                }
                if (!(definition instanceof ScriptDefinition)) continue;
                ScriptDefinition script = (ScriptDefinition)definition;
                xml.append("<Definition Type=\"Script\" " + DefinitionSet.getAttributes(script) + ">");
                xml.append(StringEscapeUtils.escapeXml((String)script.getScript()));
                xml.append("</Definition>");
            }
            xml.append("</Definitions>\n");
            return xml.toString();
        }
    }

    private static String getAttributes(Definition definition) {
        if (definition != null) {
            return "Message=\"" + StringEscapeUtils.escapeXml((String)definition.getMessage()) + "\" Name=\"" + StringEscapeUtils.escapeXml((String)definition.getFullName()) + "\" Severity=\"" + StringEscapeUtils.escapeXml((String)definition.getSeverity().toString()) + "\" ID=\"" + definition.getID() + "\" Version=\"" + definition.getRevision() + "\"";
        }
        return "";
    }

    public static DefinitionSet loadFromFile(File file) throws ParserConfigurationException, SAXException, IOException, DefinitionSetLoadException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return DefinitionSet.loadFromXml(document);
    }

    public static DefinitionSet loadFromString(String xmlString) throws ParserConfigurationException, SAXException, IOException, DefinitionSetLoadException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(xmlString)));
        return DefinitionSet.loadFromXml(document);
    }

    public DefinitionMatchResultSet scan(HttpResponseData httpResponse, Date scanStartDate) throws ScriptException, NoDatabaseConnectionException, SQLException, NoSuchMethodException, InvalidDefinitionException {
        return this.scan(httpResponse, null, -1L, -1L, scanStartDate);
    }

    private boolean isIncludedInPolicy(HttpResponseData httpResponse, DefinitionPolicySet definitionPolicySet, long siteGroupID, long ruleID, Definition definition) {
        if (definitionPolicySet != null) {
            return definitionPolicySet.getPolicyAction(siteGroupID, ruleID, definition.getName(), definition.getCategoryName(), definition.getSubCategoryName(), httpResponse.getLocation()) != DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE && definitionPolicySet.getPolicyAction(siteGroupID, ruleID, definition.getName(), definition.getCategoryName(), definition.getSubCategoryName(), httpResponse.getRequestedLocation()) != DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE;
        }
        return true;
    }

    public DefinitionMatchResultSet scan2(HttpResponseData httpResponse, DefinitionPolicySet definitionPolicySet, long siteGroupID, long ruleID) throws NoDatabaseConnectionException, SQLException, InvalidDefinitionException {
        return this.scan(httpResponse, definitionPolicySet, siteGroupID, ruleID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefinitionMatchResultSet scan(HttpResponseData httpResponse, DefinitionPolicySet definitionPolicySet, long siteGroupID, long ruleID, Date scanStartTime) throws NoDatabaseConnectionException, SQLException, InvalidDefinitionException {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            Vector<DefinitionMatch> definitionMatches = new Vector<DefinitionMatch>();
            Vector<URLToScan> extractedURLs = new Vector<URLToScan>();
            Variables variables = new Variables();
            variables.set("scanStartTime", scanStartTime);
            for (Definition definition : this.definitions) {
                try {
                    if (definition instanceof ScriptDefinition) {
                        ScriptDefinition script = (ScriptDefinition)definition;
                        Result result = script.evaluate(httpResponse, variables, ruleID, scanStartTime);
                        if (!this.isIncludedInPolicy(httpResponse, definitionPolicySet, siteGroupID, ruleID, script)) continue;
                        if (result.getURLs() != null) {
                            extractedURLs.addAll(result.getURLs());
                        }
                        if (!result.matched()) continue;
                        definitionMatches.add(new DefinitionMatch(script.getFullName(), result.getDescription(), script.severity, script.getLocalID(), result.detectStart, result.detectEnd));
                        continue;
                    }
                    if (!(definition instanceof PatternDefinition)) continue;
                    PatternDefinition sig = (PatternDefinition)definition;
                    DataSpecimen specimen = httpResponse.getDataSpecimen();
                    boolean matched = false;
                    if (specimen != null) {
                        matched = sig.evaluate(specimen, variables);
                    }
                    if (!matched || !this.isIncludedInPolicy(httpResponse, definitionPolicySet, siteGroupID, ruleID, sig)) continue;
                    definitionMatches.add(new DefinitionMatch(sig.getFullName(), sig.getMessage(), sig.severity, sig.getLocalID()));
                }
                catch (InvalidDefinitionException e) {
                    Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.SCAN_ENGINE_EXCEPTION, new EventLogField(EventLogField.FieldName.RULE_ID, ruleID)), (Throwable)e);
                }
                catch (DefinitionEvaluationException e) {
                    if (e.getDefinitionID() >= 0) {
                        Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.SCAN_ENGINE_EXCEPTION, new EventLogField(EventLogField.FieldName.RULE_ID, ruleID), new EventLogField(EventLogField.FieldName.DEFINITION_ID, e.getDefinitionID()), new EventLogField(EventLogField.FieldName.DEFINITION_NAME, e.getDefinitionName())), (Throwable)e);
                        continue;
                    }
                    Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.SCAN_ENGINE_EXCEPTION, new EventLogField(EventLogField.FieldName.RULE_ID, ruleID)), (Throwable)e);
                }
            }
            return new DefinitionMatchResultSet(definitionMatches, extractedURLs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getListOfCategories() {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            Vector<String> categories = new Vector<String>();
            for (Definition sig : this.definitions) {
                boolean found = false;
                int c = 0;
                while (c < categories.size() && !found) {
                    if (((String)categories.get(c)).equalsIgnoreCase(sig.category)) {
                        found = true;
                    }
                    ++c;
                }
                if (found) continue;
                categories.add(sig.category);
            }
            String[] result = new String[categories.size()];
            categories.toArray(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefinitionCategory[] getListOfSubCategories() {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            Vector<DefinitionCategory> categories = new Vector<DefinitionCategory>();
            for (Definition sig : this.definitions) {
                boolean found = false;
                int c = 0;
                while (c < categories.size() && !found) {
                    if (((DefinitionCategory)categories.get(c)).getCategory().equalsIgnoreCase(sig.category) && ((DefinitionCategory)categories.get(c)).getSubCategory().equalsIgnoreCase(sig.subCategory)) {
                        found = true;
                    }
                    ++c;
                }
                if (found) continue;
                categories.add(new DefinitionCategory(sig.category, sig.subCategory));
            }
            Collections.sort(categories, new DefinitionCategoryComparator());
            DefinitionCategory[] result = new DefinitionCategory[categories.size()];
            categories.toArray(result);
            return result;
        }
    }

    public int size() {
        return this.definitions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getByID(int definitionID) {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            for (Definition definition : this.definitions) {
                if (definition.getID() != definitionID) continue;
                return definition;
            }
            return null;
        }
    }

    public Definition get(int c) {
        return this.definitions.get(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition remove(int c) {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            Definition def = this.definitions.remove(c);
            this.getCustomDefinitionsCount();
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Definition definition) {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            this.definitions.remove(definition);
            this.getCustomDefinitionsCount();
        }
    }

    public void removeByID(int definitionID) {
        Definition def = this.getByID(definitionID);
        if (def != null) {
            this.remove(def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            this.definitions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDefinition(Definition definition, int localId) {
        if (definition == null) {
            throw new IllegalArgumentException("The replacement definition must not be null");
        }
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            ListIterator<Definition> it = this.definitions.listIterator();
            while (it.hasNext()) {
                if (it.next().localId != localId) continue;
                definition.localId = localId;
                it.set(definition);
            }
        }
        this.getCustomDefinitionsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Definition definition) throws DuplicateEntryException {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            if (definition == null) {
                throw new IllegalArgumentException("The definition cannot be added since it is null");
            }
            if (this.getByID(definition.getID()) != null) {
                throw new DuplicateEntryException("A definition with ID " + definition.getID() + " already exists. Note that the next available ID is " + this.getNextOpenID(false) + ".");
            }
            this.definitions.add(definition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextOpenID(boolean returnNextOfficial) {
        DefinitionSet definitionSet = this;
        synchronized (definitionSet) {
            int highestAllocated;
            block7: {
                block8: {
                    highestAllocated = -1;
                    for (Definition definition : this.definitions) {
                        if (definition.getID() <= highestAllocated) continue;
                        if (definition.isOfficial() && returnNextOfficial) {
                            highestAllocated = definition.getID();
                            continue;
                        }
                        if (definition.isOfficial() || returnNextOfficial) continue;
                        highestAllocated = definition.getID();
                    }
                    if (highestAllocated > 0) break block7;
                    if (!returnNextOfficial) break block8;
                    return 1;
                }
                return 1000000;
            }
            return highestAllocated + 1;
        }
    }

    public Iterator<Definition> iterator() {
        return this.definitions.iterator();
    }

    public static class DefinitionCategory {
        private String category;
        private String subCategory;

        public DefinitionCategory(String category, String subCategory) {
            this.category = category;
            this.subCategory = subCategory;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSubCategory() {
            return this.subCategory;
        }
    }

    private static class DefinitionCategoryComparator
    implements Comparator<DefinitionCategory> {
        private DefinitionCategoryComparator() {
        }

        @Override
        public int compare(DefinitionCategory first, DefinitionCategory second) {
            if (first.getCategory().equalsIgnoreCase(second.getCategory())) {
                return first.getSubCategory().compareTo(second.getSubCategory());
            }
            return first.getCategory().compareTo(second.getCategory());
        }
    }

    private static class DefinitionComparator
    implements Comparator<Definition> {
        private DefinitionComparator() {
        }

        @Override
        public int compare(Definition sig1, Definition sig2) {
            int sig1Num = -1;
            int sig2Num = -1;
            String fullname1 = sig1.getFullName();
            String fullname2 = sig2.getFullName();
            int c = fullname1.length() - 1;
            while (c >= 0) {
                if (!Character.isDigit(fullname1.charAt(c))) break;
                sig1Num = c--;
            }
            c = fullname2.length() - 1;
            while (c >= 0) {
                if (!Character.isDigit(fullname2.charAt(c))) break;
                sig2Num = c--;
            }
            String nameOnly1 = sig1Num > -1 ? fullname1.substring(0, sig1Num) : fullname1;
            String nameOnly2 = sig2Num > -1 ? fullname2.substring(0, sig2Num) : fullname2;
            int nameResult = nameOnly1.compareTo(nameOnly2);
            if (nameResult != 0) {
                return nameResult;
            }
            if (sig1Num < 0) {
                return -1;
            }
            if (sig2Num < 0) {
                return 1;
            }
            try {
                int num1 = Integer.parseInt(fullname1.substring(sig1Num));
                int num2 = Integer.parseInt(fullname2.substring(sig2Num));
                return num1 - num2;
            }
            catch (Exception e) {
                return sig1.getFullName().compareTo(sig2.getFullName());
            }
        }
    }

    public static class DefinitionMatchResultSet {
        private Vector<DefinitionMatch> definitionMatches = new Vector();
        private Vector<URLToScan> extractedURLs = new Vector();

        public DefinitionMatchResultSet(Vector<DefinitionMatch> definitionMatches, Vector<URLToScan> extractedURLs) {
            if (definitionMatches != null) {
                this.definitionMatches.addAll(definitionMatches);
            }
            if (extractedURLs != null) {
                this.extractedURLs.addAll(extractedURLs);
            }
        }

        public Vector<DefinitionMatch> getDefinitionMatches() {
            return this.definitionMatches;
        }

        public Vector<URLToScan> getExtractedURLs() {
            return this.extractedURLs;
        }
    }

    public static enum DefinitionType {
        SCRIPT,
        PATTERN;

    }

    public static class DefinitionVersionID {
        private int formatID;
        private int revisionID;
        private String extendedInfo;
        private Date revisionDate;
        private static final String VERSION_FORMAT_REGEX = "([0-9]+)\\.([0-9]+)[ \\t]*(.*)";

        public DefinitionVersionID(String version) {
            this(version, null);
        }

        public DefinitionVersionID(String version, Date revisionDate) {
            if (version == null) {
                throw new IllegalArgumentException("The version identifier cannot be null");
            }
            Pattern pattern = Pattern.compile(VERSION_FORMAT_REGEX);
            Matcher matcher = pattern.matcher(version);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("The version identifier does not match the expected format");
            }
            if (matcher.groupCount() != 2 && matcher.groupCount() != 3) {
                throw new IllegalArgumentException("The version identifier does not match the expected format");
            }
            this.formatID = Integer.parseInt(matcher.group(1));
            this.revisionID = Integer.parseInt(matcher.group(2));
            if (matcher.groupCount() == 3) {
                this.extendedInfo = matcher.group(3);
                if (this.extendedInfo != null && this.extendedInfo.isEmpty()) {
                    this.extendedInfo = null;
                }
            }
            this.revisionDate = revisionDate;
        }

        public int formatID() {
            return this.formatID;
        }

        public int revisionID() {
            return this.revisionID;
        }

        public String extendedInfo() {
            return this.extendedInfo;
        }

        public Date getRevisionDate() {
            return this.revisionDate;
        }

        public boolean equals(DefinitionVersionID versionID) {
            return versionID != null && versionID.formatID == this.formatID && versionID.revisionID == this.revisionID && (versionID.extendedInfo == null && this.extendedInfo == null || versionID.extendedInfo != null && versionID.extendedInfo.equalsIgnoreCase(this.extendedInfo));
        }

        public boolean equals(Object obj) {
            if (obj instanceof DefinitionVersionID) {
                return this.equals((DefinitionVersionID)obj);
            }
            return false;
        }

        public String toString() {
            if (this.extendedInfo != null && this.extendedInfo.length() > 0) {
                return String.valueOf(this.formatID) + "." + this.revisionID + " " + this.extendedInfo;
            }
            return String.valueOf(this.formatID) + "." + this.revisionID;
        }
    }
}

