/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.MaxMinCount;
import net.lukemurphey.nsia.NameIntPair;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionMatch;
import net.lukemurphey.nsia.scan.MetaDefinition;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.scan.ScanResultLoader;
import net.lukemurphey.nsia.scan.ScanRule;

public class HttpDefinitionScanResult
extends ScanResult {
    private URL url;
    private Vector<DefinitionMatch> definitionMatches;
    private String contentType;

    public HttpDefinitionScanResult(ScanResultCode resultcode, Timestamp timeOfScan, URL url, long scanRuleId) {
        super(resultcode, timeOfScan);
        this.ruleId = scanRuleId;
        this.scanTime = timeOfScan;
        this.url = url;
        this.definitionMatches = new Vector();
        this.deviations = this.definitionMatches.size();
    }

    public HttpDefinitionScanResult(ScanResultCode resultcode, Timestamp timeOfScan, URL url, DefinitionMatch[] definitionMatches, long scanRuleId) {
        super(resultcode, timeOfScan);
        this.ruleId = scanRuleId;
        this.scanTime = timeOfScan;
        this.url = url;
        this.definitionMatches = new Vector();
        DefinitionMatch[] definitionMatchArray = definitionMatches;
        int n = definitionMatches.length;
        int n2 = 0;
        while (n2 < n) {
            DefinitionMatch match = definitionMatchArray[n2];
            if (match != null) {
                this.definitionMatches.add(match);
            }
            ++n2;
        }
        this.deviations = this.definitionMatches.size();
    }

    public HttpDefinitionScanResult(ScanResultCode resultcode, Timestamp timeOfScan, URL url, DefinitionMatch[] signatureMatches, long scanRuleId, String contentType) {
        super(resultcode, timeOfScan);
        this.ruleId = scanRuleId;
        this.scanTime = timeOfScan;
        this.url = url;
        this.definitionMatches = new Vector();
        DefinitionMatch[] definitionMatchArray = signatureMatches;
        int n = signatureMatches.length;
        int n2 = 0;
        while (n2 < n) {
            DefinitionMatch match = definitionMatchArray[n2];
            if (match != null) {
                this.definitionMatches.add(match);
            }
            ++n2;
        }
        this.deviations = this.definitionMatches.size();
        this.contentType = contentType;
    }

    public HttpDefinitionScanResult(ScanResultCode resultcode, Timestamp timeOfScan, URL url, DefinitionMatch signatureMatch, long scanRuleId) {
        super(resultcode, timeOfScan);
        this.ruleId = scanRuleId;
        this.scanTime = timeOfScan;
        this.url = url;
        this.definitionMatches = new Vector();
        if (signatureMatch != null) {
            this.definitionMatches.add(signatureMatch);
        }
        this.deviations = this.definitionMatches.size();
    }

    public HttpDefinitionScanResult(ScanResultCode resultcode, Timestamp timeOfScan, URL url, DefinitionMatch signatureMatch, long scanRuleId, String contentType) {
        super(resultcode, timeOfScan);
        this.ruleId = scanRuleId;
        this.scanTime = timeOfScan;
        this.url = url;
        this.definitionMatches = new Vector();
        if (signatureMatch != null) {
            this.definitionMatches.add(signatureMatch);
        }
        this.deviations = this.definitionMatches.size();
        this.contentType = contentType;
    }

    public HttpDefinitionScanResult(ScanResultCode resultcode, Timestamp timeOfScan, URL url, Vector<DefinitionMatch> signatureMatches, long scanRuleId) {
        super(resultcode, timeOfScan);
        this.ruleId = scanRuleId;
        this.scanTime = timeOfScan;
        this.url = url;
        this.definitionMatches = new Vector();
        this.definitionMatches.addAll(signatureMatches);
        this.deviations = this.definitionMatches.size();
        this.deviations = signatureMatches.size();
    }

    public HttpDefinitionScanResult(ScanResultCode resultcode, Timestamp timeOfScan, URL url, Vector<DefinitionMatch> signatureMatches, long scanRuleId, String contentType) {
        super(resultcode, timeOfScan);
        this.ruleId = scanRuleId;
        this.scanTime = timeOfScan;
        this.url = url;
        this.definitionMatches = new Vector();
        this.definitionMatches.addAll(signatureMatches);
        this.deviations = signatureMatches.size();
        this.contentType = contentType;
    }

    @Override
    public String getRuleType() {
        return "HTTP/SignatureScan";
    }

    @Override
    public String getSpecimenDescription() {
        return this.url.toString();
    }

    public URL getUrl() {
        return this.url;
    }

    public String getContentType() {
        return this.contentType;
    }

    public static Hashtable<Definition.Severity, Integer> getSignatureMatchSeverities(long parentScanResultID) throws SQLException, NoDatabaseConnectionException {
        return HttpDefinitionScanResult.getSignatureMatchSeverities(Application.getApplication(), parentScanResultID);
    }

    public static Vector<NameIntPair> getSignatureMatches(long parentScanResultID) throws SQLException, NoDatabaseConnectionException {
        return HttpDefinitionScanResult.getSignatureMatches(Application.getApplication(), parentScanResultID);
    }

    public static Vector<NameIntPair> getSignatureMatches(Application application, long parentScanResultID) throws SQLException, NoDatabaseConnectionException {
        if (application == null) {
            throw new NoDatabaseConnectionException();
        }
        Vector<NameIntPair> sigMatches = new Vector<NameIntPair>();
        Connection connection = null;
        Statement matchedSignatureStatement = null;
        ResultSet result = null;
        try {
            connection = application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            matchedSignatureStatement = connection.prepareStatement("select MatchedRule.RuleName, count(*) from SignatureScanResult inner join ScanResult on ScanResult.ScanResultID = SignatureScanResult.ScanResultID inner join MatchedRule on MatchedRule.ScanResultID = SignatureScanResult.ScanResultID where ParentScanResultID = ? group by MatchedRule.RuleName order by count(*) desc");
            matchedSignatureStatement.setLong(1, parentScanResultID);
            result = matchedSignatureStatement.executeQuery();
            while (result.next()) {
                String name = result.getString(1);
                int count = result.getInt(2);
                sigMatches.add(new NameIntPair(name, count));
            }
        }
        finally {
            if (matchedSignatureStatement != null) {
                matchedSignatureStatement.close();
            }
            if (result != null) {
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return sigMatches;
    }

    public static Hashtable<Definition.Severity, Integer> getSignatureMatchSeverities(Application application, long parentScanResultID) throws SQLException, NoDatabaseConnectionException {
        if (application == null) {
            throw new NoDatabaseConnectionException();
        }
        int low = 0;
        int medium = 0;
        int high = 0;
        Connection connection = null;
        Statement matchedSignatureStatement = null;
        ResultSet result = null;
        try {
            connection = application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            matchedSignatureStatement = connection.prepareStatement("select Severity, count(*) as Instances from ScanResult inner join MatchedRule on MatchedRule.ScanResultID = ScanResult.ScanResultID where ParentScanResultID = ? group by Severity");
            matchedSignatureStatement.setLong(1, parentScanResultID);
            result = matchedSignatureStatement.executeQuery();
            while (result.next()) {
                int sev = result.getInt("Severity");
                if (sev == Definition.Severity.LOW.ordinal()) {
                    low = result.getInt("Instances");
                    continue;
                }
                if (sev == Definition.Severity.MEDIUM.ordinal()) {
                    medium = result.getInt("Instances");
                    continue;
                }
                if (sev != Definition.Severity.HIGH.ordinal()) continue;
                high = result.getInt("Instances");
            }
        }
        finally {
            if (matchedSignatureStatement != null) {
                matchedSignatureStatement.close();
            }
            if (result != null) {
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        Hashtable<Definition.Severity, Integer> results = new Hashtable<Definition.Severity, Integer>();
        results.put(Definition.Severity.LOW, low);
        results.put(Definition.Severity.MEDIUM, medium);
        results.put(Definition.Severity.HIGH, high);
        return results;
    }

    public DefinitionMatch[] getDefinitionMatches() {
        DefinitionMatch[] matches = new DefinitionMatch[this.definitionMatches.size()];
        this.definitionMatches.toArray(matches);
        return matches;
    }

    public int archive() {
        return -1;
    }

    public HttpDefinitionScanResult[] getFindings(String signatureName, String contentType, int startResultID, int count, boolean getBefore) {
        return null;
    }

    public static HttpDefinitionScanResult[] loadScanResults(long parentScanResultID, boolean resultsAfter, SignatureScanResultFilter filter, int count, Application application) throws ScanRule.ScanResultLoadFailureException, SQLException, NoDatabaseConnectionException {
        return HttpDefinitionScanResult.loadScanResults(parentScanResultID, -1L, resultsAfter, filter, count, application);
    }

    public static MaxMinCount getScanResultInfo(long parentScanResultID, SignatureScanResultFilter filter, Application application) throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        int max = -1;
        int min = -1;
        int count = 0;
        try {
            connection = application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            if (filter.getContentType() != null && filter.getContentType().length() > 0 && filter.getSignatureName() != null) {
                statement = connection.prepareStatement("select max(ScanResult.ScanResultID), min(ScanResult.ScanResultID), count(ScanResult.ScanResultID) from SignatureScanResult inner join ScanResult on SignatureScanResult.ScanResultID = ScanResult.ScanResultID inner join MatchedRule on MatchedRule.ScanResultID = ScanResult.ScanResultID where ContentType = ? and RuleName = ? and ParentScanResultID = ? group by ScanResult.ParentScanResultID");
                statement.setString(1, filter.getContentType());
                statement.setString(2, filter.getSignatureName());
                statement.setLong(3, parentScanResultID);
            } else if ((filter.getContentType() == null || filter.getContentType().length() == 0) && filter.getSignatureName() != null) {
                statement = filter.getContentType() != null ? connection.prepareStatement("select max(ScanResult.ScanResultID), min(ScanResult.ScanResultID), count(ScanResult.ScanResultID) from SignatureScanResult inner join ScanResult on SignatureScanResult.ScanResultID = ScanResult.ScanResultID inner join MatchedRule on MatchedRule.ScanResultID = ScanResult.ScanResultID where ContentType is null and RuleName = ? and ParentScanResultID = ? group by ScanResult.ParentScanResultID") : connection.prepareStatement("select max(ScanResult.ScanResultID), min(ScanResult.ScanResultID), count(ScanResult.ScanResultID) from SignatureScanResult inner join ScanResult on SignatureScanResult.ScanResultID = ScanResult.ScanResultID inner join MatchedRule on MatchedRule.ScanResultID = ScanResult.ScanResultID where RuleName = ? and ParentScanResultID = ? group by ScanResult.ParentScanResultID");
                statement.setString(1, filter.getSignatureName());
                statement.setLong(2, parentScanResultID);
            } else if (filter.getContentType() != null && filter.getContentType().length() > 0 && filter.getSignatureName() == null) {
                statement = connection.prepareStatement("select max(ScanResult.ScanResultID), min(ScanResult.ScanResultID), count(ScanResult.ScanResultID) from SignatureScanResult inner join ScanResult on SignatureScanResult.ScanResultID = ScanResult.ScanResultID where ContentType = ? and ParentScanResultID = ? group by ScanResult.ParentScanResultID");
                statement.setString(1, filter.getContentType());
                statement.setLong(2, parentScanResultID);
            } else {
                statement = filter.getContentType() != null && filter.getContentType().length() == 0 ? connection.prepareStatement("select max(ScanResult.ScanResultID), min(ScanResult.ScanResultID), count(ScanResult.ScanResultID) from SignatureScanResult inner join ScanResult on SignatureScanResult.ScanResultID = ScanResult.ScanResultID where ParentScanResultID = ? and ContentType is null group by ScanResult.ParentScanResultID") : connection.prepareStatement("select max(ScanResult.ScanResultID), min(ScanResult.ScanResultID), count(ScanResult.ScanResultID) from SignatureScanResult inner join ScanResult on SignatureScanResult.ScanResultID = ScanResult.ScanResultID where ParentScanResultID = ? group by ScanResult.ParentScanResultID");
                statement.setLong(1, parentScanResultID);
            }
            result = statement.executeQuery();
            while (result.next()) {
                max = result.getInt(1);
                min = result.getInt(2);
                count = result.getInt(3);
            }
            MaxMinCount maxMinCount = new MaxMinCount(max, min, count);
            return maxMinCount;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
    }

    public static HttpDefinitionScanResult[] loadScanResults(long parentScanResultID, long start, boolean getResultsBefore, SignatureScanResultFilter filter, int count, Application application) throws ScanRule.ScanResultLoadFailureException, SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        Vector<HttpDefinitionScanResult> results = new Vector<HttpDefinitionScanResult>();
        long currentRule = -1L;
        try {
            try {
                connection = application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                String queryAdd = start > -1L && getResultsBefore ? " and ScanResult.ScanResultID < ?" : (start > -1L ? " and ScanResult.ScanResultID > ?" : "");
                String sort = getResultsBefore ? " order by ScanResult.ScanResultID desc" : " order by ScanResult.ScanResultID asc";
                if (filter.getContentType() != null && filter.getContentType().length() > 0 && filter.getSignatureName() != null) {
                    statement = connection.prepareStatement("select ScanResult.ScanResultID from SignatureScanResult inner join ScanResult on SignatureScanResult.ScanResultID = ScanResult.ScanResultID inner join MatchedRule on MatchedRule.ScanResultID = ScanResult.ScanResultID where ContentType = ? and RuleName = ? and ParentScanResultID = ? " + queryAdd + " group by ScanResult.ScanResultID " + sort);
                    statement.setString(1, filter.getContentType());
                    statement.setString(2, filter.getSignatureName());
                    statement.setLong(3, parentScanResultID);
                    if (start > -1L) {
                        statement.setLong(4, start);
                    }
                } else if ((filter.getContentType() == null || filter.getContentType().length() == 0) && filter.getSignatureName() != null) {
                    statement = filter.getContentType() != null ? connection.prepareStatement("select ScanResult.ScanResultID from SignatureScanResult inner join ScanResult on SignatureScanResult.ScanResultID = ScanResult.ScanResultID inner join MatchedRule on MatchedRule.ScanResultID = ScanResult.ScanResultID where ContentType is null and RuleName = ? and ParentScanResultID = ? " + queryAdd + " group by ScanResult.ScanResultID" + sort) : connection.prepareStatement("select ScanResult.ScanResultID from SignatureScanResult inner join ScanResult on SignatureScanResult.ScanResultID = ScanResult.ScanResultID inner join MatchedRule on MatchedRule.ScanResultID = ScanResult.ScanResultID where RuleName = ? and ParentScanResultID = ? " + queryAdd + " group by ScanResult.ScanResultID" + sort);
                    statement.setString(1, filter.getSignatureName());
                    statement.setLong(2, parentScanResultID);
                    if (start > -1L) {
                        statement.setLong(3, start);
                    }
                } else if (filter.getContentType() != null && filter.getContentType().length() > 0 && filter.getSignatureName() == null) {
                    statement = connection.prepareStatement("select ScanResult.ScanResultID from SignatureScanResult inner join ScanResult on SignatureScanResult.ScanResultID = ScanResult.ScanResultID where ContentType = ? and ParentScanResultID = ? " + queryAdd + " group by ScanResult.ScanResultID" + sort);
                    statement.setString(1, filter.getContentType());
                    statement.setLong(2, parentScanResultID);
                    if (start > -1L) {
                        statement.setLong(3, start);
                    }
                } else {
                    statement = filter.getContentType() != null && filter.getContentType().length() == 0 ? connection.prepareStatement("select ScanResult.ScanResultID from SignatureScanResult inner join ScanResult on SignatureScanResult.ScanResultID = ScanResult.ScanResultID where ParentScanResultID = ? and ContentType is null " + queryAdd + " group by ScanResult.ScanResultID" + sort) : connection.prepareStatement("select ScanResult.ScanResultID from SignatureScanResult inner join ScanResult on SignatureScanResult.ScanResultID = ScanResult.ScanResultID where ParentScanResultID = ? " + queryAdd + " group by ScanResult.ScanResultID" + sort);
                    statement.setLong(1, parentScanResultID);
                    if (start > -1L) {
                        statement.setLong(2, start);
                    }
                }
                statement.setMaxRows(count);
                result = statement.executeQuery();
                while (result.next()) {
                    currentRule = result.getInt(1);
                    results.add((HttpDefinitionScanResult)ScanResultLoader.getScanResult(currentRule));
                }
            }
            catch (SQLException e) {
                throw new ScanRule.ScanResultLoadFailureException("Rule " + currentRule + " could not be loaded", e);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
        HttpDefinitionScanResult[] resultsArray = new HttpDefinitionScanResult[results.size()];
        if (getResultsBefore) {
            int c = 0;
            while (c < resultsArray.length) {
                resultsArray[resultsArray.length - 1 - c] = (HttpDefinitionScanResult)results.get(c);
                ++c;
            }
        } else {
            results.toArray(resultsArray);
        }
        return resultsArray;
    }

    protected void addBrokenLink(String url) {
        ++this.deviations;
        this.definitionMatches.add(new DefinitionMatch(MetaDefinition.BROKEN_LINK.createNewWithMessage(" to: " + url)));
    }

    protected static Vector<DefinitionMatch> loadSignatureMatches(long scanResultID, Application application) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        PreparedStatement matchedSignatureStatement = null;
        ResultSet result = null;
        Vector<DefinitionMatch> signatureMatches = new Vector<DefinitionMatch>();
        try {
            connection = application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            matchedSignatureStatement = connection.prepareStatement("Select * from MatchedRule where ScanResultID = ?");
            matchedSignatureStatement.setLong(1, scanResultID);
            result = matchedSignatureStatement.executeQuery();
            while (result.next()) {
                String signatureName = result.getString("RuleName");
                String message = result.getString("RuleMessage");
                int signatureId = result.getInt("RuleID");
                int detectStart = result.getInt("MatchStart");
                int detectLength = result.getInt("MatchLength");
                Definition.Severity severity = Definition.Severity.UNDEFINED;
                int severityId = result.getInt("Severity");
                int c = 0;
                while (c < Definition.Severity.values().length) {
                    if (Definition.Severity.values()[c].ordinal() == severityId) {
                        severity = Definition.Severity.values()[c];
                    }
                    ++c;
                }
                DefinitionMatch sigMatch = new DefinitionMatch(signatureName, message, severity, signatureId, detectStart, detectLength);
                signatureMatches.add(sigMatch);
            }
            Vector<DefinitionMatch> vector = signatureMatches;
            return vector;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (matchedSignatureStatement != null) {
                matchedSignatureStatement.close();
            }
            if (result != null) {
                result.close();
            }
        }
    }

    public Definition.Severity getMaxSeverity() {
        Definition.Severity severity = Definition.Severity.LOW;
        DefinitionMatch[] matches = this.getDefinitionMatches();
        int c = 0;
        while (c < matches.length) {
            if (matches[c].getSeverity() == Definition.Severity.HIGH) {
                return Definition.Severity.HIGH;
            }
            if (matches[c].getSeverity() == Definition.Severity.MEDIUM) {
                severity = Definition.Severity.MEDIUM;
            }
            ++c;
        }
        return severity;
    }

    protected void loadFromScanResult(ResultSet findingResult, Application application) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException, MalformedURLException {
        String url = findingResult.getString("URL");
        this.url = new URL(url);
        this.contentType = findingResult.getString("ContentType");
        this.ruleId = findingResult.getLong("ScanRuleID");
        if (this.scanResultId <= -1L) {
            this.scanResultId = findingResult.getLong("ScanResultID");
        }
        this.definitionMatches = HttpDefinitionScanResult.loadSignatureMatches(this.scanResultId, application);
    }

    protected static HttpDefinitionScanResult loadFromDatabase(long scanRuleId, long scanResultId, ScanResultCode resultCode, Timestamp scanTime, int deviations) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        Application application = Application.getApplication();
        Connection connection = null;
        PreparedStatement matchedSignatureStatement = null;
        ResultSet result = null;
        Statement findingStatement = null;
        ResultSet findingResult = null;
        Vector<DefinitionMatch> signatureMatches = new Vector<DefinitionMatch>();
        try {
            connection = application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            matchedSignatureStatement = connection.prepareStatement("Select * from MatchedRule where ScanResultID = ?");
            matchedSignatureStatement.setLong(1, scanResultId);
            result = matchedSignatureStatement.executeQuery();
            while (result.next()) {
                String signatureName = result.getString("RuleName");
                String message = result.getString("RuleMessage");
                int signatureId = result.getInt("RuleID");
                int detectStart = result.getInt("MatchStart");
                int detectLength = result.getInt("MatchLength");
                Definition.Severity severity = Definition.Severity.UNDEFINED;
                int severityId = result.getInt("Severity");
                int c = 0;
                while (c < Definition.Severity.values().length) {
                    if (Definition.Severity.values()[c].ordinal() == severityId) {
                        severity = Definition.Severity.values()[c];
                    }
                    ++c;
                }
                DefinitionMatch sigMatch = new DefinitionMatch(signatureName, message, severity, signatureId, detectStart, detectLength);
                signatureMatches.add(sigMatch);
            }
            findingStatement = connection.prepareStatement("Select * from SignatureScanResult where ScanResultID = ?");
            findingStatement.setLong(1, scanResultId);
            findingResult = findingStatement.executeQuery();
            if (findingResult.next()) {
                String url = findingResult.getString("URL");
                String contentType = findingResult.getString("ContentType");
                HttpDefinitionScanResult scanResult = new HttpDefinitionScanResult(resultCode, scanTime, new URL(url), signatureMatches, scanRuleId);
                scanResult.contentType = contentType;
                scanResult.deviations = deviations;
                scanResult.ruleId = scanRuleId;
                scanResult.scanResultId = scanResultId;
                HttpDefinitionScanResult httpDefinitionScanResult = scanResult;
                return httpDefinitionScanResult;
            }
            try {
                throw new ScanRule.ScanResultLoadFailureException("The finding for the given scan result was not found in the database");
            }
            catch (MalformedURLException e) {
                throw new ScanRule.ScanResultLoadFailureException("The URL associated with the scan result is invalid", e);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (matchedSignatureStatement != null) {
                matchedSignatureStatement.close();
            }
            if (result != null) {
                result.close();
            }
            if (findingStatement != null) {
                findingStatement.close();
            }
        }
    }

    public long saveLinkedResultToDatabase(Connection connection, long scanResultId) throws SQLException {
        if (connection == null) {
            return -1L;
        }
        if (scanResultId == -1L) {
            return -1L;
        }
        PreparedStatement statement = null;
        Statement matchedRulesStatement = null;
        try {
            long httpResultId;
            statement = connection.prepareStatement("Insert into SignatureScanResult (ScanResultID, URL) values (?, ?)");
            statement.setLong(1, scanResultId);
            statement.setString(2, this.url.toString());
            matchedRulesStatement = connection.prepareStatement("Insert into MatchedRule (ScanResultID, RuleName, RuleMessage, RuleID, MatchStart, MatchLength, Severity) values (?, ?, ?, ?, ?, ?, ?)");
            if (this.definitionMatches != null) {
                for (DefinitionMatch match : this.definitionMatches) {
                    matchedRulesStatement.setLong(1, scanResultId);
                    matchedRulesStatement.setString(2, match.getDefinitionName());
                    matchedRulesStatement.setString(3, match.getMessage());
                    matchedRulesStatement.setInt(4, match.getDefinitionID());
                    matchedRulesStatement.setInt(5, match.getDetectStart());
                    matchedRulesStatement.setInt(6, match.getDetectLength());
                    matchedRulesStatement.setInt(7, match.getSeverity().ordinal());
                    matchedRulesStatement.executeUpdate();
                }
            }
            if ((httpResultId = (long)statement.executeUpdate()) < 0L) {
                return -1L;
            }
            long l = httpResultId;
            return l;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (matchedRulesStatement != null) {
                matchedRulesStatement.close();
            }
        }
    }

    @Override
    public long saveToDatabase(Connection connection, long scanRuleId) throws SQLException {
        if (connection == null) {
            return -1L;
        }
        long scanResultId = this.saveToDatabaseInitial(connection, scanRuleId, "HTTP/SignatureScan");
        if (scanResultId == -1L) {
            return -1L;
        }
        PreparedStatement statement = null;
        Statement matchedRulesStatement = null;
        try {
            statement = connection.prepareStatement("Insert into SignatureScanResult (ScanResultID, URL, ContentType) values (?, ?, ?)");
            statement.setLong(1, scanResultId);
            statement.setString(2, this.url.toString());
            statement.setString(3, this.contentType);
            long httpResultId = statement.executeUpdate();
            if (httpResultId < 0L) {
                return -1L;
            }
            matchedRulesStatement = connection.prepareStatement("Insert into MatchedRule (ScanResultID, RuleName, RuleMessage, RuleID, MatchStart, MatchLength, Severity) values (?, ?, ?, ?, ?, ?, ?)");
            if (this.definitionMatches != null) {
                for (DefinitionMatch match : this.definitionMatches) {
                    matchedRulesStatement.setLong(1, scanResultId);
                    matchedRulesStatement.setString(2, match.getDefinitionName());
                    matchedRulesStatement.setString(3, match.getMessage());
                    matchedRulesStatement.setInt(4, match.getDefinitionID());
                    matchedRulesStatement.setInt(5, match.getDetectStart());
                    matchedRulesStatement.setInt(6, match.getDetectLength());
                    matchedRulesStatement.setInt(7, match.getSeverity().ordinal());
                    matchedRulesStatement.executeUpdate();
                }
            }
            this.saveToDatabaseFinalize(connection, scanResultId, this.getDeviations(), scanRuleId);
            long l = httpResultId;
            return l;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (matchedRulesStatement != null) {
                matchedRulesStatement.close();
            }
        }
    }

    public static class SignatureScanResultFilter {
        private String contentType = null;
        private String signatureName = null;

        public SignatureScanResultFilter(String contentType, String signatureName) {
            this.contentType = contentType;
            this.signatureName = signatureName;
        }

        public SignatureScanResultFilter() {
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getSignatureName() {
            return this.signatureName;
        }
    }
}

