/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.scan.HttpHeaderScanResult;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;

public class HttpStaticScanResult
extends ScanResult {
    protected int expectedResponseCode = -1;
    protected String expectedDataHash = null;
    protected String expectedDataHashAlgorithm = null;
    protected URL specimenUrl = null;
    protected HttpHeaderScanResult[] headerResults = new HttpHeaderScanResult[0];
    protected int actualResponseCode = -1;
    protected String actualDataHash = null;
    protected String actualDataHashAlgorithm = null;

    protected HttpStaticScanResult(ScanResultCode scanResultCode, Timestamp timeOfScan) {
        super(scanResultCode, timeOfScan);
    }

    @Override
    public int getDeviations() {
        if (this.deviations < 0) {
            this.deviations = 0;
            if (this.expectedDataHashAlgorithm != null && this.actualDataHashAlgorithm != null && this.actualDataHashAlgorithm.matches(this.expectedDataHashAlgorithm) && (this.expectedDataHash == null || this.actualDataHash == null || !this.expectedDataHash.matches(this.actualDataHash))) {
                ++this.deviations;
            }
            int c = 0;
            while (c < this.headerResults.length) {
                if (this.headerResults[c].getRuleState() != 4 && this.headerResults[c].getRuleState() != 1) {
                    ++this.deviations;
                }
                ++c;
            }
            if (this.actualResponseCode != this.expectedResponseCode) {
                ++this.deviations;
            }
            return this.deviations;
        }
        return this.deviations;
    }

    public int getExpectedResponseCode() {
        return this.expectedResponseCode;
    }

    public int getActualResponseCode() {
        return this.actualResponseCode;
    }

    public String getExpectedHashValue() {
        return this.expectedDataHash;
    }

    public String getExpectedHashAlgorithm() {
        return this.expectedDataHashAlgorithm;
    }

    public String getActualHashValue() {
        return this.actualDataHash;
    }

    public String getActualHashAlgorithm() {
        return this.actualDataHashAlgorithm;
    }

    public URL getUrl() {
        return this.specimenUrl;
    }

    public HttpHeaderScanResult[] getHeaderRuleResults() {
        HttpHeaderScanResult[] headerResultsCopy = new HttpHeaderScanResult[this.headerResults.length];
        System.arraycopy(this.headerResults, 0, headerResultsCopy, 0, this.headerResults.length);
        return headerResultsCopy;
    }

    protected void setActualHash(String hashAlgorithm, String hashData) {
        this.actualDataHashAlgorithm = hashAlgorithm;
        this.actualDataHash = hashData;
    }

    protected void setActualResponseCode(int responseCode) {
        this.actualResponseCode = responseCode;
    }

    @Override
    public long saveToDatabase(Connection connection, long scanRuleId) throws SQLException {
        if (connection == null) {
            return -1L;
        }
        long scanResultId = this.saveToDatabaseInitial(connection, scanRuleId, "HTTP/Static");
        if (scanResultId == -1L) {
            return -1L;
        }
        PreparedStatement statement = null;
        Statement headerStatement = null;
        try {
            statement = connection.prepareStatement("Insert into HttpHashScanResult (ScanResultID, ActualHashAlgorithm, ActualHashData, ActualResponseCode, ExpectedHashAlgorithm, ExpectedHashData, ExpectedResponseCode, LocationUrl) values (?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setLong(1, scanResultId);
            statement.setString(2, this.actualDataHashAlgorithm);
            statement.setString(3, this.actualDataHash);
            statement.setInt(4, this.actualResponseCode);
            statement.setString(5, this.expectedDataHashAlgorithm);
            statement.setString(6, this.expectedDataHash);
            statement.setInt(7, this.expectedResponseCode);
            statement.setString(8, this.specimenUrl.toString());
            long httpResultId = statement.executeUpdate();
            if (httpResultId < 0L) {
                return -1L;
            }
            headerStatement = connection.prepareStatement("Insert into HttpHeaderScanResult (ScanResultID, MatchAction, ExpectedHeaderName, HeaderNameType, ActualHeaderName, ExpectedHeaderValue, HeaderValueType, ActualHeaderValue, RuleResult) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            if (this.headerResults != null) {
                int c = 0;
                while (c < this.headerResults.length) {
                    headerStatement.setLong(1, scanResultId);
                    headerStatement.setInt(2, this.headerResults[c].ruleAction);
                    headerStatement.setString(3, this.headerResults[c].nameRule);
                    headerStatement.setInt(4, this.headerResults[c].nameRuleType);
                    headerStatement.setString(5, this.headerResults[c].nameActual);
                    headerStatement.setString(6, this.headerResults[c].valueRule);
                    headerStatement.setInt(7, this.headerResults[c].valueRuleType);
                    headerStatement.setString(8, this.headerResults[c].valueActual);
                    headerStatement.setInt(9, this.headerResults[c].ruleResult);
                    headerStatement.executeUpdate();
                    ++c;
                }
            }
            this.saveToDatabaseFinalize(connection, scanResultId, this.getDeviations(), scanRuleId);
            long l = httpResultId;
            return l;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (headerStatement != null) {
                headerStatement.close();
            }
        }
    }

    @Override
    public Hashtable<String, Object> toHashtable() {
        Hashtable<String, Object> hashtable = super.toHashtable();
        Vector<Hashtable<String, Object>> headerScanResultsVector = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < this.headerResults.length) {
            HttpHeaderScanResult headerScanResult = this.headerResults[c];
            headerScanResultsVector.add(headerScanResult.toHashtable());
            ++c;
        }
        hashtable.put("Class", this.getClass().getName());
        hashtable.put("ActualHash", this.actualDataHash);
        hashtable.put("ActualHashAlgorithm", this.actualDataHashAlgorithm);
        hashtable.put("ActualResponseCode", this.actualResponseCode);
        hashtable.put("ExpectedDataHash", this.expectedDataHash);
        hashtable.put("ExpectedHashAlgorithm", this.expectedDataHashAlgorithm);
        hashtable.put("ExpectedResponseCode", this.expectedResponseCode);
        hashtable.put("URL", this.specimenUrl);
        hashtable.put("HeaderScanResults", headerScanResultsVector);
        return hashtable;
    }

    protected static HttpStaticScanResult loadFromDatabase(long scanRuleId, long scanResultId, ScanResultCode resultCode, Timestamp scanTime, int deviations, int incompletes, int accepts) throws SQLException, NoDatabaseConnectionException {
        Application application = Application.getApplication();
        Connection connection = null;
        HttpStaticScanResult scanResult = new HttpStaticScanResult(resultCode, scanTime);
        scanResult.deviations = deviations;
        scanResult.incompletes = incompletes;
        scanResult.accepts = accepts;
        Statement httpStatement = null;
        ResultSet httpresult = null;
        Statement httpHeadersStatement = null;
        ResultSet httpHeaderResult = null;
        try {
            connection = application.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            httpStatement = connection.prepareStatement("Select * from HttpHashScanResult where ScanResultID = ?");
            httpStatement.setLong(1, scanResultId);
            httpresult = httpStatement.executeQuery();
            if (httpresult.next()) {
                scanResult.actualDataHash = httpresult.getString("ActualHashData");
                scanResult.actualDataHashAlgorithm = httpresult.getString("ActualHashAlgorithm");
                scanResult.actualResponseCode = httpresult.getInt("ActualResponseCode");
                scanResult.expectedDataHash = httpresult.getString("ExpectedHashData");
                scanResult.actualDataHashAlgorithm = httpresult.getString("ExpectedHashAlgorithm");
                scanResult.expectedResponseCode = httpresult.getInt("ExpectedResponseCode");
                scanResult.ruleId = scanRuleId;
                scanResult.scanResultId = scanResultId;
                try {
                    scanResult.specimenUrl = new URL(httpresult.getString("LocationUrl"));
                }
                catch (MalformedURLException e) {
                    scanResult.specimenUrl = null;
                }
            } else {
                return null;
            }
            httpHeadersStatement = connection.prepareStatement("Select * from HttpHeaderScanResult where ScanResultID = ?");
            httpHeadersStatement.setLong(1, scanResultId);
            httpHeaderResult = httpHeadersStatement.executeQuery();
            Vector<HttpHeaderScanResult> headerResults = new Vector<HttpHeaderScanResult>();
            if (httpHeaderResult.next()) {
                HttpHeaderScanResult headerScanResult = new HttpHeaderScanResult();
                headerScanResult.nameActual = httpHeaderResult.getString("ActualHeaderName");
                headerScanResult.nameRule = httpHeaderResult.getString("ExpectedHeaderName");
                headerScanResult.nameRuleType = httpHeaderResult.getInt("HeaderNameType");
                headerScanResult.ruleAction = httpHeaderResult.getInt("MatchAction");
                headerScanResult.ruleId = httpHeaderResult.getLong("HttpHeaderScanRuleID");
                headerScanResult.ruleResult = httpHeaderResult.getInt("RuleResult");
                headerScanResult.valueActual = httpHeaderResult.getString("ActualHeaderValue");
                headerScanResult.valueRule = httpHeaderResult.getString("ExpectedHeaderValue");
                headerScanResult.valueRuleType = httpHeaderResult.getInt("HeaderValueType");
                headerResults.add(headerScanResult);
            }
            HttpHeaderScanResult[] headerResultsArray = new HttpHeaderScanResult[headerResults.size()];
            int c = 0;
            while (c < headerResults.size()) {
                headerResultsArray[c] = (HttpHeaderScanResult)headerResults.get(c);
                ++c;
            }
            scanResult.headerResults = headerResultsArray;
            HttpStaticScanResult httpStaticScanResult = scanResult;
            return httpStaticScanResult;
        }
        finally {
            if (httpStatement != null) {
                httpStatement.close();
            }
            if (httpresult != null) {
                httpresult.close();
            }
            if (httpHeadersStatement != null) {
                httpHeadersStatement.close();
            }
            if (httpHeaderResult != null) {
                httpHeaderResult.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public String getRuleType() {
        return "HTTP/Static";
    }

    @Override
    public String getSpecimenDescription() {
        return this.specimenUrl.toString();
    }
}

