/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.scan.HttpHeaderRule;
import net.lukemurphey.nsia.scan.HttpHeaderScanResult;
import net.lukemurphey.nsia.scan.HttpStaticScanResult;
import net.lukemurphey.nsia.scan.ScanException;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.scan.ScanRule;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class HttpStaticScanRule
extends ScanRule {
    private int expectedResponseCode = -1;
    private String expectedDataHash = null;
    private String expectedDataHashAlgorithm = null;
    private boolean followRedirects = false;
    private URL specimenUrl = null;
    private Vector<HttpHeaderRule> headerRules = null;
    private Vector<Long> headerRulesAwaitingDeletion;
    public static final String RULE_TYPE = "HTTP/Static";
    private boolean defaultDenyHeaders = false;
    public static final int MUST_MATCH = 0;
    public static final int MUST_NOT_MATCH = 1;
    public static final int DEFAULT_MATCH = 2;
    private static final int DOES_NOT_MATCH = 0;
    private static final int MATCH_REJECT = 1;
    private static final int MATCH_ACCEPT = 2;
    private static final long HEADER_RULE_ID_NOT_SET = -1L;

    public HttpStaticScanRule(Application appRes) {
        super(appRes);
        this.headerRules = new Vector();
        this.headerRulesAwaitingDeletion = new Vector();
    }

    public HttpStaticScanRule(Application appRes, int expectedResponseCode, String expectedDataHash, String expectedDataHashAlgorithm, boolean followRedirects, URL specimenUrl, int scanFrequency) throws NoSuchAlgorithmException, InputValidationException {
        super(appRes);
        if (expectedResponseCode < 0) {
            throw new InputValidationException("The response code must be a positive value", "ExpectedResponseCode", Integer.toString(expectedResponseCode));
        }
        if (expectedDataHash == null) {
            throw new InputValidationException("Data hash cannot be null", "ExpectedDataHash", "null");
        }
        if (expectedDataHashAlgorithm == null) {
            throw new InputValidationException("Data hash algorihtm cannot be null", "ExpectedDataAlgorithm", "null");
        }
        if (specimenUrl == null) {
            throw new InputValidationException("URL cannot be null", "URL", "null");
        }
        if (specimenUrl.getHost() == null || specimenUrl.getHost().length() == 0) {
            throw new InputValidationException("URL must contain a host name", "URLHostname", specimenUrl.toString());
        }
        this.headerRulesAwaitingDeletion = new Vector();
        this.headerRules = new Vector();
        this.setExpectedResponseCode(expectedResponseCode);
        this.setExpectedDataHash(expectedDataHashAlgorithm, expectedDataHash);
        this.setFollowRedirects(followRedirects);
        this.setUrl(specimenUrl);
        this.setScanFrequency(scanFrequency);
    }

    public String toString() {
        return "Scanner : HTTP/static (" + this.specimenUrl.toString() + ")";
    }

    @Override
    public String getRuleType() {
        return RULE_TYPE;
    }

    @Override
    public String getSpecimenDescription() {
        return this.specimenUrl.toString();
    }

    public static long resolveRuleId(long headerRuleId) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        Application appRes = Application.getApplication();
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            connection = appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            if (connection == null) {
                return -1L;
            }
            statement = connection.prepareStatement("Select * from HttpHeaderScanRule where HttpHeaderScanRuleID = ?");
            statement.setLong(1, headerRuleId);
            result = statement.executeQuery();
            if (!result.next()) {
                throw new NotFoundException("A rule could not be found with the given identifier (" + headerRuleId + ")");
            }
            long l = result.getLong("ScanRuleID");
            return l;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadFromDatabase(long scanRuleId) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanRuleLoadFailureException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        Statement generalRuleStatement = null;
        ResultSet generalRuleResult = null;
        Statement headerStatement = null;
        ResultSet headerResults = null;
        try {
            int scanFrequency;
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            if (connection == null) {
                return false;
            }
            statement = connection.prepareStatement("Select * from HttpHashScanRule where ScanRuleID = ?");
            statement.setLong(1, scanRuleId);
            result = statement.executeQuery();
            if (!result.next()) {
                return false;
            }
            this.defaultDenyHeaders = result.getBoolean("DefaultDenyHeaders");
            this.expectedDataHash = result.getString("HashData");
            this.expectedDataHashAlgorithm = result.getString("HashAlgorithm");
            this.expectedResponseCode = result.getInt("ResponseCode");
            try {
                this.specimenUrl = new URL(result.getString("LocationUrl"));
            }
            catch (MalformedURLException e) {
                throw new ScanRule.ScanRuleLoadFailureException("The URL associated with the rule is invalid", e);
            }
            this.scanRuleId = scanRuleId;
            generalRuleStatement = connection.prepareStatement("Select * from ScanRule where ScanRuleID = ?");
            generalRuleStatement.setLong(1, scanRuleId);
            generalRuleResult = generalRuleStatement.executeQuery();
            if (!generalRuleResult.next()) {
                return false;
            }
            this.scanFrequency = scanFrequency = generalRuleResult.getInt("ScanFrequency");
            this.created = generalRuleResult.getTimestamp("Created");
            this.modified = generalRuleResult.getTimestamp("Modified");
            headerStatement = connection.prepareStatement("Select * from HttpHeaderScanRule where ScanRuleID = ?");
            headerStatement.setLong(1, scanRuleId);
            headerResults = headerStatement.executeQuery();
            while (headerResults.next()) {
                HttpHeaderRule headerRule = HttpHeaderRule.getFromResultSet(headerResults);
                this.addHeaderRule(headerRule);
            }
            return true;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
            if (generalRuleStatement != null) {
                generalRuleStatement.close();
            }
            if (generalRuleResult != null) {
                generalRuleResult.close();
            }
            if (headerStatement != null) {
                headerStatement.close();
            }
            if (headerResults != null) {
                headerResults.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public ScanResult doScan() throws ScanException {
        MessageDigest messageDigest;
        Timestamp timeOfScan = new Timestamp(System.currentTimeMillis());
        if (!this.isReady()) {
            return new HttpStaticScanResult(ScanResultCode.UNREADY, timeOfScan);
        }
        HostConfiguration hostConfig = new HostConfiguration();
        int port = 80;
        String protocol = "HTTP";
        if (this.specimenUrl.getPort() >= 0) {
            port = this.specimenUrl.getPort();
        }
        if (this.specimenUrl.getProtocol() != null && this.specimenUrl.getProtocol() != "") {
            protocol = this.specimenUrl.getProtocol();
        }
        hostConfig.setHost(this.specimenUrl.getHost(), port, protocol);
        GetMethod httpMethod = new GetMethod(this.specimenUrl.toString());
        httpMethod.setFollowRedirects(this.followRedirects);
        HttpClient httpClient = new HttpClient();
        try {
            httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod);
        }
        catch (HttpException httpException) {
        }
        catch (IOException e) {
            HttpStaticScanResult scanResult = new HttpStaticScanResult(ScanResultCode.SCAN_FAILED, timeOfScan);
            scanResult.expectedResponseCode = this.expectedResponseCode;
            scanResult.expectedDataHash = this.expectedDataHash;
            scanResult.expectedDataHashAlgorithm = this.expectedDataHashAlgorithm;
            scanResult.specimenUrl = this.specimenUrl;
            this.logScanResult(ScanResultCode.SCAN_FAILED, scanResult.deviations, RULE_TYPE, this.specimenUrl.toString(), "Connection failed");
            return scanResult;
        }
        InputStream httpDataInStream = null;
        boolean inputError = false;
        try {
            httpDataInStream = httpMethod.getResponseBodyAsStream();
        }
        catch (IOException e) {
            inputError = true;
        }
        try {
            messageDigest = MessageDigest.getInstance(this.expectedDataHashAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ScanException("Hash algorithm (" + this.expectedDataHashAlgorithm + ") was not found", e);
        }
        byte[] inputBytes = new byte[4096];
        int bytesRead = 0;
        if (!inputError && httpDataInStream != null) {
            try {
                while ((bytesRead = httpDataInStream.read(inputBytes)) > 0) {
                    messageDigest.update(inputBytes, 0, bytesRead);
                }
            }
            catch (IOException e) {
                inputError = true;
            }
        }
        byte[] hashBytes = messageDigest.digest();
        String observedHashValue = new String(Hex.encodeHex(hashBytes));
        Header[] headers = httpMethod.getResponseHeaders();
        Vector<HttpHeaderScanResult> headerRuleMatches = new Vector<HttpHeaderScanResult>();
        int c = 0;
        while (c < headers.length) {
            HttpHeaderScanResult ruleResult = this.analyzeHeader(headers[c].getName(), headers[c].getValue());
            headerRuleMatches.add(ruleResult);
            ++c;
        }
        HttpStaticScanResult scanResult = inputError ? new HttpStaticScanResult(ScanResultCode.SCAN_FAILED, timeOfScan) : new HttpStaticScanResult(ScanResultCode.SCAN_COMPLETED, timeOfScan);
        scanResult.expectedResponseCode = this.expectedResponseCode;
        scanResult.expectedDataHash = this.expectedDataHash;
        scanResult.expectedDataHashAlgorithm = this.expectedDataHashAlgorithm;
        scanResult.specimenUrl = this.specimenUrl;
        scanResult.setActualHash(this.expectedDataHashAlgorithm, observedHashValue);
        scanResult.setActualResponseCode(httpMethod.getStatusCode());
        scanResult.headerResults = new HttpHeaderScanResult[headerRuleMatches.size()];
        int c2 = 0;
        while (c2 < headerRuleMatches.size()) {
            scanResult.headerResults[c2] = (HttpHeaderScanResult)headerRuleMatches.get(c2);
            ++c2;
        }
        this.logScanResult(ScanResultCode.SCAN_COMPLETED, scanResult.deviations, RULE_TYPE, this.specimenUrl.toString());
        return scanResult;
    }

    private HttpHeaderScanResult analyzeHeader(String headerName, String headerValue) {
        HttpHeaderScanResult headerRuleResult = null;
        int c = 0;
        while (c < this.headerRules.size()) {
            HttpHeaderRule headerRule = this.headerRules.get(c);
            int result = this.getDoesHeaderPassRule(headerName, headerValue, c);
            if (result == 1) {
                headerRuleResult = new HttpHeaderScanResult();
                headerRuleResult.ruleAction = 1;
                headerRuleResult.ruleId = headerRule.getRuleId();
                headerRuleResult.ruleResult = 3;
                headerRuleResult.nameActual = headerName;
                headerRuleResult.valueActual = headerValue;
                headerRuleResult.nameRule = headerRule.getHeaderNameString();
                headerRuleResult.nameRuleType = headerRule.getNameRuleType();
                headerRuleResult.valueRule = headerRule.getHeaderValueString();
                headerRuleResult.valueRuleType = headerRule.getValueRuleType();
                return headerRuleResult;
            }
            if (result == 2) {
                headerRuleResult = new HttpHeaderScanResult();
                headerRuleResult.nameRule = headerRule.getHeaderNameString();
                headerRuleResult.nameRuleType = headerRule.getNameRuleType();
                headerRuleResult.valueRule = headerRule.getHeaderValueString();
                headerRuleResult.valueRuleType = headerRule.getValueRuleType();
                headerRuleResult.ruleAction = 0;
                headerRuleResult.ruleId = headerRule.getRuleId();
                headerRuleResult.ruleResult = 4;
                headerRuleResult.nameActual = headerName;
                headerRuleResult.valueActual = headerValue;
            }
            ++c;
        }
        if (headerRuleResult != null) {
            return headerRuleResult;
        }
        headerRuleResult = new HttpHeaderScanResult();
        headerRuleResult.nameActual = headerName;
        headerRuleResult.valueActual = headerValue;
        headerRuleResult.ruleId = -1L;
        if (this.defaultDenyHeaders) {
            headerRuleResult.ruleAction = 1;
            headerRuleResult.ruleResult = 0;
        } else {
            headerRuleResult.ruleAction = 0;
            headerRuleResult.ruleResult = 1;
        }
        return headerRuleResult;
    }

    @Override
    public ScanResult loadScanResult(long scanResultId) throws SQLException, NoDatabaseConnectionException, ScanRule.ScanResultLoadFailureException {
        Connection connection = null;
        Statement statement = null;
        ResultSet httpResult = null;
        ResultSet result = null;
        Statement httpStatement = null;
        Statement httpHeaderStatement = null;
        ResultSet httpHeaderResult = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            statement = connection.prepareStatement("Select * from ScanResult where ScanResultID = ?");
            statement.setLong(1, scanResultId);
            result = statement.executeQuery();
            if (!result.next()) {
                return null;
            }
            ScanResultCode resultCode = ScanResultCode.getScanResultCodeById(result.getInt("ScanResultCode"));
            if (resultCode == null) {
                return null;
            }
            HttpStaticScanResult scanResult = new HttpStaticScanResult(resultCode, result.getTimestamp("ScanDate"));
            scanResult.ruleId = result.getLong("ScanRuleID");
            httpStatement = connection.prepareStatement("Select * from HttpHashScanResult where ScanResultID = ?");
            httpStatement.setLong(1, scanResultId);
            httpResult = httpStatement.executeQuery();
            scanResult.actualDataHash = httpResult.getString("ActualHashData");
            scanResult.actualDataHashAlgorithm = httpResult.getString("ActualHashAlgorithm");
            scanResult.actualResponseCode = httpResult.getInt("ActualResponseCode");
            scanResult.expectedDataHash = httpResult.getString("ExpectedHashData");
            scanResult.expectedDataHashAlgorithm = httpResult.getString("ExpectedHashAlgorithm");
            scanResult.expectedResponseCode = httpResult.getInt("ExpectedResponseCode");
            try {
                scanResult.specimenUrl = new URL(httpResult.getString("LocationUrl"));
            }
            catch (MalformedURLException e) {
                throw new ScanRule.ScanResultLoadFailureException("The URL associated with the scan result is invalid", e);
            }
            scanResult.deviations = httpResult.getInt("Deviations");
            httpHeaderStatement = connection.prepareStatement("Select * from HttpHeaderScanResult where ScanResultID = ?");
            httpHeaderStatement.setLong(1, scanResultId);
            httpHeaderResult = httpHeaderStatement.executeQuery();
            int n = 0;
            while (httpHeaderResult.next()) {
                ++n;
            }
            if (n > 0) {
                httpHeaderResult.first();
                HttpHeaderScanResult[] headerResults = new HttpHeaderScanResult[n];
                int c = 0;
                while (httpHeaderResult.next()) {
                    HttpHeaderScanResult httpHeaderScanResult = new HttpHeaderScanResult();
                    httpHeaderScanResult.nameActual = httpHeaderResult.getString("ActualHeaderName");
                    httpHeaderScanResult.nameRule = httpHeaderResult.getString("ExpectedHeaderName");
                    httpHeaderScanResult.nameRuleType = httpHeaderResult.getInt("HeaderNameType");
                    httpHeaderScanResult.ruleAction = httpHeaderResult.getInt("MatchAction");
                    httpHeaderScanResult.ruleId = httpHeaderResult.getLong("HttpHeaderScanRuleID");
                    httpHeaderScanResult.ruleResult = httpHeaderResult.getInt("RuleResult");
                    httpHeaderScanResult.valueActual = httpHeaderResult.getString("ActualHeaderValue");
                    httpHeaderScanResult.valueRule = httpHeaderResult.getString("ExpectedHeaderValue");
                    httpHeaderScanResult.valueRuleType = httpHeaderResult.getInt("HeaderValueType");
                    headerResults[c] = httpHeaderScanResult;
                    ++c;
                }
                scanResult.headerResults = headerResults;
            }
            HttpStaticScanResult httpStaticScanResult = scanResult;
            return httpStaticScanResult;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (httpStatement != null) {
                httpStatement.close();
            }
            if (httpResult != null) {
                httpResult.close();
            }
            if (httpHeaderStatement != null) {
                httpHeaderStatement.close();
            }
            if (httpHeaderResult != null) {
                httpHeaderResult.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private int getDoesHeaderPassRule(String headerName, String headerValue, int headerRuleIndex) {
        if (headerRuleIndex >= this.headerRules.size() || headerRuleIndex < 0) {
            throw new IllegalArgumentException("The header rule ID(" + headerRuleIndex + ") is not valid, no such rule exists");
        }
        if (headerName == null) {
            throw new IllegalArgumentException("The header name cannot be null");
        }
        if (headerValue == null) {
            throw new IllegalArgumentException("The header value cannot be null");
        }
        HttpHeaderRule headerRule = this.headerRules.get(headerRuleIndex);
        boolean ruleMatches = headerRule.doesNameMatch(headerName);
        if (!ruleMatches) {
            return 0;
        }
        boolean valueMatches = headerRule.doesValueMatch(headerValue);
        int matchAction = headerRule.getRuleType();
        if (valueMatches && matchAction == 0) {
            return 2;
        }
        if (valueMatches && matchAction == 1) {
            return 1;
        }
        if (!valueMatches && matchAction == 0) {
            return 1;
        }
        return 1;
    }

    public final void setExpectedResponseCode(int responseCode) throws IllegalArgumentException {
        if (responseCode < 0) {
            throw new IllegalArgumentException("The response code must not be less than 0");
        }
        this.expectedResponseCode = responseCode;
    }

    public int getExpectedResponseCode() {
        return this.expectedResponseCode;
    }

    public final void setExpectedDataHash(String hashAlgorithm, String hashValue) throws NoSuchAlgorithmException {
        MessageDigest.getInstance(hashAlgorithm);
        this.expectedDataHash = hashValue;
        this.expectedDataHashAlgorithm = hashAlgorithm;
    }

    public String getExpectedHashAlgorithm() {
        return this.expectedDataHashAlgorithm;
    }

    public String getExpectedDataHashValue() {
        return this.expectedDataHash;
    }

    public final void setUrl(URL url) {
        this.specimenUrl = url;
    }

    public URL getUrl() {
        return this.specimenUrl;
    }

    public void setDefaultDenyHeaderPolicy(boolean defaultDeny) {
        this.defaultDenyHeaders = defaultDeny;
    }

    public boolean getDefaultDenyHeaderPolicy() {
        return this.defaultDenyHeaders;
    }

    public final void setFollowRedirects(boolean follow) {
        this.followRedirects = follow;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    private boolean isReady() {
        if (this.specimenUrl == null) {
            return false;
        }
        if (this.expectedDataHash == null || this.expectedDataHashAlgorithm == null) {
            return false;
        }
        return this.expectedResponseCode != -1;
    }

    public boolean addHeaderRule(HttpHeaderRule headerRule) {
        return this.headerRules.add(headerRule);
    }

    public boolean removeHeaderRule(long headerRuleId) {
        if (headerRuleId < 0L) {
            throw new IllegalArgumentException("The header rule identifier is invalid");
        }
        int c = 0;
        while (c < this.headerRules.size()) {
            HttpHeaderRule headerRule = this.headerRules.get(c);
            if (headerRule.getRuleId() == headerRuleId) {
                this.headerRules.remove(c);
                this.headerRulesAwaitingDeletion.add(headerRuleId);
                return true;
            }
            ++c;
        }
        return false;
    }

    public static boolean deleteHeaderRule(long headerScanRuleId) throws SQLException, NoDatabaseConnectionException {
        Application appRes = Application.getApplication();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Delete * from HttpHeaderScanRule where HttpHeaderScanRuleID = ?");
            statement.setLong(1, headerScanRuleId);
            if (statement.executeUpdate() < 1) {
                connection.close();
                statement.close();
                return false;
            }
            connection.close();
            statement.close();
            return true;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public static boolean deleteRule(long scanRuleId) throws SQLException, NoDatabaseConnectionException {
        Application appRes = Application.getApplication();
        ScanRule.deleteRule(scanRuleId);
        Connection connection = null;
        Statement statement = null;
        try {
            connection = appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Delete from HttpHeaderScanRule where ScanRuleID = ?");
            statement.setLong(1, scanRuleId);
            statement.executeUpdate();
            statement.close();
            statement = null;
            statement = connection.prepareStatement("Delete from HttpHashScanRule where ScanRuleID = ?");
            statement.setLong(1, scanRuleId);
            return statement.executeUpdate() >= 1;
            {
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public long saveToDatabase() throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (this.scanRuleId == -1L) {
            throw new IllegalStateException("Scan rule must not be less than zero");
        }
        return this.saveToDatabaseEx(this.scanRuleId);
    }

    public long saveNewRuleToDatabase(long siteGroupId) throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (siteGroupId < 0L) {
            throw new IllegalArgumentException("Site group identifer must not be less than zero");
        }
        return this.saveNewRuleToDatabaseEx(siteGroupId);
    }

    public void saveToDatabase(long scanRuleId) throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (scanRuleId < 0L) {
            throw new IllegalArgumentException("Scan rule must not be less than zero");
        }
        this.saveToDatabaseEx(scanRuleId);
    }

    private synchronized long saveNewRuleToDatabaseEx(long siteGroupId) throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (siteGroupId < -1L) {
            throw new IllegalArgumentException("Site group ID is invalid (must not be less than zero)");
        }
        if (!this.isReady()) {
            throw new IllegalStateException("HTTP scan class cannot be persisted to database since critical information is missing");
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultKeys = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            this.scanRuleId = this.createRule(siteGroupId, this.getScanFrequency(), RULE_TYPE, 1);
            statement = connection.prepareStatement("Insert into HttpHashScanRule(LocationUrl, HashAlgorithm, HashData, ResponseCode, DefaultDenyHeaders, ScanRuleID) values(?, ?, ?, ?, ?, ?)", 1);
            statement.setString(1, this.specimenUrl.toString());
            statement.setString(2, this.expectedDataHashAlgorithm);
            statement.setString(3, this.expectedDataHash);
            statement.setInt(4, this.expectedResponseCode);
            statement.setBoolean(5, this.defaultDenyHeaders);
            statement.setLong(6, this.scanRuleId);
            statement.execute();
            resultKeys = statement.getGeneratedKeys();
            for (HttpHeaderRule headerRule : this.headerRules) {
                headerRule.saveToDatabase(connection, this.scanRuleId);
                headerRule.saveToDatabase(connection, this.scanRuleId);
            }
            long l = this.scanRuleId;
            return l;
        }
        finally {
            if (resultKeys != null) {
                resultKeys.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private synchronized long saveToDatabaseEx(long scanRuleId) throws IllegalStateException, SQLException, NoDatabaseConnectionException {
        if (scanRuleId < 0L) {
            throw new IllegalArgumentException("Scan rule ID is invalid (must not be less than zero)");
        }
        if (!this.isReady()) {
            throw new IllegalStateException("HTTP scan class cannot be persisted to database since critical information is missing");
        }
        Connection connection = null;
        Statement statement = null;
        Statement generalStatement = null;
        Statement statementDeleteOldHeaders = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Update HttpHashScanRule set LocationUrl = ?, HashAlgorithm = ?, HashData = ?, ResponseCode = ?, DefaultDenyHeaders = ? where ScanRuleID = ?");
            statement.setString(1, this.specimenUrl.toString());
            statement.setString(2, this.expectedDataHashAlgorithm);
            statement.setString(3, this.expectedDataHash);
            statement.setInt(4, this.expectedResponseCode);
            statement.setBoolean(5, this.defaultDenyHeaders);
            statement.setLong(6, scanRuleId);
            statement.executeUpdate();
            this.scanRuleId = scanRuleId;
            int c = 0;
            while (c < this.headerRulesAwaitingDeletion.size()) {
                Long httpHeaderRule = this.headerRulesAwaitingDeletion.get(c);
                statementDeleteOldHeaders = connection.prepareStatement("Delete from HttpHeaderScanRule where HttpHeaderScanRuleID = ?");
                statementDeleteOldHeaders.setLong(1, httpHeaderRule);
                statementDeleteOldHeaders.executeUpdate();
                statementDeleteOldHeaders.close();
                ++c;
            }
            for (HttpHeaderRule headerRule : this.headerRules) {
                headerRule.saveToDatabase(connection, scanRuleId);
            }
            generalStatement = connection.prepareStatement("Update ScanRule set ScanFrequency = ?, ScanDataObsolete = ?, Modified = ? where ScanRuleID = ?");
            generalStatement.setInt(1, this.getScanFrequency());
            generalStatement.setBoolean(2, true);
            generalStatement.setTimestamp(3, new Timestamp(new Date().getTime()));
            generalStatement.setLong(4, scanRuleId);
            generalStatement.executeUpdate();
            long l = this.scanRuleId;
            return l;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (generalStatement != null) {
                generalStatement.close();
            }
            if (statementDeleteOldHeaders != null) {
                statementDeleteOldHeaders.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public boolean updateHeaderRule(String headerName, String headerValue, int matchAction, long headerRuleId) {
        return this.updateHeaderRuleEx(headerName, headerValue, matchAction, headerRuleId);
    }

    public boolean updateHeaderRule(Pattern headerName, String headerValue, int matchAction, long headerRuleId) {
        return this.updateHeaderRuleEx(headerName, headerValue, matchAction, headerRuleId);
    }

    public boolean updateHeaderRule(String headerName, Pattern headerValue, int matchAction, long headerRuleId) {
        return this.updateHeaderRuleEx(headerName, headerValue, matchAction, headerRuleId);
    }

    public boolean updateHeaderRule(Pattern headerName, Pattern headerValue, int matchAction, long headerRuleId) {
        return this.updateHeaderRuleEx(headerName, headerValue, matchAction, headerRuleId);
    }

    private boolean updateHeaderRuleEx(Object headerName, Object headerValue, int matchAction, long headerRuleId) {
        int c = 0;
        while (c < this.headerRules.size()) {
            HttpHeaderRule rule = this.headerRules.get(c);
            if (rule != null && rule.getRuleId() == headerRuleId) {
                if (headerName instanceof String) {
                    rule.setHeaderName((String)headerName);
                } else {
                    rule.setHeaderName((Pattern)headerName);
                }
                if (headerValue instanceof String) {
                    rule.setHeaderValue((String)headerValue);
                } else {
                    rule.setHeaderValue((Pattern)headerValue);
                }
                rule.setRuleType(matchAction);
                return true;
            }
            ++c;
        }
        return false;
    }

    public HttpHeaderRule[] getHeaderRules() {
        HttpHeaderRule[] httpHeaderRulesArray = new HttpHeaderRule[this.headerRules.size()];
        int c = 0;
        while (c < this.headerRules.size()) {
            httpHeaderRulesArray[c] = this.headerRules.get(c);
            ++c;
        }
        return httpHeaderRulesArray;
    }

    public HttpHeaderRule getHeaderRule(String headerName) {
        int c = 0;
        while (c < this.headerRules.size()) {
            HttpHeaderRule headerRule = this.headerRules.get(c);
            if (headerRule.doesNameMatch(headerName)) {
                return headerRule;
            }
            ++c;
        }
        return null;
    }

    @Override
    public void delete() throws SQLException, NoDatabaseConnectionException {
        HttpStaticScanRule.deleteRule(this.scanRuleId);
        ScanRule.deleteRule(this.scanRuleId);
    }

    public static HttpStaticScanRule getFromHashtable(Hashtable<String, Object> hashtable) throws MalformedURLException {
        URL specimenUrl;
        String className = (String)hashtable.get("Class");
        if (className == null || !className.matches("net.lukemurphey.siteSentry.HttpScan")) {
            throw new IllegalArgumentException("Class name invalid");
        }
        String expectedDataHash = (String)hashtable.get("ExpectedHash");
        String expectedDataHashAlgorithm = (String)hashtable.get("ExpectedHashAlgorithm");
        String specimenUrlStr = (String)hashtable.get("URL");
        Boolean defaultDenyHeaders = (Boolean)hashtable.get("DefaultDenyHeaders");
        Integer expectedResponseCode = (Integer)hashtable.get("ExpectedResponseCode");
        Boolean followRedirects = (Boolean)hashtable.get("FollowRedirects");
        Long ruleId = (Long)hashtable.get("RuleID");
        Vector headerRulesVector = (Vector)hashtable.get("HeaderRules");
        Vector<HttpHeaderRule> headerRules = new Vector<HttpHeaderRule>();
        int c = 0;
        while (c < headerRulesVector.size()) {
            HttpHeaderRule httpHeaderRule = HttpHeaderRule.getFromHashtable((Hashtable)headerRulesVector.get(c));
            headerRules.add(httpHeaderRule);
            ++c;
        }
        HttpStaticScanRule httpScan = new HttpStaticScanRule(Application.getApplication());
        httpScan.headerRules = headerRules;
        httpScan.defaultDenyHeaders = defaultDenyHeaders;
        httpScan.expectedDataHashAlgorithm = expectedDataHashAlgorithm;
        httpScan.expectedDataHash = expectedDataHash;
        httpScan.expectedResponseCode = expectedResponseCode;
        httpScan.followRedirects = followRedirects;
        httpScan.scanRuleId = ruleId;
        httpScan.specimenUrl = specimenUrl = new URL(specimenUrlStr);
        return httpScan;
    }

    @Override
    public Hashtable<String, Object> toHashtable() {
        Hashtable<String, Object> hashtable = super.toHashtable();
        Vector<Hashtable<String, Object>> vectorHeaderRules = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < this.headerRules.size()) {
            HttpHeaderRule headerRule = this.headerRules.get(c);
            vectorHeaderRules.add(headerRule.toHashtable());
            ++c;
        }
        hashtable.put("Class", this.getClass().getName());
        hashtable.put("ExpectedHash", this.expectedDataHash);
        hashtable.put("ExpectedHashAlgorithm", this.expectedDataHashAlgorithm);
        hashtable.put("URL", this.specimenUrl.toString());
        hashtable.put("DefaultDenyHeaders", this.defaultDenyHeaders);
        hashtable.put("ExpectedResponseCode", this.expectedResponseCode);
        hashtable.put("FollowRedirects", this.followRedirects);
        hashtable.put("HeaderRules", vectorHeaderRules);
        return hashtable;
    }
}

