/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.GenericUtils;
import net.lukemurphey.nsia.scan.LineParseException;

public class NetworkPortRange {
    private static final Pattern REGEX_RANGE = Pattern.compile("([0-9]+)[ ]*\\-[ ]*([0-9]+)");
    private static final Pattern REGEX_PORT = Pattern.compile("[0-9]+");
    private static final Pattern REGEX_RANGE_PROTOCOL = Pattern.compile("(UDP|TCP)(\\\\|/)([0-9]+)[ ]*\\-[ ]*([0-9]+)");
    private static final Pattern REGEX_PORT_PROTOCOL = Pattern.compile("(UDP|TCP)(\\\\|/)([0-9]+)");
    private int startPort;
    private int endPort;
    private Protocol protocol;
    private SocketState state;

    public NetworkPortRange(int startPort, int endPort, Protocol protocol, SocketState state) {
        if (startPort < 0 || startPort > 65535) {
            throw new IllegalArgumentException("Port cannot be greater that 65535 or less than zero");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("The protocol cannot be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("The socket state cannot be null");
        }
        if (startPort > endPort) {
            throw new IllegalArgumentException("The start port must not be greater than the end port");
        }
        this.startPort = startPort;
        this.endPort = endPort;
        this.protocol = protocol;
        this.state = state;
    }

    public NetworkPortRange(int startPort, int endPort, Protocol protocol) {
        this(startPort, endPort, protocol, SocketState.UNDEFINED);
    }

    public NetworkPortRange(int startPort, Protocol protocol, SocketState state) {
        this(startPort, startPort, protocol, state);
    }

    public NetworkPortRange(int startPort, Protocol protocol) {
        this(startPort, startPort, protocol, SocketState.UNDEFINED);
    }

    public boolean overlapsWith(NetworkPortRange range) {
        return this.overlapsWith(range, false);
    }

    public boolean overlapsWith(NetworkPortRange range, boolean ignoreState) {
        if (range.protocol != this.protocol || !ignoreState && range.state != this.state) {
            return false;
        }
        if (range.startPort <= this.endPort && range.startPort >= this.startPort) {
            return true;
        }
        return range.startPort <= this.startPort && range.endPort >= this.startPort;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.protocol == Protocol.TCP) {
            result.append("TCP\\");
        } else {
            result.append("UDP\\");
        }
        result.append(this.startPort);
        if (this.endPort > this.startPort) {
            result.append("-");
            result.append(this.endPort);
        }
        return result.toString();
    }

    public int getNumberOfPorts() {
        return this.endPort - this.startPort + 1;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public SocketState getState() {
        return this.state;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public static NetworkPortRange[] removeFromRange(NetworkPortRange range, NetworkPortRange subtractRange) {
        NetworkPortRange first = null;
        NetworkPortRange second = null;
        if (range.getEndPort() < subtractRange.getStartPort()) {
            NetworkPortRange[] result = new NetworkPortRange[]{range};
            return result;
        }
        if (range.getStartPort() > subtractRange.getEndPort()) {
            NetworkPortRange[] result = new NetworkPortRange[]{range};
            return result;
        }
        if (subtractRange.getStartPort() <= range.getStartPort() && subtractRange.getEndPort() >= range.getEndPort()) {
            first = null;
            second = null;
        } else if (range.getEndPort() >= subtractRange.getStartPort()) {
            if (subtractRange.getStartPort() <= range.getStartPort()) {
                first = null;
            } else if (range.getEndPort() >= subtractRange.getStartPort()) {
                first = new NetworkPortRange(range.getStartPort(), subtractRange.getStartPort() - 1, range.protocol);
            }
            if (range.getEndPort() > subtractRange.getEndPort()) {
                second = new NetworkPortRange(subtractRange.getEndPort() + 1, range.getEndPort(), range.protocol);
            }
        } else {
            first = new NetworkPortRange(subtractRange.getStartPort() + 1, range.getEndPort(), range.protocol);
        }
        if (first == null && second != null) {
            NetworkPortRange[] result = new NetworkPortRange[]{second};
            return result;
        }
        if (first != null && second != null) {
            NetworkPortRange[] result = new NetworkPortRange[]{first, second};
            return result;
        }
        if (first != null && second == null) {
            NetworkPortRange[] result = new NetworkPortRange[]{first};
            return result;
        }
        NetworkPortRange[] result = new NetworkPortRange[]{};
        return result;
    }

    public static String convertToString(NetworkPortRange[] ports) {
        if (ports == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        int c = 0;
        while (c < ports.length) {
            if (c > 0) {
                result.append("\n");
            }
            result.append(ports[c].toString());
            ++c;
        }
        return result.toString();
    }

    public static NetworkPortRange[] parseRange(String portsList) throws LineParseException {
        return NetworkPortRange.parseRange(SocketState.UNDEFINED, portsList);
    }

    public static NetworkPortRange[] parseRange(SocketState state, String portsList) throws LineParseException {
        int entries = 0;
        NetworkPortRange[] portsListArray = new NetworkPortRange[32];
        BufferedReader reader = new BufferedReader(new StringReader(portsList));
        try {
            String currentLine;
            int lineNumber = 0;
            while ((currentLine = reader.readLine()) != null) {
                if ((currentLine = currentLine.trim()).length() > 0) {
                    Protocol protocol;
                    Matcher range = REGEX_RANGE_PROTOCOL.matcher(currentLine);
                    Matcher port = REGEX_PORT_PROTOCOL.matcher(currentLine);
                    if (entries >= portsListArray.length) {
                        portsListArray = (NetworkPortRange[])GenericUtils.resizeArray(portsListArray, portsListArray.length + 16);
                    }
                    if (range.matches()) {
                        protocol = range.group(1).equals("UDP") ? Protocol.UDP : Protocol.TCP;
                        int start = Integer.parseInt(range.group(3));
                        int end = Integer.parseInt(range.group(4));
                        portsListArray[entries] = new NetworkPortRange(start, end, protocol, state);
                    } else if (port.matches()) {
                        protocol = port.group(1).equals("UDP") ? Protocol.UDP : Protocol.TCP;
                        portsListArray[entries] = new NetworkPortRange(Integer.parseInt(port.group(3)), protocol, state);
                    } else {
                        throw new LineParseException("The port number is invalid", lineNumber);
                    }
                    ++entries;
                }
                ++lineNumber;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (entries < portsListArray.length) {
            portsListArray = (NetworkPortRange[])GenericUtils.resizeArray(portsListArray, entries);
        }
        return portsListArray;
    }

    public static NetworkPortRange[] parseRange(Protocol protocol, SocketState state, String portsList) throws LineParseException {
        int entries = 0;
        NetworkPortRange[] portsListArray = new NetworkPortRange[32];
        BufferedReader reader = new BufferedReader(new StringReader(portsList));
        try {
            String currentLine;
            int lineNumber = 0;
            while ((currentLine = reader.readLine()) != null) {
                if ((currentLine = currentLine.trim()).length() > 0) {
                    Matcher range = REGEX_RANGE.matcher(currentLine);
                    Matcher port = REGEX_PORT.matcher(currentLine);
                    if (entries >= portsListArray.length) {
                        portsListArray = (NetworkPortRange[])GenericUtils.resizeArray(portsListArray, portsListArray.length + 16);
                    }
                    if (range.matches()) {
                        int start = Integer.parseInt(currentLine.substring(0, currentLine.indexOf("-")).trim());
                        int end = Integer.parseInt(currentLine.substring(currentLine.indexOf("-") + 1, currentLine.length()).trim());
                        portsListArray[entries] = new NetworkPortRange(start, end, protocol, state);
                    } else if (port.matches()) {
                        portsListArray[entries] = new NetworkPortRange(Integer.parseInt(currentLine), protocol, state);
                    } else {
                        throw new LineParseException("The port number is invalid", lineNumber);
                    }
                    ++entries;
                }
                ++lineNumber;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (entries < portsListArray.length) {
            portsListArray = (NetworkPortRange[])GenericUtils.resizeArray(portsListArray, entries);
        }
        return portsListArray;
    }

    public static SocketState find(int port, Protocol protocol, NetworkPortRange[] portRange) {
        return NetworkPortRange.findInternal(port, protocol, null, portRange);
    }

    public static boolean isWithin(int port, Protocol protocol, SocketState state, NetworkPortRange[] portRange) {
        if (state == null) {
            throw new IllegalArgumentException("The socket state cannot be null");
        }
        return NetworkPortRange.findInternal(port, protocol, state, portRange) != null;
    }

    public static NetworkPortRange[] computeScannedResultRange(NetworkPortRange[] deviations, NetworkPortRange[] scanned, NetworkPortRange[] expectedOpen) {
        NetworkPortRange[] tmp = new NetworkPortRange[scanned.length];
        System.arraycopy(scanned, 0, tmp, 0, scanned.length);
        NetworkPortRange.sort(tmp);
        Vector<NetworkPortRange> result = new Vector<NetworkPortRange>();
        NetworkPortRange prior = null;
        int c = 0;
        while (c < scanned.length) {
            int curPort = scanned[c].getStartPort();
            while (curPort >= scanned[c].getStartPort() && curPort <= scanned[c].getEndPort()) {
                SocketState newSocketState = null;
                SocketState inDeviations = NetworkPortRange.find(curPort, scanned[c].getProtocol(), deviations);
                newSocketState = inDeviations != null ? inDeviations : (NetworkPortRange.isWithin(curPort, scanned[c].getProtocol(), expectedOpen) ? SocketState.OPEN : SocketState.CLOSED);
                if (prior == null) {
                    prior = new NetworkPortRange(scanned[c].getStartPort(), scanned[c].getStartPort(), scanned[c].getProtocol(), newSocketState);
                    result.add(prior);
                } else if (prior.state == newSocketState && prior.protocol == scanned[c].getProtocol() && prior.getEndPort() + 1 == curPort) {
                    ++prior.endPort;
                } else {
                    result.add(new NetworkPortRange(curPort, curPort, scanned[c].getProtocol(), newSocketState));
                    prior = (NetworkPortRange)result.get(result.size() - 1);
                }
                ++curPort;
            }
            ++c;
        }
        NetworkPortRange[] resultArray = new NetworkPortRange[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public static void sort(NetworkPortRange[] range) {
        if (range == null) {
            throw new IllegalArgumentException("The range cannot be null");
        }
        Arrays.sort(range, new NetworkPortRangeComparator());
    }

    public static boolean isWithin(int port, Protocol protocol, NetworkPortRange[] portRange) {
        return NetworkPortRange.findInternal(port, protocol, null, portRange) != null;
    }

    private static SocketState findInternal(int port, Protocol protocol, SocketState state, NetworkPortRange[] portRange) {
        if (portRange == null) {
            throw new IllegalArgumentException("The network port range to compare to cannot be null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("The port cannot be null");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("The network port is invalid (must be within 0-65535)");
        }
        int c = 0;
        while (c < portRange.length) {
            if (protocol == portRange[c].protocol && portRange[c].startPort >= port && portRange[c].endPort <= port && (state == null || state == portRange[c].state)) {
                return portRange[c].state;
            }
            ++c;
        }
        return null;
    }

    private static class NetworkPortRangeComparator
    implements Comparator<NetworkPortRange> {
        private NetworkPortRangeComparator() {
        }

        @Override
        public int compare(NetworkPortRange range1, NetworkPortRange range2) {
            if (range1.protocol == Protocol.UDP && range2.protocol == Protocol.TCP) {
                return -1;
            }
            if (range1.protocol == Protocol.TCP && range2.protocol == Protocol.UDP) {
                return 1;
            }
            if (range1.startPort <= range2.startPort) {
                return -1;
            }
            return 1;
        }
    }

    public static enum Protocol {
        UDP,
        TCP;

    }

    public static enum SocketState {
        OPEN,
        CLOSED,
        NO_RESPONSE,
        UNDEFINED;

    }
}

