/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.lukemurphey.nsia.MimeType;
import net.lukemurphey.nsia.Wildcard;
import net.lukemurphey.nsia.scan.ByteEvaluator;
import net.lukemurphey.nsia.scan.ByteJumpEvaluator;
import net.lukemurphey.nsia.scan.ByteTestEvaluator;
import net.lukemurphey.nsia.scan.DataSpecimen;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.Evaluator;
import net.lukemurphey.nsia.scan.InvalidDefinitionException;
import net.lukemurphey.nsia.scan.InvalidEvaluatorException;
import net.lukemurphey.nsia.scan.IsDataAtEvaluator;
import net.lukemurphey.nsia.scan.Pcre;
import net.lukemurphey.nsia.scan.RegexEvaluator;
import net.lukemurphey.nsia.scan.StringEvaluator;
import net.lukemurphey.nsia.scan.UnpurposedDefinitionException;
import net.lukemurphey.nsia.scan.scriptenvironment.Variables;
import org.apache.commons.lang.StringUtils;

public class PatternDefinition
extends Definition {
    private static final Pattern RULE_REGEX = Pattern.compile("[ ]*(Block|Alert|Eval|Evaluate)[ ]*\\([ ]*((([^\\\\\"]|(\\\\\\\\)|(\\\\\"))*?)|(\"(([^\\\\\"]|(\\\\\\\\)|(\\\\\"))+)\"))?[ ]*\\)\\s*\\{((([^\\\\\"}]|(\\\\\\\\)|(\\\\\")|(\\\\[^\"]))++|\"(([^\\\\\"])|(\\\\\\\\)|(\\\\\")|(\\\\[^\"]))++\")*)\\}\\s*", 40);
    private static final Pattern RULE_OPTIONS_REGEX = Pattern.compile("[ ]*((([a-zA-Z]+)[ ]*((\\!)?[ ]*(=)(([^\";][^;]*)|(\"(([^\\\\\"]|(\\\\\\\\)*|\\\\\"|\\\\[^\"])+)\")))?)[ ]*;?)+");
    private boolean basicEncoding = false;
    private Vector<Evaluator> evaluators = new Vector();
    private Variables mustBeSet = new Variables();
    private Variables unSet = new Variables();
    private Variables toggleSet = new Variables();
    private Variables mustNotBeSet = new Variables();
    private Variables set = new Variables();
    private String contentTypeRestriction = null;
    private Pattern contentTypeRegex = null;
    private String uriRestriction = null;
    private Pattern uriRegex = null;
    private String code;

    private PatternDefinition() {
        this.definitionType = "ThreatPattern";
    }

    public static PatternDefinition[] parseAll(String rules) throws InvalidDefinitionException, UnpurposedDefinitionException {
        Matcher matcher = RULE_REGEX.matcher(rules);
        Vector<PatternDefinition> threatSignatures = new Vector<PatternDefinition>();
        int lastEnd = -1;
        boolean firstRun = true;
        while (matcher.find()) {
            int startOfMatch = matcher.start();
            if (!firstRun) {
                if (lastEnd != matcher.start()) {
                    String message = "Rule parse exception starting at line " + PatternDefinition.getLineNumber(rules, lastEnd + 1);
                    if (threatSignatures.size() > 0) {
                        message = String.valueOf(message) + " (successfully parsed through " + ((PatternDefinition)threatSignatures.get(threatSignatures.size() - 1)).getFullName() + ")";
                    }
                    throw new InvalidDefinitionException(message);
                }
            } else if (firstRun && startOfMatch != 0) {
                throw new InvalidDefinitionException("Rule parse exception starting at beginning of input (line 1)");
            }
            lastEnd = matcher.end();
            firstRun = false;
            try {
                threatSignatures.add(PatternDefinition.parse(matcher.group(0)));
            }
            catch (InvalidDefinitionException e) {
                String message = "Invalid signature exception near line " + PatternDefinition.getLineNumber(rules, matcher.start() + 1) + ". " + e.getMessage() + ".";
                if (threatSignatures.size() > 0) {
                    message = String.valueOf(message) + " (successfully parsed through " + ((PatternDefinition)threatSignatures.get(threatSignatures.size() - 1)).getFullName() + ")";
                }
                throw new InvalidDefinitionException(message, e);
            }
            catch (UnpurposedDefinitionException e) {
                String message = "Unpurposed rule exception near line " + PatternDefinition.getLineNumber(rules, matcher.start() + 1) + ". " + e.getMessage() + ".";
                if (threatSignatures.size() > 0) {
                    message = String.valueOf(message) + " (successfully parsed through " + ((PatternDefinition)threatSignatures.get(threatSignatures.size() - 1)).getFullName() + ")";
                }
                throw new UnpurposedDefinitionException(message);
            }
        }
        if (lastEnd != rules.length()) {
            throw new InvalidDefinitionException("Rule parse exception at end of input, starting at line " + PatternDefinition.getLineNumber(rules, rules.length()));
        }
        PatternDefinition[] signaturesArray = new PatternDefinition[threatSignatures.size()];
        threatSignatures.toArray(signaturesArray);
        return signaturesArray;
    }

    private static int getLineNumber(String data, int characterPosition) {
        if (characterPosition < data.length()) {
            data = data.substring(0, characterPosition);
        }
        int unixEndlines = StringUtils.countMatches((String)data, (String)"\r\n");
        int macEndlines = StringUtils.countMatches((String)data, (String)"\n\r");
        int windowsEndlines = StringUtils.countMatches((String)data, (String)"\n");
        return 1 + Math.max(Math.max(unixEndlines, macEndlines), windowsEndlines);
    }

    public static PatternDefinition parse(String rule) throws InvalidDefinitionException, UnpurposedDefinitionException {
        return PatternDefinition.parse(rule, -1);
    }

    public static PatternDefinition parse(String rule, int localID) throws InvalidDefinitionException, UnpurposedDefinitionException {
        if (rule == null) {
            throw new InvalidDefinitionException("The rule cannot be null");
        }
        if (rule.isEmpty()) {
            throw new InvalidDefinitionException("The rule must be be empty");
        }
        Matcher matcher = RULE_REGEX.matcher(rule);
        if (!matcher.find() || matcher.groupCount() < 20) {
            throw new InvalidDefinitionException("The rule does not appear to be valid");
        }
        if (!matcher.matches()) {
            throw new InvalidDefinitionException("The rule does not appear to be valid");
        }
        PatternDefinition threatSignature = new PatternDefinition();
        String actionString = matcher.group(1).trim();
        if (actionString.equalsIgnoreCase("Alert")) {
            threatSignature.action = Definition.Action.ALERT;
        } else if (actionString.equalsIgnoreCase("Block")) {
            threatSignature.action = Definition.Action.BLOCK;
        } else if (actionString.equalsIgnoreCase("Eval")) {
            threatSignature.action = Definition.Action.EVAL;
        } else if (actionString.equalsIgnoreCase("Evaluate")) {
            threatSignature.action = Definition.Action.EVAL;
        }
        if (matcher.group(8) != null) {
            threatSignature.parseFullName(matcher.group(8));
        } else {
            threatSignature.parseFullName(matcher.group(2));
        }
        Matcher optionMatcher = RULE_OPTIONS_REGEX.matcher(matcher.group(12));
        Evaluator currentEvaluator = null;
        while (optionMatcher.find()) {
            boolean negateValue = false;
            if (optionMatcher.group(5) != null && optionMatcher.group(5).equalsIgnoreCase("!")) {
                negateValue = true;
            }
            String value = null;
            if (optionMatcher.group(10) != null) {
                value = optionMatcher.group(10);
            } else if (optionMatcher.group(7) != null) {
                value = optionMatcher.group(7);
            }
            currentEvaluator = threatSignature.acceptOption(currentEvaluator, optionMatcher.group(3), value, negateValue);
        }
        threatSignature.code = rule;
        threatSignature.localId = localID;
        threatSignature.checkConfiguration();
        return threatSignature;
    }

    @Override
    public String toString() {
        return String.valueOf(this.category) + "." + this.subCategory + "." + this.name;
    }

    public String getContentTypePattern() {
        return this.contentTypeRestriction;
    }

    public String getRuleCode() {
        return this.code;
    }

    private void checkConfiguration() throws InvalidDefinitionException, UnpurposedDefinitionException {
        int d;
        if (this.category == null || this.category.isEmpty()) {
            throw new InvalidDefinitionException("Class name was not provided and is not optional");
        }
        if (this.subCategory == null || this.subCategory.isEmpty()) {
            throw new InvalidDefinitionException("Sub-class name was not provided and is not optional");
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new InvalidDefinitionException("Signature name was not provided and is not optional");
        }
        if (this.message == null || this.message.isEmpty()) {
            throw new InvalidDefinitionException("Message was not provided and is not optional");
        }
        if (this.action == null) {
            throw new InvalidDefinitionException("Action was not provided name was not provided and is not optional");
        }
        if (this.action != null && this.action == Definition.Action.EVAL && this.set.size() == 0 && this.unSet.size() == 0) {
            throw new UnpurposedDefinitionException("This rule has no purpose. The action of this rule is to evaluate, therefore the rule must set or unset a value with a Set or an UnSet option. Otherwise, it does nothing.");
        }
        if (this.contentTypeRegex == null && this.uriRegex == null && this.evaluators.size() == 0 && this.set.size() == 0 && this.unSet.size() == 0) {
            throw new UnpurposedDefinitionException("This rule does nothing since it neither sets or unsets any values and does not evaluate any input.");
        }
        int c = 0;
        while (c < this.unSet.size()) {
            d = 0;
            while (d < this.set.size()) {
                if (this.unSet.get(c).equalsIgnoreCase(this.set.get(d))) {
                    throw new InvalidDefinitionException("This rule contains ambiguous variables (includes 'Set' and 'UnSet' options for \"" + this.set.get(d) + "\")");
                }
                ++d;
            }
            d = 0;
            while (d < this.toggleSet.size()) {
                if (this.unSet.get(c).equalsIgnoreCase(this.toggleSet.get(d))) {
                    throw new InvalidDefinitionException("This rule contains ambiguous variables (includes 'Toggle' and 'UnSet' options for \"" + this.toggleSet.get(d) + "\")");
                }
                ++d;
            }
            ++c;
        }
        c = 0;
        while (c < this.set.size()) {
            d = 0;
            while (d < this.toggleSet.size()) {
                if (this.set.get(c).equalsIgnoreCase(this.toggleSet.get(d))) {
                    throw new InvalidDefinitionException("This rule contains ambiguous variables (includes 'Toggle' and 'Set' options for \"" + this.toggleSet.get(d) + "\")");
                }
                ++d;
            }
            ++c;
        }
        c = 0;
        while (c < this.mustBeSet.size()) {
            d = 0;
            while (d < this.mustNotBeSet.size()) {
                if (this.mustNotBeSet.get(d).equalsIgnoreCase(this.mustBeSet.get(c))) {
                    throw new InvalidDefinitionException("This rule contains ambiguous variable qualification (includes 'IfSet' and 'IfNOtSet' options for \"" + this.mustNotBeSet.get(d) + "\")");
                }
                ++d;
            }
            ++c;
        }
        if (this.hasMixedModeSignatures()) {
            throw new InvalidDefinitionException("This rule contains mixed-mode patterns. Patterns that operate on a byte-level cannot be combined with patterns that operator at the character level because most encodings do not have the same number of bytes as characters. Use the BasicEncoding option to analyze the data assuming a single byte of data per character.)");
        }
        if (this.severity == Definition.Severity.UNDEFINED && this.action != Definition.Action.EVAL) {
            throw new InvalidDefinitionException("The severity was not defined.");
        }
        this.checkForEvaluatorsWithInvalidPosition();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Evaluator acceptOption(Evaluator evaluator, String option, String value, boolean negate) throws InvalidDefinitionException {
        void var5_12;
        block80: {
            option = option.trim();
            Object var5_5 = null;
            if (value != null) {
                value = PatternDefinition.escapeString(value);
                if (option.equalsIgnoreCase("Message")) {
                    this.message = value;
                } else {
                    if (option.equalsIgnoreCase("Regex")) {
                        try {
                            RegexEvaluator regexEvaluator = new RegexEvaluator(value, false);
                            this.evaluators.add(regexEvaluator);
                            RegexEvaluator regexEvaluator2 = regexEvaluator;
                            regexEvaluator.negation = negate;
                        }
                        catch (PatternSyntaxException e) {
                            throw new InvalidDefinitionException("The regex evaluator is invalid (" + e.getMessage() + ")");
                        }
                        catch (InvalidEvaluatorException e) {
                            throw new InvalidDefinitionException("The regex evaluator is invalid (" + e.getMessage() + ")");
                        }
                    }
                    if (option.equalsIgnoreCase("String")) {
                        StringEvaluator stringEvaluator = new StringEvaluator(value, false);
                        this.evaluators.add(stringEvaluator);
                        StringEvaluator stringEvaluator2 = stringEvaluator;
                        stringEvaluator.negation = negate;
                    } else if (option.equalsIgnoreCase("Byte")) {
                        ByteEvaluator byteEvaluator = ByteEvaluator.parse(value);
                        this.evaluators.add(byteEvaluator);
                        ByteEvaluator byteEvaluator2 = byteEvaluator;
                        byteEvaluator.negation = negate;
                    } else {
                        if (option.equalsIgnoreCase("ByteTest")) {
                            try {
                                ByteTestEvaluator byteTestEvaluator = ByteTestEvaluator.parse(value);
                                this.evaluators.add(byteTestEvaluator);
                                ByteTestEvaluator byteTestEvaluator2 = byteTestEvaluator;
                                byteTestEvaluator.negation = negate;
                            }
                            catch (PatternSyntaxException e) {
                                throw new InvalidDefinitionException("The ByteTest evaluator is invalid (" + e.getMessage() + ")");
                            }
                            catch (InvalidEvaluatorException e) {
                                throw new InvalidDefinitionException("The ByteTest evaluator is invalid (" + e.getMessage() + ")");
                            }
                        }
                        if (option.equalsIgnoreCase("ByteJump")) {
                            try {
                                ByteJumpEvaluator byteJumpEvaluator = ByteJumpEvaluator.parse(value);
                                this.evaluators.add(byteJumpEvaluator);
                                ByteJumpEvaluator byteJumpEvaluator2 = byteJumpEvaluator;
                                if (negate) {
                                    throw new InvalidDefinitionException("The ByteJump evaluator cannot be negated");
                                }
                                break block80;
                            }
                            catch (PatternSyntaxException e) {
                                throw new InvalidDefinitionException("The ByteJump evaluator is invalid (" + e.getMessage() + ")");
                            }
                            catch (InvalidEvaluatorException e) {
                                throw new InvalidDefinitionException("The ByteJump evaluator is invalid (" + e.getMessage() + ")");
                            }
                        }
                        if (option.equalsIgnoreCase("IfSet")) {
                            this.mustBeSet.set(value);
                        } else if (option.equalsIgnoreCase("IfNotSet")) {
                            this.mustNotBeSet.set(value);
                        } else if (option.equalsIgnoreCase("UnSet")) {
                            this.unSet.set(value);
                        } else if (option.equalsIgnoreCase("Set")) {
                            this.set.set(value);
                        } else if (option.equalsIgnoreCase("Toggle")) {
                            this.toggleSet.set(value);
                        } else {
                            if (option.equalsIgnoreCase("Version")) {
                                try {
                                    this.revision = Integer.parseInt(value);
                                }
                                catch (NumberFormatException e) {
                                    throw new InvalidDefinitionException("The value for the version is not a valid integer (" + value + ")");
                                }
                            }
                            if (option.equalsIgnoreCase("ID")) {
                                try {
                                    this.id = Integer.parseInt(value);
                                }
                                catch (NumberFormatException e) {
                                    throw new InvalidDefinitionException("The value for the ID is not a valid integer (" + value + ")");
                                }
                                if (this.id < 1) {
                                    throw new InvalidDefinitionException("The value for the ID must be greater than zero");
                                }
                            } else if (option.equalsIgnoreCase("Reference")) {
                                Definition.Reference reference = Definition.Reference.parse(value);
                                this.references.add(reference);
                            } else if (option.equalsIgnoreCase("Depth")) {
                                int depth = -1;
                                try {
                                    depth = Integer.parseInt(value);
                                }
                                catch (NumberFormatException e) {
                                    throw new InvalidDefinitionException("The value for the depth option is not a valid integer (" + value + ")");
                                }
                                if (evaluator == null) {
                                    throw new InvalidDefinitionException("The depth option can only be used after an evaluator has been defined");
                                }
                                if (evaluator.depth > 0) {
                                    throw new InvalidDefinitionException("The depth option is ambiguously defined (set more than once for the same evaluator)");
                                }
                                if (depth <= 0) {
                                    throw new InvalidDefinitionException("The depth option must be greater than zero (otherwise the signature evaluates no data)");
                                }
                                evaluator.setDepth(depth);
                            } else if (option.equalsIgnoreCase("Within")) {
                                int within = -1;
                                try {
                                    within = Integer.parseInt(value);
                                }
                                catch (NumberFormatException e) {
                                    throw new InvalidDefinitionException("The value for the within option is not a valid integer (" + value + ")");
                                }
                                if (evaluator == null) {
                                    throw new InvalidDefinitionException("The within option can only be used after an evaluator has been defined");
                                }
                                if (within <= 0) {
                                    throw new InvalidDefinitionException("The within option must be greater than zero (otherwise the signature can never match)");
                                }
                                evaluator.setWithin(within);
                            } else if (option.equalsIgnoreCase("Offset")) {
                                Offset offset = new Offset(value);
                                if (evaluator == null) {
                                    throw new InvalidDefinitionException("The offset option can only be used after an evaluator has been defined");
                                }
                                if (offset.getOffsetType() == Evaluator.OffsetRelativity.RELATIVE && this.evaluators.size() < 2) {
                                    throw new InvalidDefinitionException("A relative offset was specified, however, the given evaluator has no other evaluators to be relative to. Specify an absolute offset if you want the offset to be relative to beginning of the data.");
                                }
                                evaluator.setOffset(offset.getValue(), offset.getOffsetType());
                            } else if (option.equalsIgnoreCase("Severity")) {
                                if (value.equalsIgnoreCase("low")) {
                                    this.severity = Definition.Severity.LOW;
                                } else if (value.equalsIgnoreCase("medium") || value.equalsIgnoreCase("med")) {
                                    this.severity = Definition.Severity.MEDIUM;
                                } else {
                                    if (!value.equalsIgnoreCase("high")) throw new InvalidDefinitionException("The severity level given (" + value + ") is invalid");
                                    this.severity = Definition.Severity.HIGH;
                                }
                            } else if (option.equalsIgnoreCase("ContentType")) {
                                this.contentTypeRestriction = value;
                                try {
                                    if (this.contentTypeRestriction == null) {
                                        throw new InvalidDefinitionException("The content-type was not specified");
                                    }
                                    if (this.contentTypeRestriction.startsWith("/")) {
                                        this.contentTypeRegex = Pcre.parse(this.contentTypeRestriction);
                                    }
                                    Wildcard wildcard = new Wildcard(this.contentTypeRestriction, true);
                                    this.contentTypeRegex = wildcard.getPattern();
                                }
                                catch (PatternSyntaxException e) {
                                    throw new InvalidDefinitionException("The content-type evaluator is invalid (" + e.getMessage() + ")");
                                }
                            } else {
                                if (!option.equalsIgnoreCase("URI")) throw new InvalidDefinitionException("The following option is invalid: " + option);
                                try {
                                    this.uriRestriction = value;
                                    if (this.uriRestriction == null) {
                                        throw new InvalidDefinitionException("The URI was not specified");
                                    }
                                    if (this.uriRestriction.startsWith("/")) {
                                        this.uriRegex = Pcre.parse(this.uriRestriction);
                                    }
                                    Wildcard wildcard = new Wildcard(this.uriRestriction, true);
                                    this.uriRegex = wildcard.getPattern();
                                }
                                catch (PatternSyntaxException e) {
                                    throw new InvalidDefinitionException("The URI option is invalid (" + e.getMessage() + ")");
                                }
                            }
                        }
                    }
                }
            } else if (option.equalsIgnoreCase("BasicEncoding")) {
                this.basicEncoding = true;
            } else if (option.equalsIgnoreCase("IgnoreCase") || option.equalsIgnoreCase("NoCase")) {
                if (evaluator == null) throw new InvalidDefinitionException("The IgnoreCase option can only be used after a String evaluator has been defined");
                try {
                    StringEvaluator stringEvaluator = (StringEvaluator)evaluator;
                    stringEvaluator.setIgnoreCase(true);
                }
                catch (ClassCastException e) {
                    throw new InvalidDefinitionException("The IgnoreCase option can only be used with the String evaluator");
                }
            } else {
                if (!option.equalsIgnoreCase("IsDataAt")) throw new InvalidDefinitionException("The following option is invalid: " + option);
                IsDataAtEvaluator isDataAtEvaluator = new IsDataAtEvaluator();
                this.evaluators.add(isDataAtEvaluator);
                IsDataAtEvaluator isDataAtEvaluator2 = isDataAtEvaluator;
                isDataAtEvaluator.negation = negate;
            }
        }
        if (var5_12 == null) return evaluator;
        return var5_12;
    }

    private static String escapeString(String value) {
        String result = StringUtils.replace((String)value, (String)"\\\\", (String)"\\");
        result = StringUtils.replace((String)result, (String)"\\\"", (String)"\"");
        return result;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAction(Definition.Action action) {
        this.action = action;
    }

    public void setNotes(String notes) {
        this.message = notes;
    }

    public void setTypeName(String primaryName) {
        this.category = primaryName;
    }

    public void setSubTypeName(String secondaryName) {
        this.subCategory = secondaryName;
    }

    public void addEvaluator(Evaluator evaluator) {
        this.evaluators.add(evaluator);
    }

    public boolean evaluate(String input, Variables variables) throws InvalidDefinitionException {
        return this.evaluate(new DataSpecimen(input), variables);
    }

    public boolean evaluate(byte[] input, Variables variables) throws InvalidDefinitionException {
        return this.evaluate(new DataSpecimen(input), variables);
    }

    public boolean evaluate(byte[] input, Variables variables, String filename, String suggestedContentType) throws InvalidDefinitionException {
        Matcher matcher;
        String mimeType;
        if (this.contentTypeRegex != null && (mimeType = MimeType.getMimeType(input, filename, suggestedContentType)) != null && !(matcher = this.contentTypeRegex.matcher(mimeType)).matches()) {
            return false;
        }
        return this.evaluate(new DataSpecimen(input), variables);
    }

    private void checkForEvaluatorsWithInvalidPosition() throws InvalidDefinitionException {
        int c = 0;
        while (c < this.evaluators.size()) {
            if (this.evaluators.get(c) instanceof ByteEvaluator) {
                this.checkForEvaluatorWithInvalidPosition(this.evaluators.get(c), ((ByteEvaluator)this.evaluators.get(c)).getBytesToMatch().length, c);
            } else if (this.evaluators.get(c) instanceof StringEvaluator) {
                this.checkForEvaluatorWithInvalidPosition(this.evaluators.get(c), ((StringEvaluator)this.evaluators.get(c)).getStringToMatch().length(), c);
            }
            ++c;
        }
    }

    private void checkForEvaluatorWithInvalidPosition(Evaluator eval, int specimenLength, int index) throws InvalidDefinitionException {
        int depth = eval.getDepth();
        if (depth < 0) {
            return;
        }
        if (depth < specimenLength) {
            throw new InvalidDefinitionException("The evaluator at position " + index + " has a depth limit that will not allow the signature to ever match. The depth limit of " + depth + " will not allow an evaluator of length " + specimenLength + " to ever match.");
        }
    }

    private boolean hasMixedModeSignatures() {
        if (this.basicEncoding) {
            return false;
        }
        Evaluator.ReturnType returnType = null;
        int c = 0;
        while (c < this.evaluators.size()) {
            if (c == 0 || !this.evaluators.get(c).isRelative()) {
                returnType = this.evaluators.get(c).getReturnType();
            } else if (returnType != this.evaluators.get(c).getReturnType()) {
                return true;
            }
            ++c;
        }
        return false;
    }

    private boolean evaluateFromPosition(int evaluatorIndex, DataSpecimen input) throws InvalidDefinitionException {
        int position = -1;
        Evaluator startEvaluator = this.evaluators.get(evaluatorIndex);
        Evaluator.ReturnType returnType = startEvaluator.getReturnType();
        int length = returnType == Evaluator.ReturnType.BYTE_LOCATION ? input.getBytesLength() : input.getStringLength();
        while (position < length - 1) {
            if ((position = startEvaluator.evaluate(input, position, this.basicEncoding)) <= -1 && !startEvaluator.matchWhenNotFound()) {
                return false;
            }
            if (position > -1 && startEvaluator.matchWhenNotFound()) {
                return false;
            }
            int currentEvaluatorIndex = evaluatorIndex + 1;
            boolean continueEvaluatingRelativeRules = true;
            int priorFinding = position;
            while (continueEvaluatingRelativeRules) {
                if (currentEvaluatorIndex >= this.evaluators.size()) {
                    return true;
                }
                Evaluator nextEvaluator = this.evaluators.get(currentEvaluatorIndex);
                if (!nextEvaluator.isRelative()) {
                    return true;
                }
                if (!this.basicEncoding && nextEvaluator.getReturnType() != returnType) {
                    throw new InvalidDefinitionException("This signature contains mixed byte-mode and character-mode rules");
                }
                if ((priorFinding = nextEvaluator.evaluate(input, priorFinding)) <= -1 && !nextEvaluator.matchWhenNotFound()) {
                    continueEvaluatingRelativeRules = false;
                } else if (priorFinding > -1 && nextEvaluator.matchWhenNotFound()) {
                    continueEvaluatingRelativeRules = false;
                }
                ++currentEvaluatorIndex;
            }
            ++position;
        }
        return false;
    }

    public boolean evaluate(DataSpecimen input, Variables variables) throws InvalidDefinitionException {
        String uri;
        Matcher matcher;
        String mimeType;
        int c;
        if (input == null) {
            throw new IllegalArgumentException("The data specimen must not be null");
        }
        boolean variableSet = false;
        if (this.mustBeSet.size() == 0) {
            variableSet = true;
        } else {
            c = 0;
            while (c < this.mustBeSet.size()) {
                if (variables.isSet(this.mustBeSet.get(c))) {
                    variableSet = true;
                }
                ++c;
            }
        }
        if (!variableSet) {
            return false;
        }
        if (this.mustNotBeSet.size() != 0) {
            c = 0;
            while (c < this.mustNotBeSet.size()) {
                if (variables.isSet(this.mustNotBeSet.get(c))) {
                    return false;
                }
                ++c;
            }
        }
        if (this.contentTypeRegex != null && (mimeType = input.getContentType()) != null && !(matcher = this.contentTypeRegex.matcher(mimeType)).matches()) {
            return false;
        }
        if (this.uriRegex != null && (uri = input.getFilename()) != null && !(matcher = this.uriRegex.matcher(uri)).matches()) {
            return false;
        }
        int c2 = 0;
        while (c2 < this.evaluators.size()) {
            if (!(c2 != 0 && this.evaluators.get(c2).isRelative() || this.evaluateFromPosition(c2, input))) {
                return false;
            }
            ++c2;
        }
        if (this.evaluators.size() == 0) {
            if (this.contentTypeRegex != null && this.uriRegex != null && (input.getContentType() == null || input.getFilename() == null)) {
                return false;
            }
            if (this.contentTypeRegex != null && input.getContentType() == null) {
                return false;
            }
            if (this.uriRegex != null && input.getFilename() == null) {
                return false;
            }
        }
        c2 = 0;
        while (c2 < this.unSet.size()) {
            variables.unSet(this.unSet.get(c2));
            ++c2;
        }
        c2 = 0;
        while (c2 < this.set.size()) {
            variables.set(this.set.get(c2));
            ++c2;
        }
        c2 = 0;
        while (c2 < this.toggleSet.size()) {
            if (variables.isSet(this.toggleSet.get(c2))) {
                variables.unSet(this.toggleSet.get(c2));
            } else {
                variables.set(this.toggleSet.get(c2));
            }
            ++c2;
        }
        return true;
    }

    private static class Offset {
        private static final Pattern OFFSET_REGEX = Pattern.compile("[ ]*([0-9]+)[ ]*(\\([ ]*((relative)|(absolute))[ ]*\\))?[ ]*");
        private int offset;
        private Evaluator.OffsetRelativity offsetType = Evaluator.OffsetRelativity.UNDEFINED;

        public Offset(String value) throws InvalidDefinitionException {
            this.parse(value);
        }

        private void parse(String value) throws InvalidDefinitionException {
            Matcher matcher = OFFSET_REGEX.matcher(value);
            if (matcher.matches()) {
                String num = matcher.group(1);
                String type = matcher.group(3);
                try {
                    this.offset = Integer.parseInt(num);
                }
                catch (NumberFormatException e) {
                    throw new InvalidDefinitionException("The offset value provided is not a valid number: " + num);
                }
                if (type != null && "relative".equalsIgnoreCase(type)) {
                    this.offsetType = Evaluator.OffsetRelativity.RELATIVE;
                } else if (type != null && "absolute".equalsIgnoreCase(type)) {
                    this.offsetType = Evaluator.OffsetRelativity.ABSOLUTE;
                }
            } else {
                throw new InvalidDefinitionException("The offset option provided is not valid: " + value);
            }
        }

        public int getValue() {
            return this.offset;
        }

        public Evaluator.OffsetRelativity getOffsetType() {
            return this.offsetType;
        }
    }
}

