/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Pcre {
    private static final Pattern PCRE = Pattern.compile("/(.*)/([a-zA-Z]*)");

    private Pcre() {
    }

    public static Pattern parse(String pcre) {
        return Pcre.parse(pcre, false);
    }

    public static Pattern parse(String pcre, boolean canonEquality) {
        if (pcre == null) {
            throw new IllegalArgumentException("The PCRE must not be null");
        }
        if (pcre.length() == 0) {
            throw new IllegalArgumentException("The PCRE must not be empty");
        }
        Matcher matcher = PCRE.matcher(pcre);
        if (!matcher.find() || matcher.groupCount() < 2) {
            throw new IllegalArgumentException("The PCRE does not appear to be valid");
        }
        String options = matcher.group(2);
        String regex = matcher.group(1);
        int flags = 0;
        if (options.contains("i")) {
            flags |= 2;
        }
        if (options.contains("s")) {
            flags |= 0x20;
        }
        if (options.contains("m")) {
            flags |= 8;
        }
        if (options.contains("x")) {
            flags |= 4;
        }
        if (canonEquality) {
            flags |= 0x80;
        }
        return Pattern.compile(regex, flags);
    }
}

