/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.scan.DataSpecimen;
import net.lukemurphey.nsia.scan.Evaluator;
import net.lukemurphey.nsia.scan.InvalidEvaluatorException;
import net.lukemurphey.nsia.scan.Pcre;

public class RegexEvaluator
extends Evaluator {
    Pattern pattern;

    public RegexEvaluator(String pcre) throws InvalidEvaluatorException {
        this(pcre, true);
    }

    public RegexEvaluator(String pcre, boolean canonEquality) throws InvalidEvaluatorException {
        try {
            this.pattern = Pcre.parse(pcre, canonEquality);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidEvaluatorException(e.getMessage(), e);
        }
    }

    @Override
    public int evaluate(DataSpecimen content) {
        return this.evaluate(content, -1);
    }

    @Override
    public int evaluate(DataSpecimen content, int lastMatch, boolean useBasicEncoding) {
        String contentAsString = useBasicEncoding ? content.getBasicEncodedString() : content.getString();
        Matcher matcher = this.pattern.matcher(contentAsString);
        int startLocation = this.computeStartLocation(lastMatch);
        matcher = this.depth != -1 ? matcher.region(startLocation, Math.min(contentAsString.length(), this.depth + startLocation)) : matcher.region(startLocation, contentAsString.length());
        if (matcher.find()) {
            if (this.within != -1 && matcher.start() - startLocation > this.within) {
                return -1;
            }
            return matcher.end() - 1;
        }
        return -1;
    }

    @Override
    public Evaluator.ReturnType getReturnType() {
        return Evaluator.ReturnType.CHARACTER_LOCATION;
    }
}

