/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.HashtableSerialization;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.ScanCallback;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.scan.ScanException;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;

public abstract class ScanRule
implements HashtableSerialization {
    protected Application appRes = null;
    protected long scanRuleId = -1L;
    protected boolean scanDataObsolete;
    protected int scanFrequency;
    public static final String RULE_TYPE = "";
    protected ScanCallback callback = null;
    protected Timestamp created;
    protected Timestamp modified;
    protected long objectId;
    public static final int RULE_STATE_ACTIVE = 1;
    public static final int RULE_STATE_INACTIVE = 2;

    ScanRule(Application applicationResources) {
        this.appRes = applicationResources;
    }

    public abstract ScanResult doScan() throws ScanException;

    public void setCallback(ScanCallback callback) {
        this.callback = callback;
    }

    protected ScanCallback getScanCallback() {
        return this.callback;
    }

    protected void logScanComplete(ScanResultCode resultCode, int deviations, String ruleType, String specimen, boolean sendToEventLog, boolean increaseScanCounts) {
        if (this.callback != null) {
            this.callback.logScanResult(resultCode, deviations, ruleType, specimen, null, this.scanRuleId, sendToEventLog, increaseScanCounts, true);
        }
    }

    protected void logScanResult(ScanResultCode resultCode, int deviations, String ruleType, String specimen, boolean sendToEventLog, boolean increaseScanCounts) {
        if (this.callback != null) {
            this.callback.logScanResult(resultCode, deviations, ruleType, specimen, null, this.scanRuleId, sendToEventLog, increaseScanCounts);
        }
    }

    protected void logScanResult(ScanResultCode resultCode, int deviations, String ruleType, String specimen, boolean sendToEventLog) {
        if (this.callback != null) {
            this.callback.logScanResult(resultCode, deviations, ruleType, specimen, null, this.scanRuleId, sendToEventLog);
        }
    }

    protected void logScanResult(ScanResultCode resultCode, int deviations, String ruleType, String specimen, String message, boolean sendToEventLog) {
        if (this.callback != null) {
            this.callback.logScanResult(resultCode, deviations, ruleType, specimen, message, this.scanRuleId, sendToEventLog);
        }
    }

    protected void logScanResult(ScanResultCode resultCode, int deviations, String ruleType, String specimen, String message, boolean sendToEventLog, boolean noteScanCompleted) {
        if (this.callback != null) {
            this.callback.logScanResult(resultCode, deviations, ruleType, specimen, message, this.scanRuleId, sendToEventLog, noteScanCompleted);
        }
    }

    protected void logScanResult(ScanResultCode resultCode, int deviations, String ruleType, String specimen) {
        if (this.callback != null) {
            this.callback.logScanResult(resultCode, deviations, ruleType, specimen, null, this.scanRuleId);
        }
    }

    protected void logScanResult(ScanResultCode resultCode, int deviations, String ruleType, String specimen, String message) {
        if (this.callback != null) {
            this.callback.logScanResult(resultCode, deviations, ruleType, specimen, message, this.scanRuleId);
        }
    }

    public abstract boolean loadFromDatabase(long var1) throws NotFoundException, NoDatabaseConnectionException, SQLException, ScanRuleLoadFailureException;

    public abstract ScanResult loadScanResult(long var1) throws NotFoundException, NoDatabaseConnectionException, SQLException, ScanResultLoadFailureException;

    public long getRuleId() {
        return this.scanRuleId;
    }

    public void setScanFrequency(int scanFrequency) {
        if (scanFrequency < 15) {
            throw new IllegalArgumentException("The scan frequency cannot be less than 15 seconds");
        }
        this.scanFrequency = scanFrequency;
    }

    public int getScanFrequency() {
        return this.scanFrequency;
    }

    @Override
    public Hashtable<String, Object> toHashtable() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("RuleID", this.scanRuleId);
        hashtable.put("RuleType", RULE_TYPE);
        hashtable.put("RuleType", this.getRuleType());
        return hashtable;
    }

    public boolean isScanDataObsolete() {
        return this.scanDataObsolete;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public boolean isRuleIdSet() {
        return this.scanRuleId != -1L;
    }

    public static int getSiteGroupForRule(long ruleID) throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Select SiteGroupID from ScanRule where ScanRuleID = ?");
            statement.setLong(1, ruleID);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt("SiteGroupID");
                return n;
            }
            return -1;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public static boolean deleteRule(long scanRuleId) throws SQLException, NoDatabaseConnectionException {
        Application appRes = Application.getApplication();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Delete from ScanRule where ScanRuleID = ?");
            statement.setLong(1, scanRuleId);
            return statement.executeUpdate() >= 1;
            {
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public static boolean setScanDataObsolete(long ruleId) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        SQLException initCause = null;
        try {
            connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Update ScanRule set ScanDataObsolete = 1 where ScanRuleID = ?");
            statement.setLong(1, ruleId);
            return statement.executeUpdate() >= 1;
            {
            }
        }
        catch (SQLException e) {
            initCause = e;
            throw e;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                if (e.getCause() == null) {
                    e.initCause(initCause);
                    throw e;
                }
                if (initCause != null) {
                    throw initCause;
                }
                throw e;
            }
        }
    }

    public static SiteGroupManagement.SiteGroupDescriptor getAssociatedSiteGroup(long ruleId) throws SQLException, NoDatabaseConnectionException, NotFoundException, InputValidationException {
        int siteGroupID = ScanRule.getAssociatedSiteGroupID(ruleId);
        SiteGroupManagement siteGroupMgmt = new SiteGroupManagement(Application.getApplication());
        return siteGroupMgmt.getGroupDescriptor(siteGroupID);
    }

    public static int getAssociatedSiteGroupID(long ruleId) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        Application appRes = Application.getApplication();
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            connection = appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Select * from ScanRule where ScanRuleID = ?");
            statement.setLong(1, ruleId);
            result = statement.executeQuery();
            if (result.next()) {
                int n = result.getInt("SiteGroupID");
                return n;
            }
            throw new NotFoundException("No rule could be found with the given rule identifier");
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public abstract String getRuleType();

    public abstract String getSpecimenDescription();

    public abstract void delete() throws SQLException, NoDatabaseConnectionException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized long createRule(long siteGroupId, long scanFrequency, String ruletype, int ruleState) throws SQLException, NoDatabaseConnectionException {
        Application appRes = Application.getApplication();
        Connection connection = null;
        Statement statement = null;
        ResultSet results = null;
        try {
            connection = appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            statement = connection.prepareStatement("Insert into ScanRule (SiteGroupID, ScanFrequency, RuleType, State, Created, Modified) values (?, ?, ?, ?, ?, ?)", 1);
            statement.setLong(1, siteGroupId);
            statement.setLong(2, scanFrequency);
            statement.setString(3, ruletype);
            statement.setInt(4, ruleState);
            this.created = new Timestamp(new Date().getTime());
            statement.setTimestamp(5, this.created);
            statement.setTimestamp(6, this.created);
            if (statement.executeUpdate() < 1) {
                return -1L;
            }
            results = statement.getGeneratedKeys();
            if (!results.next()) return -1L;
            long l = results.getLong(1);
            return l;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (results != null) {
                results.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public static class ScanFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Exception innerException = null;

        public ScanFailureException(String message, Exception innerException) {
            super(message);
            this.innerException = innerException;
        }

        public Exception getInnerException() {
            return this.innerException;
        }
    }

    public static class ScanResultLoadFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Exception innerException = null;

        public ScanResultLoadFailureException(String message, Exception innerException) {
            super(message);
            this.innerException = innerException;
        }

        public ScanResultLoadFailureException(String message) {
            super(message);
        }

        public Exception getInnerException() {
            return this.innerException;
        }
    }

    public static class ScanRuleLoadFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Exception innerException = null;

        public ScanRuleLoadFailureException(String message, Exception innerException) {
            super(message);
            this.innerException = innerException;
        }

        public Exception getInnerException() {
            return this.innerException;
        }
    }
}

