/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionErrorList;
import net.lukemurphey.nsia.scan.DefinitionEvaluationException;
import net.lukemurphey.nsia.scan.Environment;
import net.lukemurphey.nsia.scan.HttpResponseData;
import net.lukemurphey.nsia.scan.InvalidDefinitionException;
import net.lukemurphey.nsia.scan.InvokerThread;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScriptClassLoader;
import net.lukemurphey.nsia.scan.TerminatorThread;
import net.lukemurphey.nsia.scan.scriptenvironment.Debug;
import net.lukemurphey.nsia.scan.scriptenvironment.Result;
import net.lukemurphey.nsia.scan.scriptenvironment.StringUtils;
import net.lukemurphey.nsia.scan.scriptenvironment.Variables;
import sun.org.mozilla.javascript.internal.Context;

public class ScriptDefinition
extends Definition {
    private static final int MAX_SCRIPT_RUNTIME = 10000;
    private static final int MAX_SCRIPT_TERMINATE_RUNTIME = 10000;
    private String script;
    private String scriptingEngine;
    private boolean isInvasive = false;
    public static final String DEFAULT_ENGINE = "ECMAScript";
    private static final Pattern COMMENTS_REGEX = Pattern.compile("(/\\*.*?\\*/)|(//.*$)", 40);
    private static final Pattern OPTION_REGEX = Pattern.compile("(Version|Name|ID|Message|Reference|Severity|Invasive)[ ]*\\:[ ]*([-\\'\\w.\"/\\\\ (),?%=]+)", 10);
    private Object mutex = new Object();
    private Object terminatorMutex = new Object();

    public static ScriptDefinition parse(String script) throws InvalidDefinitionException {
        return new ScriptDefinition(script);
    }

    public static ScriptDefinition parse(String script, String scriptingEngine) throws InvalidDefinitionException {
        return new ScriptDefinition(script, scriptingEngine);
    }

    public static ScriptDefinition parse(String script, int localID) throws InvalidDefinitionException {
        return new ScriptDefinition(script, localID);
    }

    public static ScriptDefinition parse(String script, String scriptingEngine, int localID) throws InvalidDefinitionException {
        return new ScriptDefinition(script, scriptingEngine, localID);
    }

    private ScriptDefinition(String script) throws InvalidDefinitionException {
        this(script, null);
    }

    private ScriptDefinition(String script, int localID) throws InvalidDefinitionException {
        this(script, null, localID);
    }

    private ScriptDefinition(String script, String scriptingEngine) throws InvalidDefinitionException {
        this(script, null, -1);
    }

    private ScriptDefinition(String script, String scriptingEngine, int localID) throws InvalidDefinitionException {
        if (script == null) {
            throw new IllegalArgumentException("The script must not be null");
        }
        this.definitionType = "ThreatScript";
        this.script = script;
        this.scriptingEngine = scriptingEngine;
        this.getScriptEngine();
        this.id = -1;
        this.populateDetailsFromComments(script);
        this.localId = localID;
    }

    private String stripLeadingQuotes(String value) {
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    private ScriptEngine getScriptEngine() throws InvalidDefinitionException {
        ScriptEngineManager sem = new ScriptEngineManager();
        ScriptEngine scriptEngine = null;
        Context context = Context.enter();
        context.setApplicationClassLoader((ClassLoader)new ScriptClassLoader());
        scriptEngine = this.scriptingEngine == null ? sem.getEngineByName(DEFAULT_ENGINE) : sem.getEngineByName(this.scriptingEngine);
        Context.exit();
        try {
            scriptEngine.eval(this.script);
        }
        catch (ScriptException e) {
            throw new InvalidDefinitionException("The definition script does not appear to be valid (the scripting engine rejected it)", e);
        }
        return scriptEngine;
    }

    private void populateDetailsFromComments(String script) throws InvalidDefinitionException {
        String completeName = null;
        String version = null;
        String identifier = null;
        String message = null;
        Matcher commentMatcher = COMMENTS_REGEX.matcher(script);
        while (commentMatcher.find()) {
            Matcher optionsMatcher = OPTION_REGEX.matcher(commentMatcher.group(0));
            while (optionsMatcher.find()) {
                String name = optionsMatcher.group(1);
                String value = optionsMatcher.group(2);
                if (name.equalsIgnoreCase("Version")) {
                    version = this.stripLeadingQuotes(value);
                    continue;
                }
                if (name.equalsIgnoreCase("Name")) {
                    completeName = this.stripLeadingQuotes(value);
                    continue;
                }
                if (name.equalsIgnoreCase("ID")) {
                    identifier = this.stripLeadingQuotes(value);
                    continue;
                }
                if (name.equalsIgnoreCase("Message")) {
                    message = this.stripLeadingQuotes(value);
                    continue;
                }
                if (name.equalsIgnoreCase("Reference")) {
                    Definition.Reference reference = Definition.Reference.parse(this.stripLeadingQuotes(value));
                    this.references.add(reference);
                    continue;
                }
                if (name.equalsIgnoreCase("Invasive")) {
                    String tmpValue = this.stripLeadingQuotes(value);
                    if (tmpValue.equalsIgnoreCase("true")) {
                        this.isInvasive = true;
                        continue;
                    }
                    if (tmpValue.equalsIgnoreCase("false")) {
                        this.isInvasive = false;
                        continue;
                    }
                    throw new InvalidDefinitionException("The invasive flag is invalid (must be either \"true\" or \"false\")");
                }
                if (!name.equalsIgnoreCase("Severity")) continue;
                String severity = this.stripLeadingQuotes(value);
                if (severity.equalsIgnoreCase("Low")) {
                    this.severity = Definition.Severity.LOW;
                    continue;
                }
                if (severity.equalsIgnoreCase("Medium") || severity.equalsIgnoreCase("Med")) {
                    this.severity = Definition.Severity.MEDIUM;
                    continue;
                }
                if (severity.equalsIgnoreCase("High")) {
                    this.severity = Definition.Severity.HIGH;
                    continue;
                }
                throw new InvalidDefinitionException("The severity is invalid");
            }
        }
        if (completeName == null) {
            throw new InvalidDefinitionException("The script must provide a name. The name must be provided in a comment; example: \"//Name = Exploit.Suspicious.StealthJavaScript\"");
        }
        this.parseFullName(completeName);
        if (version == null) {
            throw new InvalidDefinitionException("The script must provide a version. The version must be provided in a comment; example: \"//Version = 1\"");
        }
        try {
            this.revision = Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            throw new InvalidDefinitionException("The version number is not a valid number");
        }
        if (identifier != null) {
            try {
                this.id = Integer.parseInt(identifier);
            }
            catch (NumberFormatException e) {
                throw new InvalidDefinitionException("The ID number is not a valid number");
            }
            if (this.id < 1) {
                throw new InvalidDefinitionException("The value for the ID must be greater than zero");
            }
        }
        if (message == null) {
            throw new InvalidDefinitionException("The script must provide a default message. The message must be provided in a comment; example: \"//Message = Obfuscated JavaScript Detected\"");
        }
        this.message = message;
        if (this.severity == null || this.severity == Definition.Severity.UNDEFINED) {
            throw new InvalidDefinitionException("The script must provide severity level; example: \"//Severity = Medium\"");
        }
        this.message = message;
    }

    public String getScript() {
        return this.script;
    }

    public boolean baseline(ScanResult scanResult) throws SQLException, InvalidDefinitionException, DefinitionEvaluationException {
        if (scanResult == null) {
            throw new IllegalArgumentException("The scan result cannot be null");
        }
        return this.baseline(scanResult.getRuleID(), scanResult.getScanResultID(), scanResult.getSpecimenDescription());
    }

    public boolean isInvasive() {
        return this.isInvasive;
    }

    private SavedScriptData getSavedScriptData(Connection connection, long scanRuleID, String uniqueResourceName) throws SQLException {
        SavedScriptData data = null;
        try {
            data = SavedScriptData.load(connection, scanRuleID, this.toString(), uniqueResourceName);
        }
        catch (IOException e) {
            EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.SCAN_ENGINE_EXCEPTION);
            message.addField(new EventLogField(EventLogField.FieldName.DEFINITION_NAME, this.name));
            if (this.id >= 0) {
                message.addField(new EventLogField(EventLogField.FieldName.DEFINITION_ID, this.id));
            }
            Application.getApplication().logExceptionEvent(message, (Throwable)e);
            return new SavedScriptData(scanRuleID, this.name);
        }
        catch (ClassNotFoundException e) {
            EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.SCAN_ENGINE_EXCEPTION);
            message.addField(new EventLogField(EventLogField.FieldName.DEFINITION_NAME, this.name));
            if (this.id >= 0) {
                message.addField(new EventLogField(EventLogField.FieldName.DEFINITION_ID, this.id));
            }
            Application.getApplication().logExceptionEvent(message, (Throwable)e);
            return new SavedScriptData(scanRuleID, this.name);
        }
        return data;
    }

    /*
     * Exception decompiling
     */
    private boolean baseline(long scanRuleID, long scanResultID, String uniqueResourceName) throws DefinitionEvaluationException, InvalidDefinitionException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void populateBindings(ScriptEngine scriptEngine) {
        this.populateBindings(scriptEngine, null);
    }

    private void populateBindings(ScriptEngine scriptEngine, Date scanStartTime) {
        scriptEngine.put("StringUtils", new StringUtils());
        scriptEngine.put("Debug", new Debug(this));
        scriptEngine.put("scriptStarted", new Date());
        if (scanStartTime != null) {
            scriptEngine.put("scanStarted", scanStartTime);
        }
    }

    public Result evaluate(HttpResponseData httpResponse, Variables variables, long ruleId, Date scanStartTime) throws DefinitionEvaluationException, SQLException {
        Connection connection = null;
        try {
            connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
            Result result = this.evaluate(httpResponse, variables, ruleId, connection, scanStartTime);
            return result;
        }
        catch (NoDatabaseConnectionException e) {
            throw new DefinitionEvaluationException("Database connection could not be established", e);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TerminateResult terminate(Invocable invocable, int maxRuntime, long ruleID) {
        TerminatorThread terminatorThread = new TerminatorThread(invocable, this.terminatorMutex);
        terminatorThread.setName("ScriptDefinition " + this.getFullName() + " (terminate call)");
        Object object = this.terminatorMutex;
        synchronized (object) {
            block13: {
                try {
                    try {
                        terminatorThread.start();
                        this.terminatorMutex.wait(maxRuntime);
                    }
                    catch (InterruptedException interruptedException) {
                        if (terminatorThread.isRunning()) {
                            terminatorThread.stop();
                            return TerminateResult.TERMINATE_UNSUCCESSFUL;
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (terminatorThread.isRunning()) {
                        terminatorThread.stop();
                        return TerminateResult.TERMINATE_UNSUCCESSFUL;
                    }
                    throw throwable;
                }
                if (terminatorThread.isRunning()) {
                    terminatorThread.stop();
                    return TerminateResult.TERMINATE_UNSUCCESSFUL;
                }
            }
        }
        if (terminatorThread.getThrowable() != null) {
            DefinitionErrorList.logError(this.getFullName(), this.revision, "Runtime exception", "Rule ID " + ruleID, this.id, this.localId);
        }
        if (terminatorThread.declaresTerminate()) {
            return TerminateResult.TERMINATED_SUCCESSFULLY;
        }
        return TerminateResult.NO_TERMINATE_DECLARED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result performAnalysis(int maxRuntime, Invocable invocable, HttpResponseData httpResponse, Variables variables, Environment env, long ruleId) throws DefinitionEvaluationException {
        Result result = null;
        if (maxRuntime <= 0) {
            try {
                result = (Result)invocable.invokeFunction("analyze", httpResponse, variables, env);
            }
            catch (ScriptException e) {
                DefinitionErrorList.logError(this.getFullName(), this.revision, "Runtime exception", "Rule ID " + ruleId, this.id, this.localId);
                throw new DefinitionEvaluationException("The definition threw an exception (ID " + ruleId + ", definition \"" + this.getFullName() + "\")", e);
            }
            catch (NoSuchMethodException e) {
                DefinitionErrorList.logError(this.getFullName(), this.revision, "Missing method", "Rule ID " + ruleId, this.id, this.localId);
                throw new DefinitionEvaluationException("The definition threw an exception (ID " + ruleId + ", definition \"" + this.getFullName() + "\")", e);
            }
        }
        InvokerThread thread = new InvokerThread(invocable, httpResponse, variables, env, this.mutex);
        thread.setName("ScriptDefinition " + this.getFullName());
        Object object = this.mutex;
        synchronized (object) {
            try {
                thread.start();
                this.mutex.wait(maxRuntime);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (thread.isRunning()) {
            TerminateResult terminateResult = this.terminate(invocable, 10000, ruleId);
            if (terminateResult == TerminateResult.TERMINATED_SUCCESSFULLY) {
                DefinitionErrorList.logError(this.getFullName(), this.revision, "Execution exceeded limit (but was terminated successfully using terminate call)", "Rule ID " + ruleId, this.id, this.localId);
            } else if (terminateResult == TerminateResult.TERMINATE_UNSUCCESSFUL) {
                DefinitionErrorList.logError(this.getFullName(), this.revision, "Execution exceeded limit and terminate request timed out", "Rule ID " + ruleId, this.id, this.localId);
            }
        }
        if (thread.isRunning()) {
            thread.stop();
            DefinitionErrorList.logError(this.getFullName(), this.revision, "Execution exceeded limit", "Rule ID " + ruleId, this.id, this.localId);
            throw new DefinitionEvaluationException("The definition exceeded the maximum timeout (ID " + ruleId + ", definition \"" + this.getFullName() + "\")");
        }
        if (thread.getThrowable() != null) {
            DefinitionErrorList.logError(this.getFullName(), this.revision, "Runtime exception", "Rule ID " + ruleId, this.id, this.localId);
            throw new DefinitionEvaluationException("The definition threw an exception (ID " + ruleId + ", definition \"" + this.getFullName() + "\")", thread.getThrowable());
        }
        result = thread.getResult();
        return result;
    }

    public Result evaluate(HttpResponseData httpResponse, Variables variables, long ruleId, Connection connection) throws DefinitionEvaluationException {
        return this.evaluate(httpResponse, variables, ruleId, connection, null);
    }

    public Result evaluate(HttpResponseData httpResponse, Variables variables, long ruleId, Connection connection, Date scanStartTime) throws DefinitionEvaluationException {
        ScriptEngine scriptEngine;
        SavedScriptData data;
        if (httpResponse == null) {
            throw new IllegalArgumentException("The HTTP response argument must not be null");
        }
        try {
            data = this.getSavedScriptData(connection, ruleId, httpResponse.getDataSpecimen().getFilename());
        }
        catch (SQLException e) {
            DefinitionErrorList.logError(this.getFullName(), this.revision, "Serialized data could not be loaded", "Rule ID " + ruleId, this.id, this.localId);
            throw new DefinitionEvaluationException("The serialized data could not be loaded from the database for the definition (rule ID " + ruleId + ", definition \"" + this.getFullName() + "\")", e);
        }
        try {
            scriptEngine = this.getScriptEngine();
        }
        catch (InvalidDefinitionException e) {
            throw new DefinitionEvaluationException("Definition is invalid", e);
        }
        Environment env = new Environment(data);
        this.populateBindings(scriptEngine, scanStartTime);
        Invocable invocable = (Invocable)((Object)scriptEngine);
        Result result = this.performAnalysis(10000, invocable, httpResponse, variables, env, ruleId);
        if (data != null) {
            try {
                data.save(connection, httpResponse.getDataSpecimen().getFilename());
            }
            catch (SQLException e) {
                DefinitionErrorList.logError(this.getFullName(), this.revision, "Database error prevented serialization", "Rule ID " + ruleId, this.id, this.localId);
                throw new DefinitionEvaluationException("The definition threw an exception while being serialized to the database (" + ruleId + ", definition \"" + this.getFullName() + "\")", e);
            }
            catch (IOException e) {
                DefinitionErrorList.logError(this.getFullName(), this.revision, "IO error prevented serialization", "Rule ID " + ruleId, this.id, this.localId);
                throw new DefinitionEvaluationException("The definition threw an exception while being serialized to the database (" + ruleId + ", definition \"" + this.getFullName() + "\")", e);
            }
        }
        if (result == null) {
            return new Result(false);
        }
        return result;
    }

    protected static class NameValuePair {
        private int pairId = -1;
        private String name;
        private Object value;
        private boolean isSpecimenSpecific = true;

        public NameValuePair(String name, Object value, boolean isSpecimenSpecific) {
            if (name == null) {
                throw new IllegalArgumentException("The name must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("The value must not be null");
            }
            this.name = name;
            this.value = value;
            this.isSpecimenSpecific = isSpecimenSpecific;
        }

        public NameValuePair(String name, Object value) {
            this(name, value, true);
        }

        public NameValuePair(int pairId, String name, Object value) {
            this(pairId, name, value, true);
        }

        public NameValuePair(int pairId, String name, Object value, boolean isSpecimenSpecific) {
            if (pairId < 0) {
                throw new IllegalArgumentException("The pair ID must be greater than zero");
            }
            if (name == null) {
                throw new IllegalArgumentException("The name must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("The value must not be null");
            }
            this.name = name;
            this.value = value;
            this.pairId = pairId;
            this.isSpecimenSpecific = isSpecimenSpecific;
        }

        public boolean nameMatches(String name) {
            return this.name.equalsIgnoreCase(name);
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isSpecimenSpecific() {
            return this.isSpecimenSpecific;
        }

        public boolean isPairIDSet() {
            return this.pairId >= 0;
        }

        public int getPairID() {
            return this.pairId;
        }
    }

    public static enum Operation {
        SCAN,
        BASELINE;

    }

    protected static class SavedScriptData {
        private long ruleId;
        private String definitionName;
        private Vector<NameValuePair> pairs = new Vector();
        private boolean itemsChanged = false;

        public SavedScriptData(long ruleId, String definitionName) {
            this.ruleId = ruleId;
            this.definitionName = definitionName;
        }

        public static SavedScriptData load(Connection connection, long ruleId, String definitionName, String uniqueResourceName) throws SQLException, IOException, ClassNotFoundException {
            PreparedStatement statement = null;
            ResultSet results = null;
            SavedScriptData env = new SavedScriptData(ruleId, definitionName);
            try {
                if (uniqueResourceName == null) {
                    statement = connection.prepareStatement("Select * from ScriptEnvironment where DefinitionName = ? and RuleID = ?");
                    statement.setString(1, definitionName);
                    statement.setLong(2, ruleId);
                } else {
                    statement = connection.prepareStatement("Select * from ScriptEnvironment where DefinitionName = ? and RuleID = ? and (UniqueResourceName = ? or UniqueResourceName is null)");
                    statement.setString(1, definitionName);
                    statement.setLong(2, ruleId);
                    statement.setString(3, uniqueResourceName);
                }
                results = statement.executeQuery();
                while (results.next()) {
                    byte[] bytes = results.getBytes("Value");
                    ByteArrayInputStream byteInStream = new ByteArrayInputStream(bytes);
                    ObjectInputStream inStream = new ObjectInputStream(byteInStream);
                    NameValuePair pair = new NameValuePair(results.getString("Name"), inStream.readObject());
                    env.pairs.add(pair);
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (results != null) {
                    results.close();
                }
            }
            return env;
        }

        public long getRuleID() {
            return this.ruleId;
        }

        public String getDefinitionName() {
            return this.definitionName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NameValuePair get(String name) {
            Vector<NameValuePair> vector = this.pairs;
            synchronized (vector) {
                for (NameValuePair pair : this.pairs) {
                    if (!pair.nameMatches(name)) continue;
                    return pair;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(int location) {
            Vector<NameValuePair> vector = this.pairs;
            synchronized (vector) {
                this.itemsChanged = true;
                this.pairs.remove(location);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(String name) {
            Vector<NameValuePair> vector = this.pairs;
            synchronized (vector) {
                this.removeInternal(name);
            }
        }

        private void removeInternal(String name) {
            Iterator<NameValuePair> iterator = this.pairs.iterator();
            while (iterator.hasNext()) {
                NameValuePair pair = iterator.next();
                if (!pair.nameMatches(name)) continue;
                iterator.remove();
                this.itemsChanged = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll() {
            Vector<NameValuePair> vector = this.pairs;
            synchronized (vector) {
                this.itemsChanged = true;
                this.pairs.clear();
            }
        }

        public void set(String name, Serializable value) {
            this.set(name, value, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String name, Serializable value, boolean isSpecimenSpecific) {
            Vector<NameValuePair> vector = this.pairs;
            synchronized (vector) {
                this.removeInternal(name);
                this.pairs.add(new NameValuePair(name, value, isSpecimenSpecific));
                this.itemsChanged = true;
            }
        }

        public void set(String name, Externalizable value) {
            this.set(name, value, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String name, Externalizable value, boolean isSpecimenSpecific) {
            Vector<NameValuePair> vector = this.pairs;
            synchronized (vector) {
                this.itemsChanged = true;
                this.pairs.add(new NameValuePair(name, value, isSpecimenSpecific));
            }
        }

        public synchronized void save(Connection connection, String uniqueResourceName) throws SQLException, IOException {
            if (this.itemsChanged) {
                SavedScriptData.invalidateOldItems(connection, this.ruleId, this.definitionName, uniqueResourceName);
                int c = 0;
                while (c < this.pairs.size()) {
                    SavedScriptData.saveItem(this.pairs.get(c), connection, this.ruleId, this.definitionName, uniqueResourceName);
                    ++c;
                }
            }
        }

        private static void invalidateOldItems(Connection connection, long ruleId, String definitionName, String uniqueResourceName) throws SQLException {
            PreparedStatement statement = null;
            try {
                if (uniqueResourceName == null) {
                    statement = connection.prepareStatement("Delete from ScriptEnvironment where DefinitionName = ? and RuleID = ? and UniqueResourceName is null");
                    statement.setString(1, definitionName);
                    statement.setLong(2, ruleId);
                } else {
                    statement = connection.prepareStatement("Delete from ScriptEnvironment where DefinitionName = ? and RuleID = ? and (UniqueResourceName = ? or UniqueResourceName is null)");
                    statement.setString(1, definitionName);
                    statement.setLong(2, ruleId);
                    statement.setString(3, uniqueResourceName);
                }
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }

        private static void saveItem(NameValuePair pair, Connection connection, long ruleId, String definitionName, String uniqueResourceName) throws SQLException, IOException {
            if (pair == null) {
                return;
            }
            ByteArrayOutputStream byteOutStream = null;
            ObjectOutputStream outStream = null;
            PreparedStatement insertStatement = null;
            try {
                if (uniqueResourceName != null && pair.isSpecimenSpecific) {
                    insertStatement = connection.prepareStatement("Insert into ScriptEnvironment (DefinitionName, RuleID, Name, Value, UniqueResourceName) values(?, ?, ?, ?, ?)");
                    insertStatement.setString(1, definitionName);
                    insertStatement.setLong(2, ruleId);
                    insertStatement.setString(3, pair.getName());
                    insertStatement.setString(5, uniqueResourceName);
                } else {
                    insertStatement = connection.prepareStatement("Insert into ScriptEnvironment (DefinitionName, RuleID, Name, Value) values(?, ?, ?, ?)");
                    insertStatement.setString(1, definitionName);
                    insertStatement.setLong(2, ruleId);
                    insertStatement.setString(3, pair.getName());
                }
                byteOutStream = new ByteArrayOutputStream();
                outStream = new ObjectOutputStream(byteOutStream);
                if (pair.getValue() instanceof Serializable) {
                    outStream.writeObject(pair.getValue());
                } else if (pair.getValue() instanceof Externalizable) {
                    ((Externalizable)pair.getValue()).writeExternal(outStream);
                } else {
                    EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.DEFINITION_ERROR);
                    message.addField(new EventLogField(EventLogField.FieldName.DEFINITION_NAME, definitionName));
                    message.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "The field named \"" + pair.getName() + "\" could not be saved to the database because it is neither Serializable or Externalizable"));
                    message.addField(new EventLogField(EventLogField.FieldName.VALUE, pair.getName()));
                    Application.getApplication().logEvent(message);
                }
                byte[] bytes = byteOutStream.toByteArray();
                insertStatement.setBytes(4, bytes);
                insertStatement.execute();
            }
            finally {
                if (insertStatement != null) {
                    insertStatement.close();
                }
            }
        }
    }

    private static enum TerminateResult {
        NO_TERMINATE_DECLARED,
        TERMINATED_SUCCESSFULLY,
        TERMINATE_UNSUCCESSFUL;

    }
}

