/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan;

import net.lukemurphey.nsia.scan.DataSpecimen;
import net.lukemurphey.nsia.scan.Evaluator;
import org.apache.commons.lang.StringUtils;

public class StringEvaluator
extends Evaluator {
    private String rule;

    public StringEvaluator(String rule, boolean ignoreCase) {
        if (rule == null) {
            throw new IllegalArgumentException("The rule must not be null");
        }
        if (rule.length() == 0) {
            throw new IllegalArgumentException("The rule must not be empty");
        }
        this.rule = rule;
        this.nocase = ignoreCase;
    }

    @Override
    public int evaluate(DataSpecimen content) {
        return this.evaluate(content, -1);
    }

    @Override
    public int evaluate(DataSpecimen content, int lastMatch, boolean useBasicEncoding) {
        int maxDepth;
        int startLocation;
        String target = useBasicEncoding ? content.getBasicEncodedString() : content.getString();
        int foundAt = StringEvaluator.locationOf(target, this.rule, startLocation = this.computeStartLocation(lastMatch), this.nocase, maxDepth = this.depth > 0 && this.within <= 0 ? this.depth + startLocation : (this.within > 0 && this.depth <= 0 ? this.within + startLocation + this.rule.length() : (this.within > 0 && this.depth > 0 ? Math.min(this.within + startLocation + this.rule.length(), this.depth + startLocation) : target.length())));
        if (foundAt < 0) {
            return foundAt;
        }
        return foundAt + this.rule.length() - 1;
    }

    public String getStringToMatch() {
        return this.rule;
    }

    public static int locationOf(String searchIn, String searchFor, int startLocation, boolean ignoreCase, int maximumDepth) {
        if (searchFor == null) {
            throw new IllegalArgumentException("The string to search for must not be null");
        }
        if (searchFor.isEmpty()) {
            throw new IllegalArgumentException("The string to search for must not be empty");
        }
        if (searchIn == null) {
            throw new IllegalArgumentException("The string to search in must not be null");
        }
        if (searchFor.isEmpty()) {
            throw new IllegalArgumentException("The string to search in must not be empty");
        }
        if (ignoreCase) {
            int offsetIntoSample = 0;
            int c = startLocation;
            while (c < searchIn.length()) {
                if (maximumDepth > 0 && c >= maximumDepth) {
                    return -1;
                }
                if (Character.toUpperCase(searchIn.charAt(c)) == Character.toUpperCase(searchFor.charAt(offsetIntoSample))) {
                    if (offsetIntoSample >= searchFor.length() - 1) {
                        return c - searchFor.length() + 1;
                    }
                    ++offsetIntoSample;
                } else {
                    offsetIntoSample = 0;
                }
                ++c;
            }
        } else {
            if (maximumDepth < 0) {
                return StringUtils.indexOf((String)searchIn, (String)searchFor, (int)startLocation);
            }
            int result = StringUtils.indexOf((String)searchIn, (String)searchFor, (int)startLocation);
            if (result + searchFor.length() > maximumDepth) {
                return -1;
            }
            return result;
        }
        return -1;
    }

    @Override
    public Evaluator.ReturnType getReturnType() {
        return Evaluator.ReturnType.CHARACTER_LOCATION;
    }
}

