/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan.scriptenvironment;

import java.net.URL;
import java.util.Vector;
import net.lukemurphey.nsia.scan.URLToScan;
import sun.org.mozilla.javascript.internal.NativeArray;
import sun.org.mozilla.javascript.internal.NativeJavaObject;

public class Result {
    public boolean matched = false;
    public String description = null;
    public int detectStart;
    public int detectEnd;
    public Vector<URLToScan> urls = new Vector();

    public Result(Vector<URL> urls) {
        this.matched = false;
        if (urls != null) {
            this.addURLs(urls);
        }
    }

    public Result(NativeArray extractedURLs) {
        if (extractedURLs != null) {
            this.addURLs(extractedURLs);
        }
    }

    public Result(boolean matched, String description) {
        this.matched = matched;
        this.description = description;
    }

    public Result(boolean matched, String description, NativeArray extractedURLs) {
        this.matched = matched;
        this.description = description;
        if (extractedURLs != null) {
            this.addURLs(extractedURLs);
        }
    }

    public Result(boolean matched) {
        this.matched = matched;
    }

    public boolean matched() {
        return this.matched;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDetectionStart() {
        return this.detectStart;
    }

    public int getDetectionEnd() {
        return this.detectEnd;
    }

    public Vector<URLToScan> getURLs() {
        return this.urls;
    }

    public int addURLs(Vector<URL> urls) {
        return this.addURLs(urls, false);
    }

    public int addURLs(Vector<URL> urls, boolean ignoreDomainRestriction) {
        for (URL url : urls) {
            this.urls.add(new URLToScan(url, ignoreDomainRestriction));
        }
        return urls.size();
    }

    public void addURL(URL url) {
        this.addURL(url, false);
    }

    public void addURL(URL url, boolean ignoreDomainRestriction) {
        this.urls.add(new URLToScan(url, ignoreDomainRestriction));
    }

    public void addURL(NativeJavaObject url) {
        this.addURL(url, false);
    }

    public void addURL(NativeJavaObject url, boolean ignoreDomainRestriction) {
        Object urlUnWrapped = null;
        urlUnWrapped = url.unwrap();
        if (urlUnWrapped instanceof URL) {
            this.addURL((URL)urlUnWrapped, ignoreDomainRestriction);
        }
    }

    public int addURLs(NativeArray arr) {
        return this.addURLs(arr, false);
    }

    public int addURLs(NativeArray arr, boolean ignoreDomainRestriction) {
        Object[] objectArray = arr.getIds();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            int index = (Integer)o;
            Object object = arr.get(index, null);
            if (object instanceof NativeJavaObject) {
                this.addURL((NativeJavaObject)object, ignoreDomainRestriction);
            } else if (object instanceof URL) {
                this.addURL((URL)object, ignoreDomainRestriction);
            }
            ++n2;
        }
        return this.urls.size();
    }
}

