/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.scan.scriptenvironment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.lukemurphey.nsia.scan.CharsetDetector;
import net.lukemurphey.nsia.scan.DataSpecimen;
import net.lukemurphey.nsia.scan.EncodingDetectionFailedException;

public class ZipFile {
    public static final int DEFAULT_FILE_SIZE_LIMIT = 0x100000;
    private Vector<ZipFileEntry> entries = new Vector();
    private DataSpecimen dataSpecimen;

    public ZipFile(DataSpecimen d) throws IOException {
        this.dataSpecimen = d;
        this.populateZipEntries();
    }

    private void populateZipEntries() throws IOException {
        this.entries = this.getZipFileEntries(this.dataSpecimen);
    }

    private Vector<ZipFileEntry> getZipFileEntries(DataSpecimen dataSpecimen) throws IOException {
        Vector<ZipFileEntry> temp_entries = new Vector<ZipFileEntry>();
        ByteArrayInputStream bis = null;
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            bis = new ByteArrayInputStream(dataSpecimen.getBytes());
            zin = new ZipInputStream(bis);
            while ((entry = zin.getNextEntry()) != null) {
                temp_entries.add(new ZipFileEntry(entry));
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (zin != null) {
                zin.close();
            }
        }
        return temp_entries;
    }

    public String[] getFilenames() {
        Vector<String> v = new Vector<String>();
        for (ZipFileEntry zfe : this.entries) {
            v.add(zfe.getName());
        }
        String[] a = new String[v.size()];
        return v.toArray(a);
    }

    private ZipFileEntry getEntry(String filename) {
        if (filename == null) {
            return null;
        }
        for (ZipFileEntry entry : this.entries) {
            if (!filename.equalsIgnoreCase(entry.getName())) continue;
            return entry;
        }
        return null;
    }

    public boolean hasFile(String filename) {
        return this.getEntry(filename) != null;
    }

    public String getComment(String filename) {
        ZipFileEntry zfe = this.getEntry(filename);
        if (zfe != null) {
            return zfe.getComment();
        }
        return null;
    }

    public long getSize(String filename) {
        ZipFileEntry zfe = this.getEntry(filename);
        if (zfe != null) {
            return zfe.getSize();
        }
        return -1L;
    }

    public long getTime(String filename) {
        ZipFileEntry zfe = this.getEntry(filename);
        if (zfe != null) {
            return zfe.getTime();
        }
        return -1L;
    }

    public long getCrc(String filename) {
        ZipFileEntry zfe = this.getEntry(filename);
        if (zfe != null) {
            return zfe.getCrc();
        }
        return -1L;
    }

    public long getMethod(String filename) {
        ZipFileEntry zfe = this.getEntry(filename);
        if (zfe != null) {
            return zfe.getMethod();
        }
        return -1L;
    }

    public long getCompressedSize(String filename) {
        ZipFileEntry zfe = this.getEntry(filename);
        if (zfe != null) {
            return zfe.getCompressedSize();
        }
        return -1L;
    }

    public byte[] getFileAsBytes(String filename) throws IOException {
        return this.getFileAsBytes(filename, 0x100000);
    }

    public byte[] getFileAsBytes(String filename, int sizelimit) throws IOException {
        if (filename == null) {
            return null;
        }
        ByteArrayInputStream bis = null;
        ZipInputStream zin = null;
        ZipEntry entry = null;
        try {
            bis = new ByteArrayInputStream(this.dataSpecimen.getBytes());
            zin = new ZipInputStream(bis);
            while ((entry = zin.getNextEntry()) != null) {
                if (!filename.equalsIgnoreCase(entry.getName())) continue;
                long maxSizeLong = Math.min((long)sizelimit, entry.getSize());
                int maxSize = maxSizeLong > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxSizeLong;
                maxSize = Math.min(sizelimit, maxSize);
                byte[] b = new byte[maxSize];
                zin.read(b);
                byte[] byArray = b;
                return byArray;
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (zin != null) {
                zin.close();
            }
        }
        return null;
    }

    public String getFileAsString(String filename) throws IOException {
        byte[] fileBytes = this.getFileAsBytes(filename, 0x100000);
        if (fileBytes == null) {
            return null;
        }
        Charset utf8 = (Charset)Charset.availableCharsets().get("UTF8");
        Charset charset = null;
        try {
            String encoding = CharsetDetector.detectCharset(fileBytes);
            charset = (Charset)Charset.availableCharsets().get(encoding);
            if (charset == null) {
                charset = utf8;
            }
        }
        catch (EncodingDetectionFailedException e1) {
            charset = utf8;
        }
        String filetext = null;
        filetext = charset == null ? new String(fileBytes) : new String(fileBytes, charset);
        return filetext;
    }

    private class ZipFileEntry {
        private String name;
        private String comment;
        private long compressedSize;
        private long crc;
        private int method;
        private long size;
        private long time;

        public ZipFileEntry(ZipEntry ze) {
            this.name = ze.getName();
            this.comment = ze.getComment();
            this.compressedSize = ze.getCompressedSize();
            this.crc = ze.getCrc();
            this.method = ze.getMethod();
            this.size = ze.getSize();
            this.time = ze.getTime();
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public long getCrc() {
            return this.crc;
        }

        public int getMethod() {
            return this.method;
        }

        public long getSize() {
            return this.size;
        }

        public long getTime() {
            return this.time;
        }
    }
}

