/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.sql.SQLException;
import junit.framework.TestCase;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ApplicationParameters;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.tests.TestApplication;
import net.lukemurphey.nsia.tests.TestApplicationException;

public class ApplicationParameterTest
extends TestCase {
    ApplicationParameters params = null;
    Application app = null;

    public void setUp() throws TestApplicationException {
        this.app = TestApplication.getApplication();
        this.params = new ApplicationParameters(this.app);
    }

    public void tearDown() {
        TestApplication.stopApplication();
    }

    public void testGetParameter() throws Exception {
        this.params.setParameter("Administration.SyslogServer", "192.168.10.5");
        String value = this.params.getParameter("Administration.SyslogServer", null);
        ApplicationParameterTest.assertNotNull((Object)value);
    }

    public void testSetParameter() throws Exception {
        this.params.setParameter("Administration.SyslogServer", "192.168.10.5");
        String value = this.params.getParameter("Administration.SyslogServer", null);
        if (!value.equals("192.168.10.5")) {
            ApplicationParameterTest.fail((String)"Parameter value was not returned successfully");
        }
    }

    public void testDoesParameterExist() throws InputValidationException, NoDatabaseConnectionException, SQLException {
        this.params.setParameter("Administration.SyslogServer", "192.168.10.5");
        ApplicationParameterTest.assertEquals((boolean)this.params.doesParameterExist("Administration.SyslogServer"), (boolean)true);
        ApplicationParameterTest.assertEquals((boolean)this.params.doesParameterExist("D03sN073x1s7"), (boolean)false);
        ApplicationParameterTest.assertEquals((boolean)this.params.doesParameterExist(null), (boolean)false);
    }
}

