/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import junit.framework.TestCase;
import net.lukemurphey.nsia.scan.ByteTestEvaluator;
import net.lukemurphey.nsia.scan.InvalidEvaluatorException;

public class ByteTestEvaluatorTest
extends TestCase {
    public void testGetMaxValue() {
        double maxValue = ByteTestEvaluator.getMaxValue(2);
        if (maxValue != 65535.0) {
            ByteTestEvaluatorTest.fail((String)("Value was not calculated correctly (returned " + maxValue + ")"));
        }
    }

    public void testCalculateValue() {
        byte[] bytes = new byte[]{1, 2};
        double value = ByteTestEvaluator.getBigEndianValue(bytes);
        if (value != 258.0) {
            ByteTestEvaluatorTest.fail((String)("Value was not calculated correctly (returned " + value + ")"));
        }
    }

    public void testCalculateValue2() {
        byte[] byArray = new byte[3];
        byArray[0] = 1;
        byArray[2] = 1;
        byte[] bytes = byArray;
        double value = ByteTestEvaluator.getBigEndianValue(bytes);
        if (value != 65537.0) {
            ByteTestEvaluatorTest.fail((String)("Value was not calculated correctly (returned " + value + ")"));
        }
    }

    public void testCalculateValueLittleEndian() {
        byte[] byArray = new byte[3];
        byArray[0] = 1;
        byte[] bytes = byArray;
        double value = ByteTestEvaluator.getLittleEndianValue(bytes);
        if (value != 1.0) {
            ByteTestEvaluatorTest.fail((String)("Value was not calculated correctly (returned " + value + ")"));
        }
    }

    public void testCalculateValueLittleEndian2() {
        byte[] byArray = new byte[3];
        byArray[0] = 1;
        byArray[1] = 1;
        byte[] bytes = byArray;
        double value = ByteTestEvaluator.getLittleEndianValue(bytes);
        if (value != 257.0) {
            ByteTestEvaluatorTest.fail((String)("Value was not calculated correctly (returned " + value + ")"));
        }
    }

    public void testBytesInput() throws InvalidEvaluatorException {
        ByteTestEvaluator eval = ByteTestEvaluator.parse("4 bytes > 255");
        byte[] byArray = new byte[5];
        byArray[2] = 1;
        byte[] data = byArray;
        int result = eval.evaluate(data);
        if (result != 3) {
            ByteTestEvaluatorTest.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }

    public void testBytesOutsideBounds() throws InvalidEvaluatorException {
        ByteTestEvaluator eval = ByteTestEvaluator.parse("8 bytes > 255");
        byte[] byArray = new byte[5];
        byArray[2] = 1;
        byte[] data = byArray;
        int result = eval.evaluate(data);
        if (result != 3) {
            ByteTestEvaluatorTest.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }

    public void testStringInput() throws InvalidEvaluatorException {
        ByteTestEvaluator eval = ByteTestEvaluator.parse("4 digits > 255");
        int result = eval.evaluate("0256");
        if (result != 3) {
            ByteTestEvaluatorTest.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }

    public void testStringOutsideBounds() throws InvalidEvaluatorException {
        ByteTestEvaluator eval = ByteTestEvaluator.parse("4 digits > 255");
        int result = eval.evaluate("256");
        if (result != 2) {
            ByteTestEvaluatorTest.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }

    public void testBytesSignedNegative() throws InvalidEvaluatorException {
        ByteTestEvaluator eval = ByteTestEvaluator.parse("1 byte = 255");
        eval.setOffset(3);
        byte[] byArray = new byte[5];
        byArray[3] = -128;
        byte[] data = byArray;
        int result = eval.evaluate(data);
        if (result != 3) {
            ByteTestEvaluatorTest.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }

    public void testBytesSignedLittleEndian() throws InvalidEvaluatorException {
        ByteTestEvaluator eval = ByteTestEvaluator.parse("4 bytes = 8 (little-endian)");
        byte[] byArray = new byte[5];
        byArray[0] = 8;
        byte[] data = byArray;
        int result = eval.evaluate(data);
        if (result != 3) {
            ByteTestEvaluatorTest.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }

    public void testBytesSignedLittleEndian2() throws InvalidEvaluatorException {
        ByteTestEvaluator eval = ByteTestEvaluator.parse("4 bytes = 258 (little-endian)");
        byte[] byArray = new byte[5];
        byArray[0] = 2;
        byArray[1] = 1;
        byte[] data = byArray;
        int result = eval.evaluate(data);
        if (result != 3) {
            ByteTestEvaluatorTest.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }

    public void testHex() throws InvalidEvaluatorException {
        ByteTestEvaluator eval = ByteTestEvaluator.parse("4 digits = 31 (hexadecimal)");
        int result = eval.evaluate("001F000");
        if (result != 3) {
            ByteTestEvaluatorTest.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }

    public void testImpossibleValueString() {
        try {
            ByteTestEvaluator.parse("1 digit = 11");
        }
        catch (InvalidEvaluatorException e) {
            return;
        }
        ByteTestEvaluatorTest.fail((String)"The parse method failed to recognize that the evaluator will never be able to derive the value provided");
    }

    public void testImpossibleValueHexString() {
        try {
            ByteTestEvaluator.parse("2 digits = 257 (hexadecimal)");
        }
        catch (InvalidEvaluatorException e) {
            return;
        }
        ByteTestEvaluatorTest.fail((String)"The parse method failed to recognize that the evaluator will never be able to derive the value provided");
    }

    public void testImpossibleValueByte() {
        try {
            ByteTestEvaluator.parse("2 bytes = 65537");
        }
        catch (InvalidEvaluatorException e) {
            return;
        }
        ByteTestEvaluatorTest.fail((String)"The parse method failed to recognize that the evaluator will never be able to derive the value provided");
    }

    public void testHighValueString() {
        try {
            ByteTestEvaluator.parse("1 digit = 9");
        }
        catch (InvalidEvaluatorException e) {
            ByteTestEvaluatorTest.fail((String)"The parse method failed to recognize that the evaluator is within range");
        }
    }

    public void testHighValueHexString() {
        try {
            ByteTestEvaluator.parse("2 digits = 255 (hexadecimal)");
        }
        catch (InvalidEvaluatorException e) {
            ByteTestEvaluatorTest.fail((String)"The parse method failed to recognize that the evaluator is within range");
        }
    }

    public void testHighValueByte() {
        try {
            ByteTestEvaluator.parse("2 bytes = 65535");
        }
        catch (InvalidEvaluatorException e) {
            ByteTestEvaluatorTest.fail((String)"The parse method failed to recognize that the evaluator is within range");
        }
    }

    public void testAbsoluteValue() throws InvalidEvaluatorException {
        ByteTestEvaluator byteTest = ByteTestEvaluator.parse("4 digits = 128 (absolute-value)");
        int result = byteTest.evaluate("-1289");
        if (result != 3) {
            ByteTestEvaluatorTest.fail((String)("The evaluator failed to derive the correct results (returned " + result + ")"));
        }
    }
}

