/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import junit.framework.TestCase;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.rest.RESTRequestFailedException;
import net.lukemurphey.nsia.scan.DefinitionArchive;
import net.lukemurphey.nsia.scan.DefinitionSet;
import net.lukemurphey.nsia.scan.DefinitionSetLoadException;
import net.lukemurphey.nsia.scan.DefinitionUpdateFailedException;
import net.lukemurphey.nsia.tests.TestApplication;
import net.lukemurphey.nsia.tests.TestApplicationException;

public class ContentSignatureArchiveTest
extends TestCase {
    public void tearDown() {
        TestApplication.stopApplication();
    }

    public void testGetLatestID() throws RESTRequestFailedException, IOException {
        DefinitionSet.DefinitionVersionID latestID = DefinitionArchive.getLatestAvailableDefinitionSetID();
        if (latestID == null) {
            ContentSignatureArchiveTest.fail((String)"Latest definition ID could not be obtained");
        } else if (latestID.formatID() <= 0) {
            ContentSignatureArchiveTest.fail((String)("Latest definition format ID in invalid (" + latestID.formatID() + ")"));
        } else if (latestID.revisionID() < 0) {
            ContentSignatureArchiveTest.fail((String)("Latest definition revision ID in invalid (" + latestID.revisionID() + ")"));
        }
    }

    public void testRevisionIDParse() throws IOException {
        DefinitionSet.DefinitionVersionID rev = new DefinitionSet.DefinitionVersionID("1.2 beta");
        if (!rev.toString().equalsIgnoreCase("1.2 beta")) {
            ContentSignatureArchiveTest.fail((String)("Format of parsed version identifier is unexpected (" + rev.toString() + ")"));
        }
    }

    public void testRevisionDate() throws RESTRequestFailedException, IOException, ParseException {
        Date date = DefinitionArchive.getLatestAvailableDefinitionSetDate();
        if (date == null) {
            ContentSignatureArchiveTest.fail((String)"Latest date could not be obtained");
        }
    }

    public void testLoadSignaturesFromServer() throws DefinitionUpdateFailedException, DefinitionSetLoadException, NoDatabaseConnectionException, SQLException, InputValidationException, TestApplicationException, IOException {
        String licenseKey = TestApplication.getProperty("value.test.licensekey");
        if (licenseKey != null) {
            Application app = TestApplication.getApplication();
            app.getApplicationConfiguration().setLicenseKey(licenseKey);
            DefinitionArchive archive = DefinitionArchive.getArchive(true);
            DefinitionSet.DefinitionVersionID rev = archive.updateDefinitions();
            if (rev == null) {
                ContentSignatureArchiveTest.fail((String)"Current definition set could not be obtained");
            }
        }
    }
}

