/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.Vector;
import junit.framework.TestCase;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.scan.DefinitionPolicyDescriptor;
import net.lukemurphey.nsia.scan.DefinitionPolicyManagement;
import net.lukemurphey.nsia.scan.MetaDefinition;
import net.lukemurphey.nsia.tests.TestApplication;
import net.lukemurphey.nsia.tests.TestApplicationException;
import net.lukemurphey.nsia.upgrade.UpgradeFailureException;
import net.lukemurphey.nsia.upgrade.processors.ConvertMetaDefinitionExceptions;

public class ConvertMetaDefinitionExceptionsTest
extends TestCase {
    Application app = null;
    ConvertMetaDefinitionExceptions converter = null;
    DefinitionPolicyManagement policyManagement = null;
    Vector<DefinitionPolicyDescriptor> policyDescriptors = new Vector();

    public void setUp() throws TestApplicationException {
        this.app = TestApplication.getApplication();
        this.policyManagement = new DefinitionPolicyManagement(this.app);
        this.converter = new ConvertMetaDefinitionExceptions();
    }

    public void tearDown() {
        TestApplication.stopApplication();
    }

    private void populateSamples() throws SQLException, NoDatabaseConnectionException {
        this.createSample(DefinitionPolicyDescriptor.createDefinitionPolicy(1, 20, "Def", "Category", "SubCategory", null, DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE));
        this.createSample(DefinitionPolicyDescriptor.createCategoryPolicy("Category", DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE));
        this.createSample(DefinitionPolicyDescriptor.createSubCategoryPolicy("Category", "SubCategory", DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE));
    }

    private void createSample(DefinitionPolicyDescriptor desc) throws SQLException, NoDatabaseConnectionException {
        desc.saveToDatabase(this.app.getDatabaseConnection(Application.DatabaseAccessType.ADMIN));
        this.policyDescriptors.add(desc);
    }

    private String checkSamples() throws MalformedURLException, SQLException, NoDatabaseConnectionException {
        for (DefinitionPolicyDescriptor desc : this.policyDescriptors) {
            DefinitionPolicyDescriptor desc2 = this.policyManagement.getPolicy(desc.getPolicyID());
            if (desc2 == null) {
                return "Policy with ID " + desc.getPolicyID() + " not found";
            }
            if ((desc2.getDefinitionCategory() == null || desc.getDefinitionCategory() == null) && desc.getDefinitionCategory() != desc2.getDefinitionCategory()) {
                ConvertMetaDefinitionExceptionsTest.fail((String)(String.valueOf(desc2.getDefinitionCategory()) + " does not match " + desc.getDefinitionCategory()));
            } else if (desc2.getDefinitionCategory() != null && !desc2.getDefinitionCategory().equals(desc.getDefinitionCategory())) {
                ConvertMetaDefinitionExceptionsTest.fail((String)(String.valueOf(desc2.getDefinitionCategory()) + " does not match " + desc.getDefinitionCategory()));
            }
            if ((desc2.getDefinitionSubCategory() == null || desc.getDefinitionSubCategory() == null) && desc.getDefinitionSubCategory() != desc2.getDefinitionSubCategory()) {
                ConvertMetaDefinitionExceptionsTest.fail((String)(String.valueOf(desc2.getDefinitionSubCategory()) + " does not match " + desc.getDefinitionSubCategory()));
            } else if (desc2.getDefinitionSubCategory() != null && !desc2.getDefinitionSubCategory().equals(desc.getDefinitionSubCategory())) {
                return String.valueOf(desc2.getDefinitionSubCategory()) + " does not match " + desc.getDefinitionSubCategory();
            }
            if ((desc2.getDefinitionName() == null || desc.getDefinitionName() == null) && desc.getDefinitionName() != desc2.getDefinitionName()) {
                ConvertMetaDefinitionExceptionsTest.fail((String)(String.valueOf(desc2.getDefinitionName()) + " does not match " + desc.getDefinitionName()));
                continue;
            }
            if (desc2.getDefinitionName() == null || desc2.getDefinitionName().equals(desc.getDefinitionName())) continue;
            ConvertMetaDefinitionExceptionsTest.fail((String)(String.valueOf(desc2.getDefinitionName()) + " does not match " + desc.getDefinitionName()));
        }
        return null;
    }

    public void testConvertDefinitions() throws UpgradeFailureException, MalformedURLException, SQLException, NoDatabaseConnectionException {
        DefinitionPolicyDescriptor desc = DefinitionPolicyDescriptor.createDefinitionPolicy(1, 20, "Anomaly", "ContentError", MetaDefinition.BROKEN_LINK.getName(), null, DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE);
        desc.saveToDatabase(this.app.getDatabaseConnection(Application.DatabaseAccessType.ADMIN));
        if (desc.getPolicyID() <= 0) {
            ConvertMetaDefinitionExceptionsTest.fail((String)"Policy did not get created properly");
        }
        this.populateSamples();
        this.converter.doUpgrade(this.app);
        this.checkSamples();
        DefinitionPolicyDescriptor desc2 = this.policyManagement.getPolicy(desc.getPolicyID());
        if (!desc2.getDefinitionName().equalsIgnoreCase(MetaDefinition.BROKEN_LINK.getName())) {
            ConvertMetaDefinitionExceptionsTest.fail((String)"Definition name was changed inappropriately");
        }
        if (!desc2.getDefinitionSubCategory().equalsIgnoreCase(MetaDefinition.BROKEN_LINK.getSubCategoryName())) {
            ConvertMetaDefinitionExceptionsTest.fail((String)"Definition sub-category was not upgraded correctly");
        }
        if (!desc2.getDefinitionCategory().equalsIgnoreCase(MetaDefinition.BROKEN_LINK.getCategoryName())) {
            ConvertMetaDefinitionExceptionsTest.fail((String)"Definition category was not upgraded correctly");
        }
    }

    public void testConvertCategories() throws UpgradeFailureException, MalformedURLException, SQLException, NoDatabaseConnectionException {
        DefinitionPolicyDescriptor desc = DefinitionPolicyDescriptor.createCategoryPolicy(21, "Anomaly", DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE);
        desc.saveToDatabase(this.app.getDatabaseConnection(Application.DatabaseAccessType.ADMIN));
        this.populateSamples();
        this.converter.doUpgrade(this.app);
        this.checkSamples();
        DefinitionPolicyDescriptor desc2 = this.policyManagement.getPolicy(desc.getPolicyID());
        if (!desc2.getDefinitionCategory().equalsIgnoreCase(MetaDefinition.BROKEN_LINK.getCategoryName())) {
            ConvertMetaDefinitionExceptionsTest.fail((String)"Definition category was not upgraded correctly");
        }
    }

    public void testConvertSubCategories() throws UpgradeFailureException, SQLException, NoDatabaseConnectionException, MalformedURLException {
        DefinitionPolicyDescriptor desc = DefinitionPolicyDescriptor.createDefinitionPolicy(1, 20, "Anomaly", "ContentError", MetaDefinition.BROKEN_LINK.getName(), null, DefinitionPolicyDescriptor.DefinitionPolicyAction.EXCLUDE);
        desc.saveToDatabase(this.app.getDatabaseConnection(Application.DatabaseAccessType.ADMIN));
        this.populateSamples();
        this.converter.doUpgrade(this.app);
        this.checkSamples();
        DefinitionPolicyDescriptor desc2 = this.policyManagement.getPolicy(desc.getPolicyID());
        if (!desc2.getDefinitionName().equalsIgnoreCase(MetaDefinition.BROKEN_LINK.getName())) {
            ConvertMetaDefinitionExceptionsTest.fail((String)"Definition name was changed inappropriately");
        }
        if (!desc2.getDefinitionSubCategory().equalsIgnoreCase(MetaDefinition.BROKEN_LINK.getSubCategoryName())) {
            ConvertMetaDefinitionExceptionsTest.fail((String)"Definition sub-category was not upgraded correctly");
        }
        if (!desc2.getDefinitionCategory().equalsIgnoreCase(MetaDefinition.BROKEN_LINK.getCategoryName())) {
            ConvertMetaDefinitionExceptionsTest.fail((String)"Definition category was not upgraded correctly");
        }
    }
}

