/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.io.IOException;
import junit.framework.TestCase;
import net.lukemurphey.nsia.scan.DataSpecimen;
import net.lukemurphey.nsia.scan.EncodingDetectionFailedException;

public class DataSpecimenTest
extends TestCase {
    public void testCharacterSetDetection() throws IOException, EncodingDetectionFailedException {
        DataSpecimen data = new DataSpecimen("ABCD".getBytes("UTF-16"));
        String result = data.getEncoding().displayName();
        if (!result.equalsIgnoreCase("UTF-16BE")) {
            DataSpecimenTest.fail((String)("Result is : " + result));
        }
    }

    public void testBytesUnalteredUTF16() throws IOException, EncodingDetectionFailedException {
        DataSpecimen data;
        byte[] bytes2;
        byte[] bytes = "ABCD".getBytes("UTF-16");
        if (bytes.length != (bytes2 = (data = new DataSpecimen(bytes)).getBytes()).length) {
            DataSpecimenTest.fail((String)"Byte lengths are not equal");
        }
    }

    public void testBytesUnalteredUTF8() throws IOException, EncodingDetectionFailedException {
        DataSpecimen data;
        byte[] bytes2;
        byte[] bytes = "AB\u00c5\u00b7CD".getBytes("UTF-8");
        if (bytes.length != (bytes2 = (data = new DataSpecimen(bytes)).getBytes()).length) {
            DataSpecimenTest.fail((String)"Byte lengths are not equal");
        }
    }
}

