/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.TestCase;
import net.lukemurphey.nsia.InetAddressRange;
import net.lukemurphey.nsia.InputValidationException;

public class InetAddressRangeTest
extends TestCase {
    public static void main(String[] args) {
    }

    public void testGetByRange() throws UnknownHostException {
        InetAddress five;
        InetAddress four;
        InetAddress three;
        InetAddress two;
        InetAddress one;
        InetAddress zero;
        block44: {
            boolean expectionCaught;
            block42: {
                block40: {
                    block38: {
                        block36: {
                            zero = InetAddress.getByName("0.0.0.0");
                            one = InetAddress.getByName("32.1.3.4");
                            two = InetAddress.getByName("127.255.255.255");
                            three = InetAddress.getByName("128.0.0.0");
                            four = InetAddress.getByName("132.1.3.4");
                            five = InetAddress.getByName("255.255.255.255");
                            expectionCaught = false;
                            try {
                                try {
                                    expectionCaught = false;
                                    InetAddressRange.getByRange(one, zero);
                                }
                                catch (IllegalArgumentException e) {
                                    expectionCaught = true;
                                    if (!expectionCaught) {
                                        InetAddressRangeTest.fail((String)"Failed to throw exception");
                                    }
                                    break block36;
                                }
                            }
                            catch (Throwable throwable) {
                                if (!expectionCaught) {
                                    InetAddressRangeTest.fail((String)"Failed to throw exception");
                                }
                                throw throwable;
                            }
                            if (!expectionCaught) {
                                InetAddressRangeTest.fail((String)"Failed to throw exception");
                            }
                        }
                        try {
                            try {
                                expectionCaught = false;
                                InetAddressRange.getByRange(two, zero);
                            }
                            catch (IllegalArgumentException e) {
                                expectionCaught = true;
                                if (!expectionCaught) {
                                    InetAddressRangeTest.fail((String)"Failed to throw exception");
                                }
                                break block38;
                            }
                        }
                        catch (Throwable throwable) {
                            if (!expectionCaught) {
                                InetAddressRangeTest.fail((String)"Failed to throw exception");
                            }
                            throw throwable;
                        }
                        if (!expectionCaught) {
                            InetAddressRangeTest.fail((String)"Failed to throw exception");
                        }
                    }
                    try {
                        try {
                            expectionCaught = false;
                            InetAddressRange.getByRange(four, three);
                        }
                        catch (IllegalArgumentException e) {
                            expectionCaught = true;
                            if (!expectionCaught) {
                                InetAddressRangeTest.fail((String)"Failed to throw exception");
                            }
                            break block40;
                        }
                    }
                    catch (Throwable throwable) {
                        if (!expectionCaught) {
                            InetAddressRangeTest.fail((String)"Failed to throw exception");
                        }
                        throw throwable;
                    }
                    if (!expectionCaught) {
                        InetAddressRangeTest.fail((String)"Failed to throw exception");
                    }
                }
                try {
                    try {
                        expectionCaught = false;
                        InetAddressRange.getByRange(five, four);
                    }
                    catch (IllegalArgumentException e) {
                        expectionCaught = true;
                        if (!expectionCaught) {
                            InetAddressRangeTest.fail((String)"Failed to throw exception");
                        }
                        break block42;
                    }
                }
                catch (Throwable throwable) {
                    if (!expectionCaught) {
                        InetAddressRangeTest.fail((String)"Failed to throw exception");
                    }
                    throw throwable;
                }
                if (!expectionCaught) {
                    InetAddressRangeTest.fail((String)"Failed to throw exception");
                }
            }
            try {
                try {
                    expectionCaught = false;
                    InetAddressRange.getByRange(five, zero);
                }
                catch (IllegalArgumentException e) {
                    expectionCaught = true;
                    if (!expectionCaught) {
                        InetAddressRangeTest.fail((String)"Failed to throw exception");
                    }
                    break block44;
                }
            }
            catch (Throwable throwable) {
                if (!expectionCaught) {
                    InetAddressRangeTest.fail((String)"Failed to throw exception");
                }
                throw throwable;
            }
            if (!expectionCaught) {
                InetAddressRangeTest.fail((String)"Failed to throw exception");
            }
        }
        InetAddressRange.getByRange(one, two);
        InetAddressRange.getByRange(two, three);
        InetAddressRange.getByRange(two, four);
        InetAddressRange.getByRange(three, five);
        InetAddressRange.getByRange(zero, five);
        InetAddressRange.getByRange(four, five);
        InetAddressRange.getByRange(two, five);
    }

    public void testIsWithinRange() throws UnknownHostException {
        InetAddress one = InetAddress.getByName("32.1.3.4");
        InetAddress two = InetAddress.getByName("127.255.255.255");
        InetAddressRange inetAddressRange = InetAddressRange.getByRange(one, two);
        InetAddress within1 = InetAddress.getByName("32.1.3.4");
        InetAddress within2 = InetAddress.getByName("32.1.3.5");
        InetAddress notWithin1 = InetAddress.getByName("1.1.3.4");
        InetAddress notWithin2 = InetAddress.getByName("128.0.0.0");
        if (!inetAddressRange.isWithinRange(within1)) {
            InetAddressRangeTest.fail((String)"Address is within range but returned false");
        }
        if (!inetAddressRange.isWithinRange(within2)) {
            InetAddressRangeTest.fail((String)"Address is within range but returned false");
        }
        if (inetAddressRange.isWithinRange(notWithin1)) {
            InetAddressRangeTest.fail((String)"Address is not within range but returned true");
        }
        if (inetAddressRange.isWithinRange(notWithin2)) {
            InetAddressRangeTest.fail((String)"Address is not within range but returned true");
        }
    }

    public void testGetStartAddressString() throws UnknownHostException {
        InetAddress two;
        InetAddress one = InetAddress.getByName("32.1.3.4");
        InetAddressRange inetAddressRange = InetAddressRange.getByRange(one, two = InetAddress.getByName("255.255.255.255"));
        if (!inetAddressRange.toString().matches("32.1.3.4-255.255.255.255")) {
            InetAddressRangeTest.fail((String)"Range failed to match");
        }
    }

    public void testGetEndAddressString() throws UnknownHostException {
        InetAddressRange addressRange = InetAddressRange.getBySubnetRange(InetAddress.getByName("10.2.3.4"), InetAddress.getByName("0.0.0.255"));
        if (!addressRange.toString().matches("10.2.3.0-10.2.3.255")) {
            InetAddressRangeTest.fail((String)"Address range not correctly computed");
        }
    }

    public void testIsLoopback() throws UnknownHostException {
        InetAddress loopbackStart = InetAddress.getByName("127.0.0.1");
        InetAddress loopbackEnd = InetAddress.getByName("127.255.255.254");
        InetAddress loopbackMid = InetAddress.getByName("127.0.128.32");
        InetAddress notLoopback = InetAddress.getByName("192.0.132.24");
        if (!InetAddressRange.isAddressLoopback(loopbackStart)) {
            InetAddressRangeTest.fail((String)"Loopback start not accepted");
        }
        if (!InetAddressRange.isAddressLoopback(loopbackEnd)) {
            InetAddressRangeTest.fail((String)"Loopback start not accepted");
        }
        if (!InetAddressRange.isAddressLoopback(loopbackMid)) {
            InetAddressRangeTest.fail((String)"Loopback start not accepted");
        }
        if (InetAddressRange.isAddressLoopback(notLoopback)) {
            InetAddressRangeTest.fail((String)"Non-loopback accepted");
        }
    }

    public void testParseRange() throws UnknownHostException, InputValidationException {
        InetAddressRange addressRange = InetAddressRange.getByRange("1.2.3.4-1.2.3.6");
        if (addressRange == null) {
            InetAddressRangeTest.fail((String)"Null returned");
        } else if (!addressRange.getStartAddressString().equals("1.2.3.4")) {
            InetAddressRangeTest.fail((String)("Start of address range not accepted correctly:" + addressRange.getStartAddressString()));
        } else if (!addressRange.getEndAddressString().equals("1.2.3.6")) {
            InetAddressRangeTest.fail((String)("End of address range not accepted correctly:" + addressRange.getEndAddressString()));
        }
        addressRange = InetAddressRange.getByRange(" 5.6.7.8 - 9.10.11.12 ");
        if (addressRange == null) {
            InetAddressRangeTest.fail((String)"Null returned");
        } else if (!addressRange.getStartAddressString().equals("5.6.7.8")) {
            InetAddressRangeTest.fail((String)("Start of address range not accepted correctly:" + addressRange.getStartAddressString()));
        } else if (!addressRange.getEndAddressString().equals("9.10.11.12")) {
            InetAddressRangeTest.fail((String)("End of address range not accepted correctly:" + addressRange.getEndAddressString()));
        }
        try {
            addressRange = InetAddressRange.getByRange(" 256.6.7.8 - 256.10.11.12 ");
        }
        catch (InputValidationException e) {
            return;
        }
        InetAddressRangeTest.fail((String)("Invalid address range accepted:" + addressRange.toString()));
    }
}

