/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import junit.framework.TestCase;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.Authentication;
import net.lukemurphey.nsia.ClientData;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.LocalPasswordAuthentication;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NumericalOverflowException;
import net.lukemurphey.nsia.PasswordAuthenticationValidator;
import net.lukemurphey.nsia.tests.TestApplication;
import net.lukemurphey.nsia.tests.TestApplicationException;

public class LocalPasswordAuthenticationTest
extends TestCase {
    LocalPasswordAuthentication localPwd;
    Application app = null;

    public void setUp() throws TestApplicationException {
        this.app = TestApplication.getApplication();
        this.localPwd = new LocalPasswordAuthentication(this.app);
    }

    public void tearDown() {
        TestApplication.stopApplication();
    }

    public void testAuthenticateStringPasswordAuthenticationValidatorValid() throws UnknownHostException, NoSuchAlgorithmException, SQLException, InputValidationException, NoDatabaseConnectionException, NumericalOverflowException {
        PasswordAuthenticationValidator validator = new PasswordAuthenticationValidator("asdfasdf");
        ClientData clientData = new ClientData(InetAddress.getLocalHost(), "Eclipse Test JUnit Case");
        Authentication.AuthenticationResult authResult = this.localPwd.authenticate("Test", validator, clientData);
        if (authResult.getAuthenticationStatus() != 0) {
            LocalPasswordAuthenticationTest.fail((String)"The authentication failed for a valid user");
        }
    }

    public void testAuthenticateStringPasswordAuthenticationValidatorInvalid() throws NoSuchAlgorithmException, SQLException, InputValidationException, NoDatabaseConnectionException, NumericalOverflowException, UnknownHostException {
        PasswordAuthenticationValidator validator = new PasswordAuthenticationValidator("invalidPassword");
        ClientData clientData = new ClientData(InetAddress.getLocalHost(), "Eclipse Test JUnit Case");
        Authentication.AuthenticationResult authResult = this.localPwd.authenticate("Test", validator, clientData);
        if (authResult.getAuthenticationStatus() == 0) {
            LocalPasswordAuthenticationTest.fail((String)"The authentication succeeded for a invalid user");
        }
    }

    public void testValidAccountLockout() throws SQLException, NumericalOverflowException, InputValidationException, NoDatabaseConnectionException, NoSuchAlgorithmException, UnknownHostException {
        PasswordAuthenticationValidator validator = new PasswordAuthenticationValidator("invalidPassword");
        ClientData clientData = new ClientData(InetAddress.getLocalHost(), "Eclipse Test JUnit Case");
        int c = 0;
        while (c < 5) {
            this.localPwd.authenticate("Test", validator, clientData);
            ++c;
        }
        if (!this.localPwd.isAccountBruteForceLocked("Test")) {
            LocalPasswordAuthenticationTest.fail((String)"Account was not locked out");
        }
    }

    public void testValidAccountLockoutCaseCheck() throws SQLException, NumericalOverflowException, InputValidationException, NoDatabaseConnectionException, NoSuchAlgorithmException, UnknownHostException {
        PasswordAuthenticationValidator validator = new PasswordAuthenticationValidator("invalidPassword");
        ClientData clientData = new ClientData(InetAddress.getLocalHost(), "Eclipse Test JUnit Case");
        this.localPwd.authenticate("lockedOut", validator, clientData);
        this.localPwd.authenticate("LockedOut", validator, clientData);
        this.localPwd.authenticate("LOCkedout", validator, clientData);
        this.localPwd.authenticate("locKEDOut", validator, clientData);
        this.localPwd.authenticate("LOCKEDOUT", validator, clientData);
        if (!this.localPwd.isAccountBruteForceLocked("lockedout")) {
            LocalPasswordAuthenticationTest.fail((String)"Account was not locked out (using same login name with different cases)");
        }
    }

    public void testInvalidAccountLockout() throws SQLException, NumericalOverflowException, InputValidationException, NoDatabaseConnectionException, NoSuchAlgorithmException, UnknownHostException {
        PasswordAuthenticationValidator validator = new PasswordAuthenticationValidator("invalidPassword");
        ClientData clientData = new ClientData(InetAddress.getLocalHost(), "Eclipse Test JUnit Case");
        int c = 0;
        while (c < 5) {
            this.localPwd.authenticate("NotARealUser", validator, clientData);
            ++c;
        }
        if (!this.localPwd.isAccountBruteForceLocked("NotARealUser")) {
            LocalPasswordAuthenticationTest.fail((String)"Account was not locked out");
        }
    }
}

