/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import net.lukemurphey.nsia.scan.DataSpecimen;
import net.lukemurphey.nsia.scan.InvalidDefinitionException;
import net.lukemurphey.nsia.scan.InvalidEvaluatorException;
import net.lukemurphey.nsia.scan.RegexEvaluator;
import net.lukemurphey.nsia.scan.UnpurposedDefinitionException;

public class RegexEvaluatorTest
extends TestCase {
    public void testBasicRegex() throws InvalidEvaluatorException {
        RegexEvaluator regexEval = new RegexEvaluator("/apple/i");
        int result = regexEval.evaluate("0123456789aPple");
        if (result != 14) {
            RegexEvaluatorTest.fail((String)("Regex evaluator failed to find string at position 14 (returned " + result + ")"));
        }
    }

    public void testUTF16() throws UnsupportedEncodingException, InvalidEvaluatorException {
        RegexEvaluator regexEval = new RegexEvaluator("/apple/i");
        DataSpecimen data = new DataSpecimen("012aPple1234".getBytes("UTF-16"));
        int result = regexEval.evaluate(data);
        if (result != 8) {
            RegexEvaluatorTest.fail((String)("Regex evaluator failed to find string at position 24 (returned " + result + ")"));
        }
    }

    public void testHexNoopLookup() throws InvalidDefinitionException, UnpurposedDefinitionException, UnsupportedEncodingException, InvalidEvaluatorException {
        RegexEvaluator regexEval = new RegexEvaluator("/\\x90/");
        byte[] byArray = new byte[7];
        byArray[0] = 65;
        byArray[1] = 66;
        byArray[2] = 67;
        byArray[3] = -112;
        byArray[4] = -128;
        byArray[6] = 9;
        byte[] bytes = byArray;
        int result = regexEval.evaluate(new DataSpecimen(bytes, true));
        if (result != 3) {
            RegexEvaluatorTest.fail((String)("Regex evaluator failed to detect value at position 4, (returned " + result + ")"));
        }
    }

    public void testHexNoopLookup2() throws InvalidDefinitionException, UnpurposedDefinitionException, UnsupportedEncodingException, InvalidEvaluatorException {
        RegexEvaluator regexEval = new RegexEvaluator("/\\x90/");
        byte[] byArray = new byte[7];
        byArray[0] = 65;
        byArray[1] = 66;
        byArray[2] = 67;
        byArray[3] = -112;
        byArray[4] = -128;
        byArray[6] = 9;
        byte[] bytes = byArray;
        int result = regexEval.evaluate(new DataSpecimen(bytes, true));
        if (result != 3) {
            RegexEvaluatorTest.fail((String)("Regex evaluator failed to detect value at position 4, (returned " + result + ")"));
        }
    }

    public void testRawHexLookup() throws InvalidDefinitionException, UnpurposedDefinitionException, UnsupportedEncodingException, InvalidEvaluatorException {
        RegexEvaluator regexEval = new RegexEvaluator("/ABC\\x90/");
        byte[] bytes = new byte[]{97, 98, 65, 66, 67, -112, -112};
        DataSpecimen data = new DataSpecimen(bytes);
        int result = regexEval.evaluate(data);
        if (result != 5) {
            RegexEvaluatorTest.fail((String)("Regex evaluator failed to detect value at position 4, (returned " + result + ")"));
        }
    }

    public void testUncodeHexLookup() throws InvalidDefinitionException, UnpurposedDefinitionException, UnsupportedEncodingException, InvalidEvaluatorException {
        RegexEvaluator regexEval = new RegexEvaluator("/ABC\\u0041/i");
        byte[] bytes = "ABCA".getBytes("UTF-16");
        DataSpecimen data = new DataSpecimen(bytes);
        int result = regexEval.evaluate(data);
        if (result != 4) {
            RegexEvaluatorTest.fail((String)("Regex evaluator failed to detect value at position 4, (returned " + result + ")"));
        }
    }

    public void testBasicRegexCaseSensitivity() throws InvalidEvaluatorException {
        RegexEvaluator regexEval = new RegexEvaluator("/apple/");
        int result = regexEval.evaluate("0123456789aPple");
        if (result != -1) {
            RegexEvaluatorTest.fail((String)("Regex evaluator should have rejected (returned " + result + ")"));
        }
    }
}

