/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.sql.SQLException;
import junit.framework.TestCase;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ScannerController;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.tests.TestApplication;
import net.lukemurphey.nsia.tests.TestApplicationException;

public class ScannerControllerTest
extends TestCase {
    ScannerController scannerController;
    Application app = null;

    public void setUp() throws TestApplicationException {
        this.app = TestApplication.getApplication(true);
        this.scannerController = new ScannerController(this.app);
    }

    public void tearDown() {
        TestApplication.stopApplication();
    }

    public void testScanningEnabled() {
        this.scannerController.disableScanning();
        if (this.scannerController.scanningEnabled()) {
            ScannerControllerTest.fail((String)"Scanning was not properly disabled");
        }
        this.scannerController.enableScanning();
        if (!this.scannerController.scanningEnabled()) {
            ScannerControllerTest.fail((String)"Scanning was not properly Enabled");
        }
    }

    public void testEnterScanningLoop() throws SQLException, Exception {
        ScannerController scannerController2 = new ScannerController(this.app);
        scannerController2.setMaxScanThreads(5);
        scannerController2.start();
        Thread.sleep(5000L);
        scannerController2.disableScanning();
        while (!scannerController2.isAlive()) {
            Thread.sleep(1000L);
        }
        if (this.scannerController.scanningEnabled()) {
            ScannerControllerTest.fail((String)"Scanner failed to exit scanning loop");
        }
    }

    public void testGetMaxScanThreads() {
        this.scannerController.setMaxScanThreads(5);
        if (this.scannerController.getMaxScanThreads() != 5) {
            ScannerControllerTest.fail((String)"Max thread count not properly retained");
        }
    }

    public void testScanExpiredRules() {
    }

    public void testScanUpdatedRules() throws SQLException, Exception {
    }

    public void testScanRule() throws SQLException, Exception {
        ScanResult scanResult = this.scannerController.scanRule(1L, false);
        if (scanResult.getResultCode() != ScanResultCode.SCAN_COMPLETED) {
            ScannerControllerTest.fail((String)("Scan did not complete (" + scanResult.getResultCode().toString() + ")"));
        }
    }

    public void testScanAllRules() {
    }

    public void testGetPollingLoopFrequency() {
        this.scannerController.setPollingLoopFrequency(60000L);
        if (this.scannerController.getPollingLoopFrequency() != 60000L) {
            ScannerControllerTest.fail((String)"Polling loop frequency not properly retained");
        }
    }
}

