/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import net.lukemurphey.nsia.DerbyDatabaseInitializer;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import org.apache.commons.dbcp.BasicDataSource;

public class TestResources {
    private static TestResources testRes = null;
    private BasicDataSource connectionBroker;
    private static final String TEST_RESOURCE_DIRECTORY = "dev/test/";

    public static synchronized TestResources getTestResources() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoDatabaseConnectionException {
        if (testRes != null) {
            return testRes;
        }
        testRes = new TestResources();
        testRes.connectToInternalDatabase(false);
        return testRes;
    }

    public static void closeTest() throws SQLException {
        if (testRes != null) {
            TestResources.testRes.connectionBroker.close();
        }
    }

    public static String getBaseDir() {
        String path = System.getProperty("net.lukemurphey.nsia.tests.basedir");
        if (path == null) {
            return "";
        }
        if (path.length() > 0 && !path.endsWith(System.getProperty("file.separator"))) {
            path = String.valueOf(path) + System.getProperty("file.separator");
        }
        return path;
    }

    public static String getTestResourcePath() {
        String path = TestResources.getBaseDir();
        if (path == null) {
            return TEST_RESOURCE_DIRECTORY;
        }
        if (path.length() > 0 && !path.endsWith(System.getProperty("file.separator"))) {
            path = String.valueOf(path) + System.getProperty("file.separator");
        }
        return String.valueOf(path) + TEST_RESOURCE_DIRECTORY;
    }

    public static String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    public Connection getConnection() throws NoDatabaseConnectionException {
        Connection connection = null;
        try {
            connection = this.connectionBroker.getConnection();
        }
        catch (SQLException e) {
            throw new NoDatabaseConnectionException(e);
        }
        return connection;
    }

    public void connectToInternalDatabase(boolean createIfNonExistant) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoDatabaseConnectionException {
        String databaseDriver = "org.apache.derby.jdbc.EmbeddedDriver";
        String databaseLocation = createIfNonExistant ? "jdbc:derby:" + TestResources.getTestResourcePath() + "test_database;create=true" : "jdbc:derby:" + TestResources.getTestResourcePath() + "test_database";
        this.connectionBroker = new BasicDataSource();
        this.connectionBroker.setMaxActive(50);
        this.connectionBroker.setDriverClassName(databaseDriver);
        this.connectionBroker.setUrl(databaseLocation);
        DerbyDatabaseInitializer initializer = new DerbyDatabaseInitializer(this.connectionBroker.getConnection());
        initializer.performSetup();
    }
}

