/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.upgrade.UpgradeProcessor;
import net.lukemurphey.nsia.upgrade.UpgraderList;

public class UpgraderListTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    private List<UpgradeProcessor> getUpgradeProcessors() {
        UpgradeProcessor p1 = new UpgradeProcessor(1, 0, 0){

            @Override
            public boolean doUpgrade(Application app) {
                return true;
            }
        };
        UpgradeProcessor p2 = new UpgradeProcessor(1, 0, 2){

            @Override
            public boolean doUpgrade(Application app) {
                return true;
            }
        };
        UpgradeProcessor p3 = new UpgradeProcessor(2, 0, 1){

            @Override
            public boolean doUpgrade(Application app) {
                return true;
            }
        };
        UpgradeProcessor p4 = new UpgradeProcessor(2, 2, 1){

            @Override
            public boolean doUpgrade(Application app) {
                return true;
            }
        };
        UpgradeProcessor p5 = new UpgradeProcessor(3, 0, 0){

            @Override
            public boolean doUpgrade(Application app) {
                return true;
            }
        };
        UpgradeProcessor p6 = new UpgradeProcessor(){

            @Override
            public boolean doUpgrade(Application app) {
                return true;
            }
        };
        ArrayList<UpgradeProcessor> list = new ArrayList<UpgradeProcessor>();
        list.add(p3);
        list.add(p4);
        list.add(p2);
        list.add(p1);
        list.add(p5);
        list.add(p6);
        return list;
    }

    public void testUpgraderListFilter() {
        UpgraderList upgraderList = new UpgraderList();
        List<UpgradeProcessor> list = this.getUpgradeProcessors();
        for (UpgradeProcessor upgradeProcessor : list) {
            upgraderList.add(upgradeProcessor);
        }
        if (upgraderList.getList(2, 0, 1).size() != 3) {
            UpgraderListTest.fail((String)"Incorrect number of upgraders were returned when filtering the list");
        }
    }

    public void testUpgraderListAdd() {
        UpgraderList upgraderList = new UpgraderList();
        List<UpgradeProcessor> list = this.getUpgradeProcessors();
        for (UpgradeProcessor upgradeProcessor : list) {
            upgraderList.add(upgradeProcessor);
        }
        if (list.size() != upgraderList.getList().size()) {
            UpgraderListTest.fail((String)"Not all upgraders were added to the list");
        }
    }
}

