/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tests;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import junit.framework.TestCase;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.Authentication;
import net.lukemurphey.nsia.ClientData;
import net.lukemurphey.nsia.EmailAddress;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InvalidLocalPartException;
import net.lukemurphey.nsia.LocalPasswordAuthentication;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.NumericalOverflowException;
import net.lukemurphey.nsia.PasswordAuthenticationValidator;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.tests.TestApplication;
import net.lukemurphey.nsia.tests.TestApplicationException;

public class UserManagementTest
extends TestCase {
    UserManagement userManagement;
    Application app = null;

    public void setUp() throws TestApplicationException {
        this.app = TestApplication.getApplication();
        this.userManagement = new UserManagement(this.app);
    }

    public void tearDown() {
        TestApplication.stopApplication();
    }

    public void testGetUserDescriptorLong() throws SQLException, NoDatabaseConnectionException, NotFoundException {
        UserManagement.UserDescriptor userDesc = this.userManagement.getUserDescriptor(1);
        if (userDesc == null) {
            UserManagementTest.fail((String)"The user was not found");
        }
    }

    public void testGetUserDescriptorString() throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException {
        UserManagement.UserDescriptor userDesc = this.userManagement.getUserDescriptor("Test");
        if (userDesc == null) {
            UserManagementTest.fail((String)"The user was not found using case sensitive call");
        }
    }

    public void testGetUserDescriptorStringWrongCase() throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException {
        UserManagement.UserDescriptor userDesc = this.userManagement.getUserDescriptor("test");
        if (userDesc == null) {
            UserManagementTest.fail((String)"The user was not found using case insensitive call");
        }
    }

    public void testGetUserId() throws SQLException, InputValidationException, NoDatabaseConnectionException {
        long userId = this.userManagement.getUserID("Test");
        if (userId == -1L) {
            UserManagementTest.fail((String)"The user was not found");
        }
    }

    public void testDisableAccount() throws SQLException, NoDatabaseConnectionException, InputValidationException, NotFoundException {
        UserManagement.UserDescriptor userDesc;
        if (!this.userManagement.disableAccount(1)) {
            UserManagementTest.fail((String)"The account could not be disabled");
        }
        if ((userDesc = this.userManagement.getUserDescriptor(1)).getAccountStatus() != UserManagement.AccountStatus.DISABLED) {
            UserManagementTest.fail((String)"Account was not disabled");
        }
        if (!this.userManagement.enableAccount(1L)) {
            UserManagementTest.fail((String)"The account could not be re-enabled");
        }
        if ((userDesc = this.userManagement.getUserDescriptor(1)).getAccountStatus() != UserManagement.AccountStatus.VALID_USER) {
            UserManagementTest.fail((String)"Account was not re-enabled");
        }
    }

    public void testAddAccount() throws NoSuchAlgorithmException, UnknownHostException, SQLException, InputValidationException, NoDatabaseConnectionException, InvalidLocalPartException, NotFoundException {
        int userID = this.userManagement.addAccount("testAddAccount", "testAddAccount", "^&89dsd879uaidst67", EmailAddress.getByAddress("test@whatever.com"), false);
        if (this.userManagement.getUserDescriptor(userID) == null) {
            UserManagementTest.fail((String)"User account was not successfully created");
        }
    }

    public void testAddAccountIdentical() throws NoSuchAlgorithmException, UnknownHostException, SQLException, InputValidationException, NoDatabaseConnectionException, InvalidLocalPartException, NotFoundException {
        int secondUserID;
        int userID = this.userManagement.addAccount("someUser", "someUser", "^&89dsd879uaidst67", EmailAddress.getByAddress("test@whatever.com"), false);
        if (this.userManagement.getUserDescriptor(userID) == null) {
            UserManagementTest.fail((String)"User account was not successfully created");
        }
        if ((secondUserID = this.userManagement.addAccount("someUser", "someUser", "^&89dsd879uaidst67", EmailAddress.getByAddress("test@whatever.com"), false)) >= 0) {
            UserManagementTest.fail((String)"Account with same user name was allowed to be created");
        }
    }

    public void testAddAccountIdenticalDiffCase() throws NoSuchAlgorithmException, UnknownHostException, SQLException, InputValidationException, NoDatabaseConnectionException, InvalidLocalPartException, NotFoundException {
        int secondUserID;
        int userID = this.userManagement.addAccount("someUser", "someUser", "^&89dsd879uaidst67", EmailAddress.getByAddress("test@whatever.com"), false);
        if (this.userManagement.getUserDescriptor(userID) == null) {
            UserManagementTest.fail((String)"User account was not successfully created");
        }
        if ((secondUserID = this.userManagement.addAccount("SomEUser", "someUser", "^&89dsd879uaidst67", EmailAddress.getByAddress("test@whatever.com"), false)) >= 0) {
            UserManagementTest.fail((String)"Account with same user name was allowed to be created with different case in filename");
        }
    }

    public void testChangePassword() throws NoSuchAlgorithmException, UnknownHostException, SQLException, InputValidationException, NoDatabaseConnectionException, InvalidLocalPartException, NotFoundException, NumericalOverflowException {
        int userID = this.userManagement.addAccount("someUser", "someUser", "^&89dsd879uaidst67", EmailAddress.getByAddress("test@whatever.com"), false);
        if (this.userManagement.getUserDescriptor(userID) == null) {
            UserManagementTest.fail((String)"User account was not successfully created");
        }
        this.userManagement.changePassword(userID, "opensesame");
        PasswordAuthenticationValidator validator = new PasswordAuthenticationValidator("opensesame");
        ClientData clientData = new ClientData(InetAddress.getLocalHost(), "Eclipse Test JUnit Case");
        LocalPasswordAuthentication localPwd = new LocalPasswordAuthentication(this.app);
        Authentication.AuthenticationResult authResult = localPwd.authenticate("someUser", validator, clientData);
        if (authResult.getAuthenticationStatus() != 0) {
            UserManagementTest.fail((String)"The authentication failed for the user after changing the password");
        }
    }

    public void testUpdateUserInfo() throws NoSuchAlgorithmException, UnknownHostException, SQLException, InputValidationException, NoDatabaseConnectionException, InvalidLocalPartException, NotFoundException {
        UserManagement.UserDescriptor user;
        String newFullName;
        int userID = this.userManagement.addAccount("someUser", "someUser", "^&89dsd879uaidst67", EmailAddress.getByAddress("test@whatever.com"), false);
        if (this.userManagement.getUserDescriptor(userID) == null) {
            UserManagementTest.fail((String)"User account was not successfully created");
        }
        if (!this.userManagement.updateAccount(userID, "someUser", newFullName = "someUser Changed", EmailAddress.getByAddress("test@whatever.com"))) {
            UserManagementTest.fail((String)"User account was not successfully changed (updateAccount returned false)");
        }
        if (!(user = this.userManagement.getUserDescriptor(userID)).getFullname().equals(newFullName)) {
            UserManagementTest.fail((String)"User account was not successfully changed (fullname is not the correct value)");
        }
    }
}

