/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.tools;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NetworkManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class AppLaunch {
    private Button actionButton;
    private ProgressBar progressBar;
    private Link mainText;
    private Label mainImageLabel;
    private Label sectionLabel;
    private Display display;
    private Shell shell;
    private DialogState state = DialogState.NSIA_READY;
    protected boolean exitWhenDone = false;
    protected boolean trayIconMessageShown = false;
    protected TrayIcon trayIcon;

    protected org.eclipse.swt.graphics.Image getImage(String name) {
        return new org.eclipse.swt.graphics.Image((Device)this.display, this.getClass().getResourceAsStream(name));
    }

    protected Image getAWTImage(String name) {
        try {
            return ImageIO.read(this.getClass().getResourceAsStream(name));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void open() {
        this.display = new Display();
        this.shell = new Shell(this.display, 128);
        this.shell.setSize(444, 333);
        this.shell.setMinimumSize(444, 333);
        this.shell.setText("ThreatFactor NSIA (version " + Application.getVersion() + ")");
        org.eclipse.swt.graphics.Image appIcon = this.getImage("appicon.png");
        this.shell.setImage(appIcon);
        Label headerImageLabel = new Label((Composite)this.shell, 0);
        org.eclipse.swt.graphics.Image bannerImage = this.getImage("ThreatFactor.png");
        headerImageLabel.setImage(bannerImage);
        headerImageLabel.setLocation(0, 0);
        headerImageLabel.setSize(444, 60);
        this.trayIcon = new TrayIcon(this.getAWTImage("appicon.png"));
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AppLaunch.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AppLaunch.this.shell.setVisible(true);
                        AppLaunch.this.shell.setMinimized(false);
                    }
                });
                SystemTray.getSystemTray().remove(AppLaunch.this.trayIcon);
            }
        };
        this.trayIcon.addMouseListener(mouseListener);
        Button hideButton = new Button((Composite)this.shell, 0);
        hideButton.setLocation(370, 275);
        hideButton.setSize(64, 22);
        hideButton.setText("Hide");
        hideButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    SystemTray.getSystemTray().add(AppLaunch.this.trayIcon);
                    if (!AppLaunch.this.trayIconMessageShown) {
                        AppLaunch.this.trayIcon.displayMessage("NSIA Is Minimized", "I'm still running; click the tray icon to show the dialog again", TrayIcon.MessageType.INFO);
                        AppLaunch.this.trayIcon.setToolTip("I'm still running; click the tray icon to show the dialog again");
                        AppLaunch.this.trayIconMessageShown = true;
                    }
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
                AppLaunch.this.trayIconMessageShown = true;
                AppLaunch.this.shell.setMinimized(true);
                AppLaunch.this.shell.setVisible(false);
            }
        });
        Link link = new Link((Composite)this.shell, 0);
        link.setText("<a href=\"http://ThreatFactor.com\">http://ThreatFactor.com</a>");
        link.setSize(200, 22);
        link.setLocation(20, 275);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AppLaunch.threatFactorLink(event);
            }
        });
        Label separator = new Label((Composite)this.shell, 258);
        separator.setSize(444, 22);
        separator.setLocation(0, 250);
        this.actionButton = new Button((Composite)this.shell, 0);
        this.actionButton.setLocation(100, 180);
        this.actionButton.setSize(128, 22);
        this.actionButton.setText("Start NSIA");
        this.actionButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AppLaunch.this.runAction(event);
            }
        });
        this.mainImageLabel = new Label((Composite)this.shell, 0);
        org.eclipse.swt.graphics.Image dialogImage = this.getImage("Information.png");
        this.mainImageLabel.setImage(dialogImage);
        this.mainImageLabel.setLocation(60, 110);
        this.mainImageLabel.setSize(40, 40);
        this.sectionLabel = new Label((Composite)this.shell, 0);
        this.sectionLabel.setFont(new Font((Device)this.display, "Tahoma", 10, 1));
        this.sectionLabel.setSize(300, 17);
        this.sectionLabel.setLocation(100, 110);
        this.mainText = new Link((Composite)this.shell, 64);
        this.mainText.setSize(310, 40);
        this.mainText.setLocation(100, 130);
        this.mainText.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AppLaunch.adminInterfaceLink(event);
            }
        });
        this.progressBar = new ProgressBar((Composite)this.shell, 2);
        this.progressBar.setLocation(100, 180);
        this.progressBar.setSize(256, 16);
        this.progressBar.setVisible(false);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (AppLaunch.this.state == DialogState.NSIA_RUNNING) {
                    int style = 65732;
                    MessageBox messageBox = new MessageBox(AppLaunch.this.shell, style);
                    messageBox.setText("Close NSIA");
                    messageBox.setMessage("Are you sure you want to close NSIA? Closing this window will also shutdown the NSIA IDS.");
                    if (messageBox.open() == 64) {
                        AppLaunch.this.exitWhenDone = true;
                        AppLaunch.this.runAction(null);
                    }
                    event.doit = false;
                } else if (AppLaunch.this.state == DialogState.NSIA_TERMINATING || AppLaunch.this.state == DialogState.NSIA_STARTING) {
                    event.doit = false;
                } else {
                    System.exit(0);
                }
            }
        });
        this.setDialog(DialogState.NSIA_READY);
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    public void setDialog(DialogState state) {
        this.state = state;
        if (state == DialogState.NSIA_READY) {
            this.setDialog("ThreatFactor NSIA is Not Running", "NSIA is not currently running. Start the system to open the management interface and begin monitoring.", Icon.INFORMATION, false, "Start NSIA");
        } else if (state == DialogState.NSIA_RUNNING) {
            this.setDialog("ThreatFactor NSIA is Running", "NSIA is currently running. Browse to <a>" + AppLaunch.getURL() + "</a> to access the management interface.", Icon.OK, false, "Shutdown NSIA");
        } else if (state == DialogState.NSIA_STARTING) {
            this.setDialog("ThreatFactor NSIA is Starting", "NSIA has been given the start command. Please wait while the system initializes.", Icon.INFORMATION, true, null);
        } else if (state == DialogState.NSIA_TERMINATING) {
            this.setDialog("ThreatFactor NSIA is Terminating", "NSIA has been given the stop command. Please wait while the system terminates.", Icon.INFORMATION, true, null);
        }
    }

    private String stripHTML(String msg) {
        Pattern pattern = Pattern.compile("</?[a-zA-Z0-9]>");
        Matcher matcher = pattern.matcher(msg);
        return matcher.replaceAll("");
    }

    public void setDialog(String title, String message, Icon icon, boolean showProgressBar, String actionButtonText) {
        this.sectionLabel.setText(title);
        this.mainText.setText(message);
        this.trayIcon.displayMessage(title, this.stripHTML(message), TrayIcon.MessageType.INFO);
        this.trayIcon.setToolTip(this.stripHTML(message));
        if (icon == Icon.WARNING) {
            this.mainImageLabel.setVisible(true);
            org.eclipse.swt.graphics.Image dialogImage = this.getImage("Warning.png");
            this.mainImageLabel.setImage(dialogImage);
        } else if (icon == Icon.OK) {
            this.mainImageLabel.setVisible(true);
            org.eclipse.swt.graphics.Image dialogImage = this.getImage("Check.png");
            this.mainImageLabel.setImage(dialogImage);
        } else if (icon == Icon.NONE) {
            this.mainImageLabel.setVisible(false);
        } else {
            this.mainImageLabel.setVisible(true);
            org.eclipse.swt.graphics.Image dialogImage = this.getImage("Information.png");
            this.mainImageLabel.setImage(dialogImage);
        }
        if (showProgressBar) {
            this.progressBar.setVisible(true);
        } else {
            this.progressBar.setVisible(false);
        }
        if (actionButtonText == null) {
            this.actionButton.setVisible(false);
        } else {
            this.actionButton.setVisible(true);
            this.actionButton.setText(actionButtonText);
        }
    }

    public static void main(String[] args) {
        AppLaunch launch = new AppLaunch();
        launch.open();
    }

    public void runAction(Event event) {
        if (this.state == DialogState.NSIA_READY) {
            this.setDialog(DialogState.NSIA_STARTING);
            AppLaunch appLaunch = this;
            appLaunch.getClass();
            ActionWorker worker = appLaunch.new ActionWorker(Action.START);
            worker.start();
        } else if (this.state == DialogState.NSIA_RUNNING) {
            this.setDialog(DialogState.NSIA_TERMINATING);
            AppLaunch appLaunch = this;
            appLaunch.getClass();
            ActionWorker worker = appLaunch.new ActionWorker(Action.SHUTDOWN);
            worker.start();
        }
    }

    public static String getURL() {
        String link = null;
        Application app = Application.getApplication();
        if (app != null) {
            NetworkManager netManager = app.getNetworkManager();
            boolean ssl = false;
            if (netManager != null) {
                ssl = netManager.sslEnabled();
                int port = netManager.getServerPort();
                if (ssl && port == 443) {
                    link = "https://127.0.0.1";
                } else if (ssl) {
                    link = "https://127.0.0.1:" + port;
                }
                link = !ssl && port == 80 ? "https://127.0.0.1" : "http://127.0.0.1:" + port;
            }
        }
        return link;
    }

    public static void adminInterfaceLink(Event event) {
        String link = AppLaunch.getURL();
        Program program = Program.findProgram((String)"html");
        program.execute(link);
    }

    public static void threatFactorLink(Event event) {
        Program program = Program.findProgram((String)"html");
        program.execute("http://ThreatFactor.com");
    }

    protected static enum Action {
        START,
        SHUTDOWN;

    }

    protected class ActionWorker
    extends Thread {
        private Action action;

        public ActionWorker(Action action) {
            this.action = action;
        }

        @Override
        public void run() {
            if (this.action == Action.START) {
                try {
                    Application.startApplication(new String[0], Application.RunMode.GUI);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AppLaunch.this.setDialog(DialogState.NSIA_RUNNING);
                    }
                });
                CheckStatusThread checkStat = new CheckStatusThread();
                checkStat.setName("NSIA Status Monitor");
                checkStat.start();
            } else if (this.action == Action.SHUTDOWN) {
                Application.getApplication().shutdown();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AppLaunch.this.setDialog(DialogState.NSIA_READY);
                    }
                });
                if (AppLaunch.this.exitWhenDone) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AppLaunch.this.display.dispose();
                        }
                    });
                    System.exit(0);
                }
            }
        }
    }

    protected class CheckStatusThread
    extends Thread {
        protected CheckStatusThread() {
        }

        @Override
        public void run() {
            boolean continueExecuting = true;
            while (continueExecuting) {
                try {
                    CheckStatusThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Application app = Application.getApplication();
                if (AppLaunch.this.state != DialogState.NSIA_RUNNING || app != null) continue;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AppLaunch.this.setDialog(DialogState.NSIA_READY);
                    }
                });
                continueExecuting = false;
            }
        }
    }

    protected static enum DialogState {
        NSIA_READY,
        NSIA_STARTING,
        NSIA_RUNNING,
        NSIA_TERMINATING;

    }

    protected static enum Icon {
        OK,
        WARNING,
        INFORMATION,
        NONE;

    }
}

