/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.sql.SQLException;
import net.lukemurphey.nsia.AccessControlDescriptor;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.ObjectPermissionDescriptor;
import net.lukemurphey.nsia.RightDescriptor;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.SessionStatus;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;

public class ApiAccessControl
extends ApiHandler {
    public ApiAccessControl(Application app) {
        super(app);
    }

    public ObjectPermissionDescriptor getUserPermissions(String sessionIdentifier, int userId, long objectId, boolean resolveUserGroupPermissions) throws GeneralizedException, NoSessionException, InsufficientPermissionException {
        SessionStatus sessionStatus = null;
        SessionManagement.SessionInfo sessionInfo = null;
        try {
            sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
            if (sessionInfo == null) {
                throw new NoSessionException(SessionStatus.SESSION_NULL);
            }
            sessionStatus = sessionInfo.getSessionStatus();
        }
        catch (InputValidationException e1) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e1);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e1);
            throw new GeneralizedException();
        }
        if (sessionStatus != SessionStatus.SESSION_ACTIVE) {
            throw new NoSessionException(sessionStatus);
        }
        if (sessionInfo.getUserId() != userId) {
            this.checkRead(sessionIdentifier, objectId, "Get permissions for user " + userId + " relative to object ID " + objectId);
        }
        try {
            return this.accessControl.getUserPermissions(userId, objectId, resolveUserGroupPermissions);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ObjectPermissionDescriptor getGroupPermissions(String sessionIdentifier, int groupId, long objectId) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRead(sessionIdentifier, objectId, "Get group permissions for group " + groupId + " against object ID " + objectId);
        try {
            return this.accessControl.getGroupPermissions(groupId, objectId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public long setPermissions(String sessionIdentifier, ObjectPermissionDescriptor objectPermissionDescriptor) throws GeneralizedException, NoSessionException, InsufficientPermissionException {
        if (objectPermissionDescriptor == null) {
            return -1L;
        }
        this.checkControl(sessionIdentifier, objectPermissionDescriptor.getObjectId(), "Set ACL");
        try {
            long id = this.accessControl.setPermissions(objectPermissionDescriptor);
            if (id >= 0L) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_SET, new EventLogField(EventLogField.FieldName.OBJECT_ID, id));
            } else {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_SET_FAILED);
            }
            return id;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean deleteUserPermissions(String sessionIdentifier, long userId, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        block4: {
            this.checkControl(sessionIdentifier, objectId, "Remove permissions for user " + userId);
            if (!this.accessControl.deleteUserPermissions(userId, objectId)) break block4;
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET, new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET_FAILED, new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean deleteGroupPermissions(String sessionIdentifier, long groupId, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        block4: {
            this.checkControl(sessionIdentifier, objectId, "Remove permissions for group " + groupId);
            if (!this.accessControl.deleteGroupPermissions(groupId, objectId)) break block4;
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET, new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.GROUP_ID, groupId));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET_FAILED, new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.GROUP_ID, groupId));
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean deleteGroupRight(String sessionIdentifier, long groupId, String rightName) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        block4: {
            this.checkRight(sessionIdentifier, "Users.Rights.Edit");
            if (!this.accessControl.deleteGroupRight(groupId, rightName)) break block4;
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET, new EventLogField(EventLogField.FieldName.RIGHT, rightName), new EventLogField(EventLogField.FieldName.GROUP_ID, groupId));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET_FAILED, new EventLogField(EventLogField.FieldName.RIGHT, rightName), new EventLogField(EventLogField.FieldName.GROUP_ID, groupId));
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean deleteUserRight(String sessionIdentifier, long userId, String rightName) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        block4: {
            this.checkRight(sessionIdentifier, "Users.Rights.Edit");
            if (!this.accessControl.deleteUserRight(userId, rightName)) break block4;
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET, new EventLogField(EventLogField.FieldName.RIGHT, rightName), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET_FAILED, new EventLogField(EventLogField.FieldName.RIGHT, rightName), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean setRight(String sessionIdentifier, RightDescriptor rightDescriptor) throws NoSessionException, GeneralizedException {
        SessionStatus sessionStatus = null;
        SessionManagement.SessionInfo sessionInfo = null;
        try {
            sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
            if (sessionInfo == null) {
                throw new NoSessionException(SessionStatus.SESSION_NULL);
            }
            sessionStatus = sessionInfo.getSessionStatus();
        }
        catch (InputValidationException e1) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e1);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e1);
            throw new GeneralizedException();
        }
        if (sessionStatus != SessionStatus.SESSION_ACTIVE) {
            throw new NoSessionException(sessionStatus);
        }
        if (sessionInfo.getUserId() == rightDescriptor.getSubjectId()) {
            rightDescriptor.getSubjectType();
        }
        try {
            if (this.accessControl.setRight(rightDescriptor)) {
                String allowed = rightDescriptor.getRight() == AccessControlDescriptor.Action.DENY ? "deny" : "allow";
                if (rightDescriptor.getSubjectType() == AccessControlDescriptor.Subject.USER) {
                    this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_SET, new EventLogField(EventLogField.FieldName.RIGHT, rightDescriptor.getRightName()), new EventLogField(EventLogField.FieldName.VALUE, allowed), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, sessionInfo.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, rightDescriptor.getSubjectId()));
                } else {
                    this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_SET, new EventLogField(EventLogField.FieldName.RIGHT, rightDescriptor.getRightName()), new EventLogField(EventLogField.FieldName.VALUE, allowed), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, sessionInfo.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.GROUP_ID, rightDescriptor.getSubjectId()));
                }
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public RightDescriptor[] getUserRights(String sessionIdentifier, int userId, boolean resolveUserGroupPermissions) throws GeneralizedException, NoSessionException, InsufficientPermissionException {
        SessionStatus sessionStatus = null;
        SessionManagement.SessionInfo sessionInfo = null;
        try {
            sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
            if (sessionInfo == null) {
                throw new NoSessionException(SessionStatus.SESSION_NULL);
            }
            sessionStatus = sessionInfo.getSessionStatus();
        }
        catch (InputValidationException e1) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e1);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e1);
            throw new GeneralizedException();
        }
        if (sessionStatus != SessionStatus.SESSION_ACTIVE) {
            throw new NoSessionException(sessionStatus);
        }
        if (sessionInfo.getUserId() != userId) {
            this.checkRight(sessionIdentifier, "Users.Rights.View");
        }
        try {
            return this.accessControl.getUserRights(userId, resolveUserGroupPermissions);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public RightDescriptor getUserRight(String sessionIdentifier, int userId, String right, boolean resolveUserGroupPermissions) throws GeneralizedException, NoSessionException, InsufficientPermissionException, NotFoundException {
        SessionStatus sessionStatus = null;
        SessionManagement.SessionInfo sessionInfo = null;
        try {
            sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
            if (sessionInfo == null) {
                throw new NoSessionException(SessionStatus.SESSION_NULL);
            }
            sessionStatus = sessionInfo.getSessionStatus();
        }
        catch (InputValidationException e1) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e1);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e1);
            throw new GeneralizedException();
        }
        if (sessionStatus != SessionStatus.SESSION_ACTIVE) {
            throw new NoSessionException(sessionStatus);
        }
        if (sessionInfo.getUserId() != userId) {
            this.checkRight(sessionIdentifier, "Users.Rights.View");
        }
        try {
            return this.accessControl.getUserRight(userId, right, resolveUserGroupPermissions);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public RightDescriptor getGroupRight(String sessionIdentifier, int groupId, String right) throws GeneralizedException, InsufficientPermissionException, NoSessionException, NotFoundException {
        this.checkRight(sessionIdentifier, "Users.Rights.View");
        try {
            return this.accessControl.getGroupRight(groupId, right);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean setPermissions(String sessionIdentifier, RightDescriptor rightDescriptor) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        block9: {
            if (rightDescriptor == null) {
                return false;
            }
            this.checkRight(sessionIdentifier, rightDescriptor.getRightName());
            if (!this.accessControl.setPermissions(rightDescriptor)) break block9;
            if (rightDescriptor.isUser()) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET, new EventLogField(EventLogField.FieldName.RIGHT, rightDescriptor.getRightName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, rightDescriptor.getSubjectId()));
            } else {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET, new EventLogField(EventLogField.FieldName.RIGHT, rightDescriptor.getRightName()), new EventLogField(EventLogField.FieldName.GROUP_ID, rightDescriptor.getSubjectId()));
            }
            return true;
        }
        try {
            if (rightDescriptor.isUser()) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET_FAILED, new EventLogField(EventLogField.FieldName.RIGHT, rightDescriptor.getRightName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, rightDescriptor.getSubjectId()));
            } else {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_UNSET_FAILED, new EventLogField(EventLogField.FieldName.RIGHT, rightDescriptor.getRightName()), new EventLogField(EventLogField.FieldName.GROUP_ID, rightDescriptor.getSubjectId()));
            }
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ObjectPermissionDescriptor[] getAllAclEntries(String sessionIdentifier, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkControl(sessionIdentifier, objectId, "Retrieve ACLs");
        try {
            return this.accessControl.getAllAclEntries(objectId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }
}

