/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.sql.SQLException;
import java.util.Date;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DefinitionUpdateWorker;
import net.lukemurphey.nsia.DisallowedOperationException;
import net.lukemurphey.nsia.DuplicateEntryException;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionArchive;
import net.lukemurphey.nsia.scan.DefinitionArchiveException;
import net.lukemurphey.nsia.scan.DefinitionSet;
import net.lukemurphey.nsia.scan.DefinitionSetLoadException;
import net.lukemurphey.nsia.scan.DefinitionUpdateFailedException;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;

public class ApiDefinitionSet
extends ApiHandler {
    DefinitionArchive archive = null;

    public ApiDefinitionSet(Application appRes) throws GeneralizedException {
        super(appRes);
        try {
            this.archive = DefinitionArchive.getArchive();
        }
        catch (NoDatabaseConnectionException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (DefinitionSetLoadException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ApiDefinitionSet(Application appRes, boolean ignoreLoadErrors) throws GeneralizedException {
        super(appRes);
        try {
            this.archive = DefinitionArchive.getArchive(ignoreLoadErrors);
        }
        catch (NoDatabaseConnectionException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (DefinitionSetLoadException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public Definition[] getSortedDefinitions(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        return this.archive.getDefinitionsSorted();
    }

    public DefinitionSet.DefinitionCategory[] getSubCategories(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        return this.archive.getDefinitionSet().getListOfSubCategories();
    }

    public String[] getCategories(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        return this.archive.getDefinitionSet().getListOfCategories();
    }

    public int getNextOpenID(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        return this.archive.getNextOpenID(false);
    }

    public int getNextOpenID(String sessionIdentifier, boolean returnNextOfficial) throws GeneralizedException, NoSessionException {
        return this.archive.getNextOpenID(returnNextOfficial);
    }

    public Definition[] getDefinitions(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        return this.archive.getDefinitions();
    }

    public Definition getDefinition(String sessionIdentifier, int definitionID) throws InsufficientPermissionException, GeneralizedException, NoSessionException, NotFoundException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        return this.archive.getDefinitionByLocalID(definitionID);
    }

    public Definition getDefinition(String sessionIdentifier, String definitionName) throws InsufficientPermissionException, GeneralizedException, NoSessionException, NotFoundException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        return this.archive.getDefinition(definitionName);
    }

    public void updateDefinition(String sessionIdentifier, Definition definition, int definitionID) throws InsufficientPermissionException, GeneralizedException, NoSessionException, DisallowedOperationException {
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            this.archive.updateDefinition(definition, definitionID);
            this.appRes.logEvent(EventLogMessage.EventType.DEFINITION_MODIFIED, new EventLogField(EventLogField.FieldName.DEFINITION_ID, definitionID), new EventLogField(EventLogField.FieldName.DEFINITION_NAME, definition.getFullName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (DisallowedOperationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.MESSAGE, e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.OPERATION_FAILED, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public void addDefinition(String sessionIdentifier, Definition definition) throws InsufficientPermissionException, GeneralizedException, NoSessionException, DisallowedOperationException, DuplicateEntryException {
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            int definitionID = this.archive.addDefinition(definition);
            this.appRes.logEvent(EventLogMessage.EventType.DEFINITION_ADDED, new EventLogField(EventLogField.FieldName.DEFINITION_ID, definitionID), new EventLogField(EventLogField.FieldName.DEFINITION_NAME, definition.getFullName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (DisallowedOperationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.MESSAGE, e.getMessage()));
            throw e;
        }
        catch (DuplicateEntryException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.OPERATION_FAILED, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.OPERATION_FAILED, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public void removeDefinition(String sessionIdentifier, int definitionID) throws InsufficientPermissionException, GeneralizedException, NoSessionException, DisallowedOperationException {
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            this.archive.removeByID(definitionID);
            this.appRes.logEvent(EventLogMessage.EventType.DEFINITION_DELETED, new EventLogField(EventLogField.FieldName.DEFINITION_ID, definitionID), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (DisallowedOperationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.MESSAGE, e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.OPERATION_FAILED, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public DefinitionSet.DefinitionVersionID getLatestAvailableDefinitionSetID(String sessionIdentifier) throws GeneralizedException {
        try {
            return DefinitionArchive.getLatestAvailableDefinitionSetID();
        }
        catch (Exception e) {
            Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), e);
            throw new GeneralizedException(e);
        }
    }

    public void updateDefinitionsAsWorker(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException, DuplicateEntryException {
        this.updateDefinitionsAsWorker(sessionIdentifier, false);
    }

    public void updateDefinitionsAsWorker(String sessionIdentifier, boolean force) throws InsufficientPermissionException, GeneralizedException, NoSessionException, DuplicateEntryException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        DefinitionUpdateWorker worker = new DefinitionUpdateWorker(force);
        int userId = -1;
        try {
            SessionManagement.SessionInfo info = this.sessionManagement.getSessionInfo(sessionIdentifier);
            if (info == null) {
                throw new GeneralizedException();
            }
            userId = info.getUserId();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), (Throwable)e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), (Throwable)e);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR), (Throwable)e);
        }
        if (userId > -1) {
            this.appRes.addWorkerToQueue(worker, "Definitions Update (unscheduled)", userId);
            new Thread(worker).start();
        }
    }

    public DefinitionSet.DefinitionVersionID updateDefinitions(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException, DefinitionUpdateFailedException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        return this.archive.updateDefinitions();
    }

    public boolean areNewDefinitionsAvailable(String sessionIdentifier) {
        return this.archive.isNewDefinitionSetAvailable();
    }

    public DefinitionSet.DefinitionVersionID getDefinitionSetVersionID(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        return this.archive.getVersionID();
    }

    public int getCustomDefinitionsCount(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        return this.archive.getCustomDefinitionsCount();
    }

    public Date getDefinitionSetDate(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        return this.archive.getDefinitionSetDate();
    }

    public String exportDefinitions(String sessionIdentifier, boolean includeCustomDefinitionsOnly) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        this.appRes.logEvent(EventLogMessage.EventType.DEFINITIONS_EXPORTED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
        return this.archive.getAsXML(includeCustomDefinitionsOnly);
    }

    public String exportDefinitions(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        this.appRes.logEvent(EventLogMessage.EventType.DEFINITIONS_EXPORTED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
        return this.archive.getAsXML();
    }

    public void importDefinitions(String sessionIdentifier, String xmlString, boolean replaceOfficialOnly) throws InsufficientPermissionException, GeneralizedException, NoSessionException, DefinitionSetLoadException, DefinitionArchiveException {
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        try {
            this.archive.updateDefinitions(xmlString, replaceOfficialOnly);
            this.appRes.logEvent(EventLogMessage.EventType.DEFINITION_SET_UPDATED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.IMPORT_SOURCE, "Local file"));
        }
        catch (DefinitionArchiveException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw e;
        }
    }
}

