/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.MaxMinCount;
import net.lukemurphey.nsia.NameIntPair;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.SiteGroupScanResult;
import net.lukemurphey.nsia.Wildcard;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionMatch;
import net.lukemurphey.nsia.scan.HttpDefinitionScanResult;
import net.lukemurphey.nsia.scan.HttpHeaderRule;
import net.lukemurphey.nsia.scan.HttpSeekingScanResult;
import net.lukemurphey.nsia.scan.HttpSeekingScanRule;
import net.lukemurphey.nsia.scan.HttpStaticScanRule;
import net.lukemurphey.nsia.scan.NetworkPortRange;
import net.lukemurphey.nsia.scan.RuleBaselineException;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultLoader;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.scan.ScanRuleLoader;
import net.lukemurphey.nsia.scan.ServiceScanRule;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;
import net.lukemurphey.nsia.web.Shortcuts;

public class ApiScanData
extends ApiHandler {
    public ApiScanData(Application appRes) {
        super(appRes);
    }

    public SiteGroupScanResult[] getSiteGroupStatus(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            SiteGroupScanResult[] results = this.scanData.getSiteGroupStatus();
            SessionManagement.SessionInfo sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
            Vector<SiteGroupScanResult> resultsFiltered = new Vector<SiteGroupScanResult>();
            int c = 0;
            while (c < results.length) {
                long objectID = results[c].getSiteGroupDescriptor().getObjectId();
                if (Shortcuts.canRead(sessionInfo, objectID, "Check site-group permissions for main-dashboard", false)) {
                    resultsFiltered.add(results[c]);
                }
                ++c;
            }
            results = new SiteGroupScanResult[resultsFiltered.size()];
            resultsFiltered.toArray(results);
            return results;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (ScanRule.ScanResultLoadFailureException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getAssociatedSiteGroup(String sessionIdentifier, long ruleId) throws GeneralizedException, NoSessionException, InsufficientPermissionException, NotFoundException {
        try {
            int siteGroupID = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor siteGroupDescriptor = this.siteGroupManagement.getGroupDescriptor(siteGroupID);
            this.checkRead(sessionIdentifier, siteGroupDescriptor.getObjectId(), "Get site group associated with scan rule " + ruleId);
            return siteGroupID;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public MaxMinCount getEntryInfo(String sessionIdentifier, long ruleId) throws InsufficientPermissionException, GeneralizedException, NoSessionException, NotFoundException {
        try {
            int siteGroupID = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor siteGroupDesc = this.siteGroupManagement.getGroupDescriptor(siteGroupID);
            this.checkRead(sessionIdentifier, siteGroupDesc.getObjectId(), "Get scan result history for site group \"" + siteGroupDesc.getGroupName() + "\" (" + siteGroupID + ")");
            return ScanResultLoader.getEntryInfo(ruleId);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public long getMaxEntry(String sessionIdentifier, long ruleId) throws GeneralizedException, InsufficientPermissionException, NoSessionException, NotFoundException {
        try {
            int siteGroupID = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor siteGroupDesc = this.siteGroupManagement.getGroupDescriptor(siteGroupID);
            this.checkRead(sessionIdentifier, siteGroupDesc.getObjectId(), "Get maximum scan result identifier for site group \"" + siteGroupDesc.getGroupName() + "\" (" + siteGroupID + ")");
            return ScanResultLoader.getMaxEntry(ruleId);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public long getMinEntry(String sessionIdentifier, long ruleId) throws GeneralizedException, InsufficientPermissionException, NoSessionException, NotFoundException {
        try {
            int siteGroupID = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor siteGroupDesc = this.siteGroupManagement.getGroupDescriptor(siteGroupID);
            this.checkRead(sessionIdentifier, siteGroupDesc.getObjectId(), "Get minimum scan result identifier for site group \"" + siteGroupDesc.getGroupName() + "\" (" + siteGroupID + ")");
            return ScanResultLoader.getMinEntry(ruleId);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ScanResult[] getScanResults(String sessionIdentifier, long firstScanResultID, long ruleId, int count, boolean getResultsAfter) throws NoSessionException, GeneralizedException, InsufficientPermissionException, NotFoundException {
        try {
            int siteGroupID = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor siteGroupDesc = this.siteGroupManagement.getGroupDescriptor(siteGroupID);
            this.checkRead(sessionIdentifier, siteGroupDesc.getObjectId(), "Get scan results for site group \"" + siteGroupDesc.getGroupName() + "\" (" + siteGroupID + ")");
            ScanResult[] results = ScanResultLoader.getScanResults(ruleId, firstScanResultID, count, getResultsAfter);
            return results;
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (ScanRule.ScanResultLoadFailureException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ScanResult[] getScanResults(String sessionIdentifier, long firstScanResultID, long ruleId, int count) throws NoSessionException, GeneralizedException, InsufficientPermissionException, InputValidationException, NotFoundException {
        try {
            int siteGroupID = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor siteGroupDesc = this.siteGroupManagement.getGroupDescriptor(siteGroupID);
            this.checkRead(sessionIdentifier, siteGroupDesc.getObjectId(), "Get scan results for site group \"" + siteGroupDesc.getGroupName() + "\" (" + siteGroupID + ")");
            ScanResult[] results = ScanResultLoader.getScanResults(ruleId, firstScanResultID, count, false);
            return results;
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (ScanRule.ScanResultLoadFailureException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ScanResult[] getScanResults(String sessionIdentifier, long ruleId, int count) throws NoSessionException, GeneralizedException, InsufficientPermissionException, InputValidationException, NotFoundException {
        try {
            int siteGroupID = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor siteGroupDesc = this.siteGroupManagement.getGroupDescriptor(siteGroupID);
            this.checkRead(sessionIdentifier, siteGroupDesc.getObjectId(), "Get scan results for site group \"" + siteGroupDesc.getGroupName() + "\" (" + siteGroupID + ")");
            ScanResult[] results = ScanResultLoader.getScanResults(ruleId, count);
            return results;
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (ScanRule.ScanResultLoadFailureException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ScanRule[] getScanRules(String sessionIdentifier, int siteGroupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException, InputValidationException, NotFoundException {
        try {
            SiteGroupManagement.SiteGroupDescriptor siteGroupDesc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
            this.checkRead(sessionIdentifier, siteGroupDesc.getObjectId(), "Get rules for site group \"" + siteGroupDesc.getGroupName() + "\" (" + siteGroupId + ")");
            ScanRule[] rules = ScanRuleLoader.getScanRules(siteGroupId);
            return rules;
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (ScanRule.ScanRuleLoadFailureException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ScanRule getScanRule(String sessionIdentifier, long scanRuleId) throws NoSessionException, GeneralizedException, NotFoundException, InsufficientPermissionException {
        ScanRule scanRule = null;
        try {
            int siteGroupId = ScanRule.getAssociatedSiteGroupID(scanRuleId);
            SiteGroupManagement.SiteGroupDescriptor siteGroupDescriptor = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
            this.checkRead(sessionIdentifier, siteGroupDescriptor.getObjectId(), "Get scan rule " + scanRuleId + " for site group \"" + siteGroupDescriptor.getGroupName() + "\" (" + siteGroupId + ")");
            scanRule = ScanRuleLoader.getScanRule(scanRuleId);
            if (scanRule == null) {
                return null;
            }
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            Application.getApplication().logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (ScanRule.ScanRuleLoadFailureException e) {
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        return scanRule;
    }

    public SiteGroupScanResult getSiteGroupStatus(String sessionIdentifier, int siteGroupId) throws GeneralizedException, NoSessionException, InsufficientPermissionException, NotFoundException {
        this.checkSession(sessionIdentifier);
        try {
            SiteGroupScanResult scanResult = this.scanData.getSiteGroupStatus(siteGroupId);
            long objectId = scanResult.getSiteGroupDescriptor().getObjectId();
            this.checkRead(sessionIdentifier, objectId, "Get status for site group \"" + scanResult.getSiteGroupDescriptor().getGroupName() + "\" (" + siteGroupId + ")");
            return scanResult;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (ScanRule.ScanResultLoadFailureException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public String getRuleType(String sessionIdentifier, long ruleId) throws NoSessionException, GeneralizedException {
        this.checkSession(sessionIdentifier);
        try {
            return this.scanData.getRuleType(ruleId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public Hashtable<Definition.Severity, Integer> getHTTPDefinitionMatchSeverities(String sessionIdentifier, long resultId) throws NoSessionException, GeneralizedException {
        this.checkSession(sessionIdentifier);
        try {
            return HttpDefinitionScanResult.getSignatureMatchSeverities(resultId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ScanResult getScanResult(String sessionIdentifier, long resultId) throws NoSessionException, GeneralizedException {
        ScanResult scanResult;
        this.checkSession(sessionIdentifier);
        try {
            scanResult = this.scanData.getScanResult(resultId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (ScanRule.ScanResultLoadFailureException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        return scanResult;
    }

    public MaxMinCount getHTTPSeekingResultInfo(String sessionIdentifier, long scanResultID, HttpDefinitionScanResult.SignatureScanResultFilter filter) throws GeneralizedException {
        try {
            return HttpSeekingScanResult.getScanResultInfo(scanResultID, filter, this.appRes);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public Vector<NameIntPair> getHTTPSeekingDefinitionMatches(String sessionIdentifier, long parentScanResultID) throws GeneralizedException, NoSessionException {
        try {
            return HttpDefinitionScanResult.getSignatureMatches(parentScanResultID);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public Vector<NameIntPair> getDiscoveredContentTypes(String sessionIdentifier, long scanResultID) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return HttpSeekingScanResult.getDiscoveredContentTypes(scanResultID);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ScanResult getLastScanResult(String sessionIdentifier, long ruleId) throws NoSessionException, GeneralizedException {
        ScanResult scanResult;
        this.checkSession(sessionIdentifier);
        try {
            scanResult = this.scanData.getLastScanResult(ruleId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (ScanRule.ScanResultLoadFailureException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        if (scanResult == null) {
            return null;
        }
        return scanResult;
    }

    public long addServiceScanRule(String sessionIdentifier, int siteGroupId, String serverAddress, NetworkPortRange[] portsToScan, NetworkPortRange[] portsExpectedOpen, int scanFrequency) throws InsufficientPermissionException, GeneralizedException, NoSessionException, NotFoundException {
        try {
            SiteGroupManagement.SiteGroupDescriptor desc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
            this.checkCreate(sessionIdentifier, desc.getGroupId(), "Add service scan rule to site group \"" + desc.getGroupName() + "\" (" + desc.getGroupId() + ")");
            ServiceScanRule rule = new ServiceScanRule(this.appRes, serverAddress, portsExpectedOpen, portsToScan);
            rule.setScanFrequency(scanFrequency);
            return rule.saveNewRuleToDatabase(siteGroupId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public long updateServiceScanRule(String sessionIdentifier, long scanRuleId, String serverAddress, NetworkPortRange[] portsToScan, NetworkPortRange[] portsExpectedOpen, int scanFrequency) throws InsufficientPermissionException, GeneralizedException, NoSessionException, NotFoundException {
        try {
            int siteGroupId = ScanRule.getAssociatedSiteGroupID(scanRuleId);
            SiteGroupManagement.SiteGroupDescriptor desc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
            this.checkCreate(sessionIdentifier, desc.getGroupId(), "Update service scan rule " + scanRuleId + " for site group \"" + desc.getGroupName() + "\" (" + desc.getGroupId() + ")");
            ServiceScanRule rule = (ServiceScanRule)ScanRuleLoader.getScanRule(scanRuleId);
            rule.setServerAddress(serverAddress);
            rule.setPortsToScan(portsToScan);
            rule.setPortsExpectedOpen(portsExpectedOpen);
            rule.setScanFrequency(scanFrequency);
            return rule.saveToDatabase();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (ScanRule.ScanRuleLoadFailureException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public long addHttpDiscoveryRule(String sessionIdentifier, int siteGroupId, Wildcard restrictToDomain, int recursionDepth, int scanFrequency, URL[] urls, int scanCountLimit) throws GeneralizedException, NotFoundException, InsufficientPermissionException, NoSessionException {
        try {
            SiteGroupManagement.SiteGroupDescriptor desc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
            this.checkCreate(sessionIdentifier, desc.getGroupId(), "Add HTTP auto-discovery rule to site group \"" + desc.getGroupName() + "\" (" + desc.getGroupId() + ")");
            HttpSeekingScanRule rule = new HttpSeekingScanRule(Application.getApplication(), restrictToDomain, scanFrequency, false);
            rule.setScanCountLimit(scanCountLimit);
            rule.addSeedUrls(urls);
            rule.setRecursionDepth(recursionDepth);
            return rule.saveNewRuleToDatabase(siteGroupId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public long updateHttpDiscoveryRule(String sessionIdentifier, long ruleId, Wildcard restrictToDomain, int recursionDepth, int scanFrequency, URL[] urls, int scanCountLimit) throws GeneralizedException, NotFoundException, ScanRule.ScanRuleLoadFailureException, InsufficientPermissionException, NoSessionException {
        try {
            int siteGroupId = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor desc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
            this.checkModify(sessionIdentifier, desc.getGroupId(), "Update HTTP/Auto-Discovery rule " + ruleId);
            HttpSeekingScanRule rule = (HttpSeekingScanRule)ScanRuleLoader.getScanRule(ruleId);
            rule.setScanCountLimit(scanCountLimit);
            rule.setSeedUrls(urls);
            rule.setRecursionDepth(recursionDepth);
            rule.setScanFrequency(scanFrequency);
            rule.setDomainRestriction(restrictToDomain);
            return rule.saveToDatabase();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public long addHttpDataHashRule(String sessionIdentifier, int siteGroupId, int expectedResponseCode, String expectedDataHash, String expectedDataHashAlgorithm, boolean followRedirects, URL specimenUrl, int scanFrequency) throws NoSuchAlgorithmException, GeneralizedException, InputValidationException, NotFoundException, InsufficientPermissionException, NoSessionException {
        try {
            SiteGroupManagement.SiteGroupDescriptor desc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
            this.checkCreate(sessionIdentifier, desc.getGroupId(), "Add static HTTP rule to site group \"" + desc.getGroupName() + "\" (" + desc.getGroupId() + ")");
            HttpStaticScanRule httpScan = new HttpStaticScanRule(Application.getApplication(), expectedResponseCode, expectedDataHash, expectedDataHashAlgorithm, followRedirects, specimenUrl, scanFrequency);
            return httpScan.saveNewRuleToDatabase(siteGroupId);
        }
        catch (IllegalStateException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public void updateHttpDataHashRule(String sessionIdentifier, long ruleId, int expectedResponseCode, String expectedDataHash, String expectedDataHashAlgorithm, boolean followRedirects, URL specimenUrl, int scanFrequency) throws NoSuchAlgorithmException, GeneralizedException, NotFoundException, ScanRule.ScanRuleLoadFailureException, InsufficientPermissionException, NoSessionException {
        try {
            int siteGroupId = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor desc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
            this.checkModify(sessionIdentifier, desc.getGroupId(), "Update HTTP static rule " + ruleId);
            HttpStaticScanRule httpScan = (HttpStaticScanRule)ScanRuleLoader.getScanRule(ruleId);
            httpScan.setExpectedResponseCode(expectedResponseCode);
            httpScan.setExpectedDataHash(expectedDataHashAlgorithm, expectedDataHash);
            httpScan.setFollowRedirects(followRedirects);
            httpScan.setUrl(specimenUrl);
            httpScan.setScanFrequency(scanFrequency);
            httpScan.saveToDatabase(ruleId);
        }
        catch (IllegalStateException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean addHttpHeaderRule(String sessionIdentifier, long ruleId, String headerName, int headerNameType, String headerValue, int headerValueType, int matchAction) throws NoSessionException, GeneralizedException, InputValidationException, NotFoundException, InsufficientPermissionException {
        boolean ruleAddSuccess;
        block26: {
            HttpStaticScanRule scan;
            block25: {
                ruleAddSuccess = false;
                int siteGroupId = ScanRule.getAssociatedSiteGroupID(ruleId);
                SiteGroupManagement.SiteGroupDescriptor desc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
                this.checkModify(sessionIdentifier, desc.getGroupId(), "Add HTTP header rule to rule " + ruleId);
                try {
                    scan = (HttpStaticScanRule)ScanRuleLoader.getScanRule(ruleId);
                }
                catch (Exception e) {
                    throw new GeneralizedException();
                }
                if (scan != null) break block25;
                return false;
            }
            try {
                Pattern finalHeaderName;
                if (headerNameType == 0 && headerValueType == 0) {
                    Pattern finalHeaderValue;
                    try {
                        finalHeaderName = Pattern.compile(headerName);
                    }
                    catch (PatternSyntaxException e) {
                        throw new InputValidationException("The header name is not a valid regular expression", "HeaderName", headerName);
                    }
                    try {
                        finalHeaderValue = Pattern.compile(headerValue);
                    }
                    catch (PatternSyntaxException e) {
                        throw new InputValidationException("The header value is not a valid regular expression", "HeaderValue", headerValue);
                    }
                    ruleAddSuccess = scan.addHeaderRule(new HttpHeaderRule(finalHeaderName, finalHeaderValue, matchAction));
                } else if (headerNameType == 0 && headerValueType == 1) {
                    try {
                        finalHeaderName = Pattern.compile(headerName);
                    }
                    catch (PatternSyntaxException e) {
                        throw new InputValidationException("The header name is not a valid regular expression", "HeaderName", headerName);
                    }
                    ruleAddSuccess = scan.addHeaderRule(new HttpHeaderRule(finalHeaderName, headerValue, matchAction));
                } else if (headerNameType == 1 && headerValueType == 0) {
                    Pattern finalHeaderValue;
                    try {
                        finalHeaderValue = Pattern.compile(headerValue);
                    }
                    catch (PatternSyntaxException e) {
                        throw new InputValidationException("The header value is not a valid regular expression", "HeaderValue", headerValue);
                    }
                    ruleAddSuccess = scan.addHeaderRule(new HttpHeaderRule(headerName, finalHeaderValue, matchAction));
                } else {
                    ruleAddSuccess = scan.addHeaderRule(new HttpHeaderRule(headerName, headerValue, matchAction));
                }
                if (!ruleAddSuccess) break block26;
                try {
                    scan.saveToDatabase();
                }
                catch (IllegalStateException e) {
                    this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
                    throw new GeneralizedException();
                }
                catch (SQLException e) {
                    this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
                    throw new GeneralizedException();
                }
                catch (NoDatabaseConnectionException e) {
                    this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
                    throw new GeneralizedException();
                }
            }
            catch (SQLException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
                throw new GeneralizedException();
            }
            catch (NoDatabaseConnectionException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
                throw new GeneralizedException();
            }
            catch (InputValidationException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
                throw new GeneralizedException();
            }
        }
        return ruleAddSuccess;
    }

    public boolean deleteHttpHeaderRule(String sessionIdentifier, long headerRuleId) throws GeneralizedException, NoSessionException, NotFoundException, ScanRule.ScanRuleLoadFailureException, InsufficientPermissionException {
        try {
            long ruleId = HttpStaticScanRule.resolveRuleId(headerRuleId);
            int siteGroupId = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor desc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
            this.checkModify(sessionIdentifier, desc.getGroupId(), "Delete HTTP header rule for rule " + ruleId);
            HttpStaticScanRule scan = (HttpStaticScanRule)ScanRuleLoader.getScanRule(ruleId);
            boolean removeSuccess = scan.removeHeaderRule(headerRuleId);
            scan.saveToDatabase();
            return removeSuccess;
        }
        catch (SQLException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e1);
            throw new GeneralizedException();
        }
        catch (IllegalStateException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean updateHttpHeaderRule(String sessionIdentifier, long headerRuleId, String headerName, int headerNameType, String headerValue, int headerValueType, int matchAction) throws NoSessionException, GeneralizedException, InputValidationException, NotFoundException, InsufficientPermissionException {
        Pattern finalHeaderName;
        HttpStaticScanRule scan;
        long ruleId;
        try {
            ruleId = HttpStaticScanRule.resolveRuleId(headerRuleId);
            int siteGroupId = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor desc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
            this.checkModify(sessionIdentifier, desc.getGroupId(), "Update HTTP header rule for rule " + ruleId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        try {
            scan = (HttpStaticScanRule)ScanRuleLoader.getScanRule(ruleId);
        }
        catch (Exception e) {
            throw new GeneralizedException();
        }
        if (scan == null) {
            return false;
        }
        boolean ruleUpdateSuccess = false;
        if (headerNameType == 0 && headerValueType == 0) {
            Pattern finalHeaderValue;
            try {
                finalHeaderName = Pattern.compile(headerName);
            }
            catch (PatternSyntaxException e) {
                throw new InputValidationException("The header name is not a valid regular expression", "HeaderName", headerName);
            }
            try {
                finalHeaderValue = Pattern.compile(headerValue);
            }
            catch (PatternSyntaxException e) {
                throw new InputValidationException("The header value is not a valid regular expression", "HeaderValue", headerValue);
            }
            ruleUpdateSuccess = scan.updateHeaderRule(finalHeaderName, finalHeaderValue, matchAction, headerRuleId);
        } else if (headerNameType == 0 && headerValueType == 1) {
            try {
                finalHeaderName = Pattern.compile(headerName);
            }
            catch (PatternSyntaxException e) {
                throw new InputValidationException("The header name is not a valid regular expression", "HeaderName", headerName);
            }
            ruleUpdateSuccess = scan.updateHeaderRule(finalHeaderName, headerValue, matchAction, headerRuleId);
        } else if (headerNameType == 1 && headerValueType == 0) {
            Pattern finalHeaderValue;
            try {
                finalHeaderValue = Pattern.compile(headerValue);
            }
            catch (PatternSyntaxException e) {
                throw new InputValidationException("The header value is not a valid regular expression", "HeaderValue", headerValue);
            }
            ruleUpdateSuccess = scan.updateHeaderRule(headerName, finalHeaderValue, matchAction, headerRuleId);
        } else {
            ruleUpdateSuccess = scan.updateHeaderRule(headerName, headerValue, matchAction, headerRuleId);
        }
        if (ruleUpdateSuccess) {
            try {
                scan.saveToDatabase();
            }
            catch (IllegalStateException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
                throw new GeneralizedException();
            }
            catch (SQLException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
                throw new GeneralizedException();
            }
            catch (NoDatabaseConnectionException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
                throw new GeneralizedException();
            }
        }
        return ruleUpdateSuccess;
    }

    public boolean baselineRule(long ruleID) throws RuleBaselineException {
        try {
            ScanRule rule = ScanRuleLoader.getScanRule(ruleID);
            if (rule instanceof HttpSeekingScanRule) {
                HttpSeekingScanRule httpRule = (HttpSeekingScanRule)rule;
                return httpRule.baseline();
            }
            return false;
        }
        catch (SQLException e) {
            throw new RuleBaselineException("SQL exception occurred while baselining rule", e);
        }
        catch (NotFoundException e) {
            throw new RuleBaselineException("Rule was not found", e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new RuleBaselineException("A database connection could not be established", e);
        }
        catch (ScanRule.ScanRuleLoadFailureException e) {
            throw new RuleBaselineException("Scan result could not be loaded while baselining rule", e);
        }
    }

    public void deleteRule(String sessionIdentifier, long ruleId) throws GeneralizedException, InsufficientPermissionException, NoSessionException, NotFoundException {
        try {
            int siteGroupId = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor desc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
            this.checkModify(sessionIdentifier, desc.getGroupId(), "Delete rule " + ruleId);
            ScanRule rule = ScanRuleLoader.getScanRule(ruleId);
            rule.delete();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (ScanRule.ScanRuleLoadFailureException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public long resolveHttpHeaderRuleId(String sessionIdentifier, long headerRuleId) throws NoSessionException, GeneralizedException, NotFoundException {
        long ruleId;
        this.checkSession(sessionIdentifier);
        try {
            ruleId = HttpStaticScanRule.resolveRuleId(headerRuleId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        return ruleId;
    }

    public DefinitionMatch[] getLastSignaturesMatched(String sessionIdentifier, int count) throws NoSessionException, GeneralizedException {
        this.checkSession(sessionIdentifier);
        try {
            return this.scanData.getLastSignaturesMatched(count);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }
}

