/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.AccessControlDescriptor;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.Authentication;
import net.lukemurphey.nsia.ClientData;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.LocalPasswordAuthentication;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.NumericalOverflowException;
import net.lukemurphey.nsia.PasswordAuthenticationValidator;
import net.lukemurphey.nsia.RightDescriptor;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.SessionStatus;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;

public class ApiSessionManagement
extends ApiHandler {
    public ApiSessionManagement(Application appRes) {
        super(appRes);
    }

    public String authenticate(String userName, String password) throws GeneralizedException {
        return this.authenticate(userName, password, null);
    }

    public String authenticate(String userName, String password, ClientData clientData) throws GeneralizedException {
        Authentication.AuthenticationResult result;
        if (userName == null || userName.length() == 0) {
            if (clientData == null) {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_EMPTY);
            } else {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_EMPTY, new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        Pattern nameRegex = Pattern.compile("[-A-Z0-9a-z_ .]{0,256}");
        Matcher matcher = nameRegex.matcher(userName);
        if (!matcher.matches()) {
            if (clientData == null) {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_EMPTY);
            } else {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_EMPTY, new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            return null;
        }
        if (userName.length() > 32) {
            if (clientData == null) {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_EMPTY);
            } else {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_EMPTY, new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_LENGTH_EXCESSIVE, new EventLogField(EventLogField.FieldName.LENGTH, userName.length()), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            return null;
        }
        LocalPasswordAuthentication localPasswordAuth = new LocalPasswordAuthentication(this.appRes);
        PasswordAuthenticationValidator passwordAuth = new PasswordAuthenticationValidator(password);
        try {
            result = localPasswordAuth.authenticate(userName, passwordAuth, clientData);
        }
        catch (NoSuchAlgorithmException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NumericalOverflowException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        if (result.getAuthenticationStatus() == 5) {
            if (clientData == null) {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_ACCOUNT_DISABLED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            } else {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_ACCOUNT_DISABLED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        if (result.getAuthenticationStatus() == 6) {
            if (clientData == null) {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_USERNAME_BLOCKED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            } else {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_USERNAME_BLOCKED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        if (result.getAuthenticationStatus() == 4) {
            if (clientData == null) {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_ACCOUNT_DISABLED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            } else {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_ACCOUNT_DISABLED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        if (result.getAuthenticationStatus() == 1) {
            if (clientData == null) {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_PASSWORD_WRONG, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            } else {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_PASSWORD_WRONG, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        if (result.getAuthenticationStatus() == 2) {
            if (clientData == null) {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_PASSWORD_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            } else {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_PASSWORD_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        if (result.getAuthenticationStatus() == 3) {
            if (clientData == null) {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_INVALID, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            } else {
                this.appRes.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_INVALID, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        if (result.getAuthenticationStatus() == 0) {
            EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.AUTHENTICATION_SUCCESS, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            try {
                SessionManagement.SessionInfo sessionInfo = this.sessionManagement.getSessionInfo(result.getSessionIdentifier());
                message.addField(new EventLogField(EventLogField.FieldName.TARGET_USER_ID, sessionInfo.getUserId()));
                message.addField(new EventLogField(EventLogField.FieldName.SESSION_TRACKING_NUMBER, sessionInfo.getTrackingNumber()));
            }
            catch (Exception e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            }
            if (clientData != null) {
                message.addField(new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            this.appRes.logEvent(message);
            return result.getSessionIdentifier();
        }
        this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Invalid authentication result code"));
        return null;
    }

    public boolean terminateSession(String sessionIdentifier) throws GeneralizedException {
        block13: {
            UserManagement.UserDescriptor userDescriptor;
            SessionManagement.SessionInfo sessionInfo;
            try {
                sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
            }
            catch (InputValidationException e1) {
                this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
                return false;
            }
            catch (SQLException e1) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e1);
                throw new GeneralizedException();
            }
            catch (NoDatabaseConnectionException e1) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e1);
                throw new GeneralizedException();
            }
            if (sessionInfo.getSessionStatus() == SessionStatus.SESSION_NULL) {
                this.appRes.logEvent(EventLogMessage.EventType.SESSION_INVALID_TERMINATION_ATTEMPT, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
                return false;
            }
            if (!this.sessionManagement.terminateSession(sessionIdentifier)) break block13;
            try {
                userDescriptor = this.userManagement.getUserDescriptor(sessionInfo.getUserId());
            }
            catch (NotFoundException e) {
                this.appRes.logEvent(EventLogMessage.EventType.SESSION_ENDED, new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, sessionInfo.getUserName()));
                return true;
            }
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ENDED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, sessionInfo.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_INVALID_TERMINATION_ATTEMPT, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            return false;
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean terminateSession(String sessionIdentifer, long trackingNumber) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        block13: {
            UserManagement.UserDescriptor userDescriptor;
            SessionManagement.SessionInfo sessionInfo;
            this.checkRight(sessionIdentifer, "Users.Sessions.Delete");
            try {
                sessionInfo = this.sessionManagement.getSessionInfo(trackingNumber);
            }
            catch (InputValidationException e1) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e1);
                return false;
            }
            catch (SQLException e1) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e1);
                throw new GeneralizedException();
            }
            catch (NoDatabaseConnectionException e1) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e1);
                throw new GeneralizedException();
            }
            if (sessionInfo.getSessionStatus() == SessionStatus.SESSION_NULL) {
                this.appRes.logEvent(EventLogMessage.EventType.SESSION_INVALID_TERMINATION_ATTEMPT, new EventLogField(EventLogField.FieldName.SESSION_TRACKING_NUMBER, trackingNumber));
                return false;
            }
            if (!this.sessionManagement.terminateSession(trackingNumber)) break block13;
            try {
                userDescriptor = this.userManagement.getUserDescriptor(sessionInfo.getUserId());
            }
            catch (NotFoundException e) {
                this.appRes.logEvent(EventLogMessage.EventType.SESSION_ENDED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, sessionInfo.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                return true;
            }
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ENDED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, sessionInfo.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_INVALID_TERMINATION_ATTEMPT, new EventLogField(EventLogField.FieldName.SESSION_TRACKING_NUMBER, trackingNumber));
            return false;
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getSessionStatus(String sessionIdentifier) throws GeneralizedException {
        SessionManagement.SessionInfo sessionInfo;
        try {
            sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
        }
        catch (InputValidationException e1) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e1);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e1);
            throw new GeneralizedException();
        }
        if (sessionInfo.getSessionStatus() == SessionStatus.SESSION_EXPIRED) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_INACTIVITY_EXPIRED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, sessionInfo.getUserName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.SESSION_TRACKING_NUMBER, sessionInfo.getTrackingNumber()));
        } else if (sessionInfo.getSessionStatus() == SessionStatus.SESSION_HIJACKED) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_HIJACKED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, sessionInfo.getUserName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.SESSION_TRACKING_NUMBER, sessionInfo.getTrackingNumber()));
        } else if (sessionInfo.getSessionStatus() == SessionStatus.SESSION_INACTIVE) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_INACTIVITY_EXPIRED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, sessionInfo.getUserName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.SESSION_TRACKING_NUMBER, sessionInfo.getTrackingNumber()));
        } else if (sessionInfo.getSessionStatus() == SessionStatus.SESSION_LIFETIME_EXCEEDED) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_MAX_TIME_EXCEEDED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, sessionInfo.getUserName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.SESSION_TRACKING_NUMBER, sessionInfo.getTrackingNumber()));
        }
        return sessionInfo.getSessionStatus().getStatusId();
    }

    public String refreshSessionIdentifier(String sessionIdentifier) throws GeneralizedException {
        return this.refreshSessionIdentifier(sessionIdentifier, true);
    }

    public String refreshSessionIdentifier(String sessionIdentifier, boolean resetActivity) throws GeneralizedException {
        String newSessionIdentifier;
        try {
            newSessionIdentifier = this.sessionManagement.refreshSessionIdentifier(sessionIdentifier, resetActivity);
        }
        catch (NoSuchAlgorithmException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        return newSessionIdentifier;
    }

    public int disableUserSessions(String sessionIdentifier, int userId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        String userName;
        RightDescriptor acl;
        SessionManagement.SessionInfo sessionInfo;
        block11: {
            this.checkSession(sessionIdentifier);
            sessionInfo = null;
            acl = null;
            try {
                sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
                acl = this.accessControl.getUserRight(sessionInfo.getUserId(), "Users.Sessions.Delete", true);
            }
            catch (NotFoundException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
                throw new GeneralizedException();
            }
            UserManagement.UserDescriptor user = this.userManagement.getUserDescriptor(sessionInfo.getUserId());
            userName = null;
            if (user != null) {
                userName = user.getUserName();
            }
            if (acl != null) break block11;
            return -1;
        }
        try {
            if (acl.getRight() == AccessControlDescriptor.Action.PERMIT) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.OPERATION, "Discard user sessions"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                return this.sessionManagement.disableUserSessions(userId);
            }
            if (acl.getRight() == AccessControlDescriptor.Action.DENY) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.OPERATION, "Discard user sessions"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InsufficientPermissionException();
            }
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.OPERATION, "Discard user sessions"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            throw new InsufficientPermissionException();
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.OPERATION, "Discard user sessions"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, sessionInfo.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            throw new InsufficientPermissionException();
        }
        return -1;
    }

    @Override
    public UserManagement.UserDescriptor getUserInfo(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        return super.getUserInfo(sessionIdentifier);
    }

    public SessionManagement.SessionInfo[] getUserSessions(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        SessionManagement.SessionInfo[] currentSessions;
        block16: {
            String userName;
            RightDescriptor acl;
            SessionManagement.SessionInfo sessionInfo;
            block17: {
                this.checkSession(sessionIdentifier);
                sessionInfo = null;
                sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
                try {
                    acl = this.accessControl.getUserRight(sessionInfo.getUserId(), "Users.Sessions.View", true);
                }
                catch (NotFoundException e) {
                    this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
                    throw new GeneralizedException();
                }
                UserManagement.UserDescriptor user = this.userManagement.getUserDescriptor(sessionInfo.getUserId());
                userName = null;
                if (user != null) {
                    userName = user.getUserName();
                }
                if (user.isUnrestricted()) {
                    this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.OPERATION, "Enumerate user sessions"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                    break block16;
                }
                if (acl != null) break block17;
                return null;
            }
            try {
                if (acl.getRight() != AccessControlDescriptor.Action.PERMIT) {
                    if (acl.getRight() == AccessControlDescriptor.Action.DENY) {
                        this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.OPERATION, "Enumerate user sessions"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                        throw new InsufficientPermissionException();
                    }
                    this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.OPERATION, "Enumerate user sessions"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                    throw new InsufficientPermissionException();
                }
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.OPERATION, "Enumerate user sessions"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            catch (InputValidationException e) {
                this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            }
            catch (SQLException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
                throw new GeneralizedException();
            }
            catch (NoDatabaseConnectionException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
                throw new GeneralizedException();
            }
            catch (NotFoundException e) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.OPERATION, "Enumerate user sessions"), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                throw new InsufficientPermissionException();
            }
        }
        try {
            currentSessions = this.sessionManagement.getCurrentSessions();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        return currentSessions;
    }
}

