/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ApplicationStateMonitor;
import net.lukemurphey.nsia.ApplicationVersionDescriptor;
import net.lukemurphey.nsia.DelayedShutdown;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.GenericUtils;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NetworkManager;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.VersionManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.rest.RESTRequestFailedException;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;

public class ApiSystem
extends ApiHandler {
    private NetworkManager manager;

    public ApiSystem(Application appRes) {
        super(appRes);
        this.manager = appRes.getNetworkManager();
    }

    public String getDatabaseConnectionInfo(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getDatabaseInfo();
    }

    public int getDatabaseConnectionCount(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getDatabaseConnectionCount();
    }

    public String getDatabaseDriver(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getDatabaseDriver();
    }

    public String getJvmVendor(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getJvmVendor();
    }

    public String getJvmVersion(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getJvmVersion();
    }

    public long getMaxMemory(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getMaxMemory();
    }

    public String getOperatingSystemName(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getOperatingSystemName();
    }

    public String getOperatingSystemVersion(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getOperatingSystemVersion();
    }

    public String getDatabaseName(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        try {
            return this.appRes.getDatabaseName();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public String getDatabaseVersion(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkRight(sessionIdentifier, "System.Information.View");
        try {
            return this.appRes.getDatabaseVersion();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public String getDatabaseDriverVersion(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkRight(sessionIdentifier, "System.Information.View");
        try {
            return this.appRes.getDatabaseDriverVersion();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public String getDatabaseDriverName(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkRight(sessionIdentifier, "System.Information.View");
        try {
            return this.appRes.getDatabaseDriverName();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public DatabaseMetaData getDatabaseMetaData(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkRight(sessionIdentifier, "System.Information.View");
        try {
            return this.appRes.getDatabaseMetaData();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public long getStartTime(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getStartTime();
    }

    public String getPlatformArch(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getPlatformArch();
    }

    public int getProcessorCount(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getProcessorCount();
    }

    public int getServerPort(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.manager.getServerPort();
    }

    public boolean getSslEnabled(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.manager.sslEnabled();
    }

    public int getThreadCount(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getThreadCount();
    }

    public long getUptime(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getUptime();
    }

    public long getUsedMemory(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return this.appRes.getUsedMemory();
    }

    public String getVersion(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "System.Information.View");
        return Application.getVersion();
    }

    public void shutdownSystem(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Shutdown");
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        this.appRes.logEvent(EventLogMessage.EventType.APPLICATION_SHUTTING_DOWN, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.UPTIME, GenericUtils.getTimeDescription(this.appRes.getUptime() / 1000L)));
        DelayedShutdown shutdownWorker = new DelayedShutdown(10, this.appRes, Application.ShutdownRequestSource.API);
        Thread thread = new Thread(shutdownWorker);
        thread.start();
    }

    public String[] getSqlWarnings(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.checkRight(sessionIdentifier, "System.Information.View");
        try {
            return this.appRes.getSqlWarnings();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public String getLoginBanner() throws GeneralizedException {
        try {
            return this.appRes.getApplicationConfiguration().getLoginBanner();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (IllegalArgumentException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public Application.ApplicationStatusDescriptor getManagerStatus(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getManagerStatus();
        }
        catch (IllegalArgumentException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ApplicationStateMonitor.ApplicationStateDataPoint[] getOperationalMetrics(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.appRes.getMetricsData();
        }
        catch (IllegalArgumentException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ApplicationVersionDescriptor getNewestVersionAvailableID(boolean dontBlock) throws GeneralizedException {
        try {
            return VersionManagement.getNewestVersionAvailableID(dontBlock);
        }
        catch (RESTRequestFailedException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (IOException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean isNewerVersionAvailableID(boolean dontBlock) throws GeneralizedException {
        try {
            return VersionManagement.isNewerVersionAvailable(dontBlock);
        }
        catch (RESTRequestFailedException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (IOException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }
}

