/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.upgrade;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ApplicationConfiguration;
import net.lukemurphey.nsia.DerbyDatabaseInitializer;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.upgrade.UpgradeFailureException;
import net.lukemurphey.nsia.upgrade.UpgradeProcessor;
import net.lukemurphey.nsia.upgrade.UpgraderList;

public class Upgrader {
    private Application app = null;
    private static Pattern versionRegex = Pattern.compile("([0-9]+)[.]([0-9]+)[.]([0-9]+)");

    public Upgrader(Application application) {
        if (application == null) {
            throw new IllegalArgumentException("The application reference cannot be null");
        }
        this.app = application;
    }

    public int peformUpgrades() throws UpgradeFailureException {
        SchemaVersion schemaVersion = new SchemaVersion(this.app);
        List<UpgradeProcessor> list = null;
        list = UpgraderList.getInstance().getList(schemaVersion.getMajor(), schemaVersion.getMinor(), schemaVersion.getRevision());
        return this.peformUpgrades(list);
    }

    public int peformUpgrades(List<UpgradeProcessor> list) throws UpgradeFailureException {
        if (!this.isUpgradeNecessary()) {
            return 0;
        }
        int upgradesDone = 0;
        for (UpgradeProcessor upgradeProcessor : list) {
            if (!upgradeProcessor.doUpgrade(this.app)) continue;
            ++upgradesDone;
        }
        if (this.app.isUsingInternalDatabase()) {
            try {
                Connection connection = this.app.getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
                DerbyDatabaseInitializer initializer = new DerbyDatabaseInitializer(connection);
                initializer.performSetup();
            }
            catch (NoDatabaseConnectionException e) {
                throw new UpgradeFailureException(e);
            }
            catch (SQLException e) {
                throw new UpgradeFailureException(e);
            }
        }
        this.setSchemaVersion();
        return upgradesDone;
    }

    public int peformUpgrades(List<UpgradeProcessor> list, int major, int minor, int revision) throws UpgradeFailureException {
        if (!this.isUpgradeNecessary(major, minor, revision)) {
            return 0;
        }
        int upgradesDone = 0;
        for (UpgradeProcessor upgradeProcessor : list) {
            if (!upgradeProcessor.doUpgrade(this.app)) continue;
            ++upgradesDone;
        }
        this.setSchemaVersion();
        return upgradesDone;
    }

    private void setSchemaVersion() throws UpgradeFailureException {
        ApplicationConfiguration appConfig = this.app.getApplicationConfiguration();
        if (appConfig == null) {
            return;
        }
        try {
            appConfig.setDatabaseSchemaVersion("1.0.6");
        }
        catch (NoDatabaseConnectionException e) {
            throw new UpgradeFailureException("Upgrade failed while attempting to reset database schema version", e);
        }
        catch (SQLException e) {
            throw new UpgradeFailureException("Upgrade failed while attempting to reset database schema version", e);
        }
        catch (InputValidationException e) {
            throw new UpgradeFailureException("Upgrade failed while attempting to reset database schema version", e);
        }
    }

    public boolean isUpgradeNecessary() throws UpgradeFailureException {
        String ver;
        ApplicationConfiguration appConfig = this.app.getApplicationConfiguration();
        try {
            ver = appConfig.getDatabaseSchemaVersion();
        }
        catch (NoDatabaseConnectionException e) {
            throw new UpgradeFailureException(e);
        }
        catch (SQLException e) {
            throw new UpgradeFailureException(e);
        }
        catch (InputValidationException e) {
            throw new UpgradeFailureException(e);
        }
        if (ver == null) {
            return true;
        }
        int major = 0;
        int minor = 0;
        int revision = 0;
        Matcher m = versionRegex.matcher(ver);
        if (m.matches() && m.groupCount() == 3) {
            major = Integer.parseInt(m.group(1));
            minor = Integer.parseInt(m.group(2));
            revision = Integer.parseInt(m.group(3));
        }
        return this.isUpgradeNecessary(major, minor, revision);
    }

    public boolean isUpgradeNecessary(int major, int minor, int revision) throws UpgradeFailureException {
        return 1 != major || minor != 0 || 6 != revision;
    }

    private static class SchemaVersion {
        private int major = 0;
        private int minor = 0;
        private int revision = 0;

        public SchemaVersion(Application app) throws UpgradeFailureException {
            Matcher m;
            String ver;
            ApplicationConfiguration appConfig = app.getApplicationConfiguration();
            try {
                ver = appConfig.getDatabaseSchemaVersion();
            }
            catch (NoDatabaseConnectionException e) {
                throw new UpgradeFailureException(e);
            }
            catch (SQLException e) {
                throw new UpgradeFailureException(e);
            }
            catch (InputValidationException e) {
                throw new UpgradeFailureException(e);
            }
            if (ver != null && (m = versionRegex.matcher(ver)).matches() && m.groupCount() == 3) {
                this.major = Integer.parseInt(m.group(1));
                this.minor = Integer.parseInt(m.group(2));
                this.revision = Integer.parseInt(m.group(3));
            }
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getRevision() {
            return this.revision;
        }
    }
}

