/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.upgrade.processors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.upgrade.UpgradeFailureException;
import net.lukemurphey.nsia.upgrade.UpgradeProcessor;

public class ScanRuleCreatedTimestamps
extends UpgradeProcessor {
    public ScanRuleCreatedTimestamps() {
        super(0, 8, 104);
    }

    @Override
    public boolean doUpgrade(Application app) throws UpgradeFailureException {
        int updated;
        block10: {
            updated = 0;
            Connection conn = null;
            PreparedStatement statement = null;
            PreparedStatement statement2 = null;
            try {
                if (!app.isUsingInternalDatabase()) break block10;
                conn = app.getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
                statement = conn.prepareStatement("ALTER TABLE ScanRule ADD Created TimeStamp default NULL");
                statement2 = conn.prepareStatement("ALTER TABLE ScanRule ADD Modified TimeStamp default NULL");
                try {
                    if (!ScanRuleCreatedTimestamps.hasColumn(app, "ScanRule", "Created")) {
                        statement.executeUpdate();
                        ++updated;
                    }
                    if (!ScanRuleCreatedTimestamps.hasColumn(app, "ScanRule", "Modified")) {
                        statement2.executeUpdate();
                        ++updated;
                    }
                }
                finally {
                    conn.close();
                    if (statement != null) {
                        statement.close();
                    }
                    if (statement2 != null) {
                        statement2.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new UpgradeFailureException("Exception throw while attempting to add the 'created' and 'updated' columns to the scan rule table", e);
            }
            catch (NoDatabaseConnectionException e) {
                throw new UpgradeFailureException("Exception throw while attempting to add the 'created' and 'updated' columns to the scan rule table", e);
            }
        }
        return updated > 0;
    }
}

