/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ApplicationStateMonitor;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.NameIntPair;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.SessionStatus;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.NetworkPortRange;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ServiceScanResult;
import net.lukemurphey.nsia.trustBoundary.ApiScanData;
import net.lukemurphey.nsia.trustBoundary.ApiSessionManagement;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.servlet.ServletUtilities;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;

public class GraphServlet
extends HttpServlet {
    private static String lastStatusChartLocation = null;
    private static long lastStatusChartGenerationTime = 0L;
    private static String lastRuleStatChartLocation = null;
    private static long lastRuleStatChartGenerationTime = 0L;
    private static final long serialVersionUID = -6008582495779278653L;
    private static Hashtable<String, String> cachedCharts = new Hashtable();

    public synchronized void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JFreeChart chart;
        int chartCreationFrequency = 10;
        response.setHeader("Server", "ThreatFactor NSIA 1.0");
        boolean showGraph = true;
        try {
            SessionStatus sessionState = this.getSessionState(request, response);
            if (sessionState != SessionStatus.SESSION_ACTIVE) {
                showGraph = false;
            }
        }
        catch (GeneralizedException e) {
            showGraph = false;
            return;
        }
        if (!showGraph) {
            response.setHeader("Cache-Control", "max-age=1, must-revalidate");
            response.getOutputStream().print("You must login to view this resource");
            return;
        }
        int width = -1;
        int height = -1;
        if (request.getParameter("W") != null) {
            try {
                width = Integer.parseInt(request.getParameter("W"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (request.getParameter("H") != null) {
            try {
                height = Integer.parseInt(request.getParameter("H"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        response.setContentType("image/png");
        response.setHeader("Cache-Control", "max-age=" + chartCreationFrequency + ", must-revalidate");
        ApplicationStateMonitor.ApplicationStateDataPoint[] metrics = Application.getApplication().getMetricsData();
        if (request.getPathInfo().matches("/RulesEvalGraph.png") || request.getPathInfo().matches("/RulesEvalGraph")) {
            if (lastRuleStatChartLocation == null || System.currentTimeMillis() - lastRuleStatChartGenerationTime > (long)(chartCreationFrequency * 1000)) {
                chart = GraphServlet.generateRuleEvaluationGraph(metrics);
                chart.setAntiAlias(true);
                chart.setBackgroundPaint((Paint)new Color(208, 215, 222));
                chart.getLegend().setPosition(RectangleEdge.RIGHT);
                if (width <= 0) {
                    width = 600;
                }
                if (height <= 0) {
                    height = 120;
                }
                lastRuleStatChartLocation = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)width, (int)height, null);
                lastRuleStatChartGenerationTime = System.currentTimeMillis();
                ServletUtilities.sendTempFile((String)lastRuleStatChartLocation, (HttpServletResponse)response);
            } else {
                ServletUtilities.sendTempFile((String)lastRuleStatChartLocation, (HttpServletResponse)response);
            }
        }
        if (request.getPathInfo().matches("/ContentTypeResults.png") || request.getPathInfo().matches("/ContentTypeResults")) {
            String hash;
            int scanResultID = -1;
            String resultIDString = request.getParameter("ResultID");
            if (resultIDString == null) {
                scanResultID = -1;
            }
            try {
                scanResultID = Integer.parseInt(resultIDString);
            }
            catch (NumberFormatException e) {
                scanResultID = -1;
            }
            if (width <= 0) {
                width = 400;
            }
            if (height <= 0) {
                height = 150;
            }
            if (cachedCharts.get(hash = "ContentTypeResults/ResultID=" + scanResultID + "?W=" + width + "&H=" + height) != null) {
                ServletUtilities.sendTempFile((String)cachedCharts.get(hash), (HttpServletResponse)response);
                return;
            }
            JFreeChart chart2 = GraphServlet.generateContentTypePieChart(this.getSessionIdentifier(request), scanResultID);
            chart2.setAntiAlias(true);
            chart2.setBackgroundPaint((Paint)new Color(208, 215, 222));
            String ruleHistory = ServletUtilities.saveChartAsPNG((JFreeChart)chart2, (int)width, (int)height, null);
            cachedCharts.put(hash, ruleHistory);
            ServletUtilities.sendTempFile((String)ruleHistory, (HttpServletResponse)response);
        } else if (request.getPathInfo().matches("/SeverityResults.png") || request.getPathInfo().matches("/SeverityResults")) {
            String hash;
            int scanResultID = -1;
            String resultIDString = request.getParameter("ResultID");
            if (resultIDString == null) {
                scanResultID = -1;
            }
            try {
                scanResultID = Integer.parseInt(resultIDString);
            }
            catch (NumberFormatException e) {
                scanResultID = -1;
            }
            if (width <= 0) {
                width = 400;
            }
            if (height <= 0) {
                height = 150;
            }
            if (cachedCharts.get(hash = "SeverityResults/ResultID=" + scanResultID + "?W=" + width + "&H=" + height) != null) {
                ServletUtilities.sendTempFile((String)cachedCharts.get(hash), (HttpServletResponse)response);
                return;
            }
            JFreeChart chart3 = GraphServlet.generateSeverityPieChart(this.getSessionIdentifier(request), scanResultID);
            chart3.setAntiAlias(true);
            chart3.setBackgroundPaint((Paint)new Color(208, 215, 222));
            String severity = ServletUtilities.saveChartAsPNG((JFreeChart)chart3, (int)width, (int)height, null);
            cachedCharts.put(hash, severity);
            ServletUtilities.sendTempFile((String)severity, (HttpServletResponse)response);
        } else if (request.getPathInfo().matches("/RuleScanHistory.png") || request.getPathInfo().matches("/RuleScanHistory")) {
            int scanRuleID = -1;
            String ruleIDString = request.getParameter("RuleID");
            if (ruleIDString == null) {
                scanRuleID = -1;
            }
            try {
                scanRuleID = Integer.parseInt(ruleIDString);
            }
            catch (NumberFormatException e) {
                scanRuleID = -1;
            }
            long startEntry = -1L;
            String action = request.getParameter("Action");
            try {
                startEntry = Long.valueOf(request.getParameter("S"));
            }
            catch (NumberFormatException e) {
                startEntry = -1L;
            }
            if (action != null && action.equalsIgnoreCase("Previous")) {
                startEntry = Long.valueOf(request.getParameter("S"));
            } else if (action != null && action.equalsIgnoreCase("Next")) {
                startEntry = Long.valueOf(request.getParameter("E"));
            }
            JFreeChart chart4 = GraphServlet.generateRuleHistoryGraph(this.getSessionIdentifier(request), scanRuleID, 20, startEntry);
            chart4.setAntiAlias(true);
            chart4.setBackgroundPaint((Paint)new Color(208, 215, 222));
            chart4.getLegend().setPosition(RectangleEdge.RIGHT);
            if (width <= 0) {
                width = 650;
            }
            if (height <= 0) {
                height = 150;
            }
            String ruleHistory = ServletUtilities.saveChartAsPNG((JFreeChart)chart4, (int)width, (int)height, null);
            ServletUtilities.sendTempFile((String)ruleHistory, (HttpServletResponse)response);
        } else if (request.getPathInfo().matches("/ServiceScanDeviations.png") || request.getPathInfo().matches("/ServiceScanDeviations")) {
            int scanResultID = -1;
            String ruleIDString = request.getParameter("ResultID");
            if (ruleIDString == null) {
                scanResultID = -1;
            }
            try {
                scanResultID = Integer.parseInt(ruleIDString);
            }
            catch (NumberFormatException e) {
                scanResultID = -1;
            }
            JFreeChart chart5 = GraphServlet.generatePortScanDeviationsPieChart(this.getSessionIdentifier(request), scanResultID);
            chart5.setAntiAlias(true);
            chart5.setBackgroundPaint((Paint)new Color(208, 215, 222));
            if (width <= 0) {
                width = 350;
            }
            if (height <= 0) {
                height = 150;
            }
            String ruleHistory = ServletUtilities.saveChartAsPNG((JFreeChart)chart5, (int)width, (int)height, null);
            ServletUtilities.sendTempFile((String)ruleHistory, (HttpServletResponse)response);
        } else if (request.getPathInfo().matches("/UDPSummary.png") || request.getPathInfo().matches("/UDPSummary")) {
            int scanResultID = -1;
            String ruleIDString = request.getParameter("ResultID");
            if (ruleIDString == null) {
                scanResultID = -1;
            }
            try {
                scanResultID = Integer.parseInt(ruleIDString);
            }
            catch (NumberFormatException e) {
                scanResultID = -1;
            }
            JFreeChart chart6 = GraphServlet.generatePortScanSummaryPieChart(this.getSessionIdentifier(request), scanResultID, NetworkPortRange.Protocol.UDP);
            chart6.setAntiAlias(true);
            chart6.setBackgroundPaint((Paint)new Color(208, 215, 222));
            if (width <= 0) {
                width = 350;
            }
            if (height <= 0) {
                height = 150;
            }
            String ruleHistory = ServletUtilities.saveChartAsPNG((JFreeChart)chart6, (int)width, (int)height, null);
            ServletUtilities.sendTempFile((String)ruleHistory, (HttpServletResponse)response);
        } else if (request.getPathInfo().matches("/TCPSummary.png") || request.getPathInfo().matches("/TCPSummary")) {
            int scanResultID = -1;
            String ruleIDString = request.getParameter("ResultID");
            if (ruleIDString == null) {
                scanResultID = -1;
            }
            try {
                scanResultID = Integer.parseInt(ruleIDString);
            }
            catch (NumberFormatException e) {
                scanResultID = -1;
            }
            JFreeChart chart7 = GraphServlet.generatePortScanSummaryPieChart(this.getSessionIdentifier(request), scanResultID, NetworkPortRange.Protocol.TCP);
            chart7.setAntiAlias(true);
            chart7.setBackgroundPaint((Paint)new Color(208, 215, 222));
            if (width <= 0) {
                width = 350;
            }
            if (height <= 0) {
                height = 150;
            }
            String ruleHistory = ServletUtilities.saveChartAsPNG((JFreeChart)chart7, (int)width, (int)height, null);
            ServletUtilities.sendTempFile((String)ruleHistory, (HttpServletResponse)response);
        } else if (lastStatusChartLocation == null || System.currentTimeMillis() - lastStatusChartGenerationTime > (long)(chartCreationFrequency * 1000)) {
            chart = GraphServlet.generateStatusGraph(metrics);
            chart.setAntiAlias(true);
            chart.setBackgroundPaint((Paint)new Color(208, 215, 222));
            chart.getLegend().setPosition(RectangleEdge.RIGHT);
            if (width <= 0) {
                width = 600;
            }
            if (height <= 0) {
                height = 120;
            }
            lastStatusChartLocation = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)width, (int)height, null);
            lastStatusChartGenerationTime = System.currentTimeMillis();
            ServletUtilities.sendTempFile((String)lastStatusChartLocation, (HttpServletResponse)response);
        } else {
            ServletUtilities.sendTempFile((String)lastStatusChartLocation, (HttpServletResponse)response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.doRequest(request, response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.doRequest(request, response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static JFreeChart generateRuleHistoryGraph(String sessionIdentifier, int ruleID, int historyCount, long firstEntryID) {
        DefaultCategoryDataset dataSet = new DefaultCategoryDataset();
        ApiScanData scanData = new ApiScanData(Application.getApplication());
        ScanResult[] results = null;
        if (ruleID >= 0) {
            try {
                results = firstEntryID > 0L ? scanData.getScanResults(sessionIdentifier, firstEntryID, ruleID, historyCount, false) : scanData.getScanResults(sessionIdentifier, ruleID, historyCount);
            }
            catch (Exception e) {
                results = new ScanResult[]{};
            }
        }
        if (results == null) {
            results = new ScanResult[]{};
        }
        int c = results.length - 1;
        while (c >= 0) {
            dataSet.addValue((double)Math.max(0, results[c].getIncompletes()), (Comparable)((Object)"Incomplete"), (Comparable)((Object)("" + c)));
            dataSet.addValue((double)Math.max(0, results[c].getDeviations()), (Comparable)((Object)"Rejected"), (Comparable)((Object)("" + c)));
            dataSet.addValue((double)Math.max(0, results[c].getAccepts()), (Comparable)((Object)"Passed"), (Comparable)((Object)("" + c)));
            --c;
        }
        if (results.length == 0) {
            dataSet.addValue(0.0, (Comparable)((Object)"Incomplete"), (Comparable)((Object)""));
            dataSet.addValue(0.0, (Comparable)((Object)"Rejected"), (Comparable)((Object)""));
            dataSet.addValue(0.0, (Comparable)((Object)"Passed"), (Comparable)((Object)""));
        }
        JFreeChart chart = ChartFactory.createStackedBarChart((String)"", (String)"", (String)"", (CategoryDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        GroupedStackedBarRenderer renderer = new GroupedStackedBarRenderer();
        renderer.setItemMargin(0.01);
        renderer.setDrawBarOutline(false);
        renderer.setSeriesPaint(0, (Paint)Color.YELLOW);
        renderer.setSeriesPaint(1, (Paint)Color.RED);
        renderer.setSeriesPaint(2, (Paint)Color.GREEN);
        plot.setRenderer((CategoryItemRenderer)renderer);
        return chart;
    }

    private static JFreeChart generateStatusGraph(ApplicationStateMonitor.ApplicationStateDataPoint[] metrics) {
        XYSeries series = new XYSeries((Comparable)((Object)"Memory Use (MB)"));
        XYSeries threadSeries = new XYSeries((Comparable)((Object)"Threads"));
        XYSeries dbConnectionSeries = new XYSeries((Comparable)((Object)"Database Connections"));
        int d = 0;
        int c = 0;
        while (c < metrics.length) {
            if (metrics[c] != null) {
                double usedMem = 1.0 * ((double)metrics[c].usedMemory / 1024.0 / 1024.0);
                series.add((double)(c + 1 - metrics.length) / 6.0, usedMem);
                threadSeries.add((double)(c + 1 - metrics.length) / 6.0, (double)metrics[c].threadCount);
                dbConnectionSeries.add((double)(c + 1 - metrics.length) / 6.0, (double)metrics[c].databaseConnections);
                ++d;
            }
            ++c;
        }
        if (d == 0) {
            series.add(0.0, 0.0);
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        dataset.addSeries(threadSeries);
        dataset.addSeries(dbConnectionSeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"Time (minutes)", (String)"", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, true);
        renderer.setSeriesShapesVisible(0, false);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        renderer.setSeriesPaint(0, (Paint)new Color(255, 0, 0));
        renderer.setSeriesLinesVisible(1, true);
        renderer.setSeriesShapesVisible(1, false);
        renderer.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f));
        renderer.setSeriesPaint(1, (Paint)new Color(0, 192, 0));
        renderer.setSeriesLinesVisible(2, true);
        renderer.setSeriesShapesVisible(2, false);
        renderer.setSeriesStroke(2, (Stroke)new BasicStroke(2.0f));
        renderer.setSeriesPaint(2, (Paint)new Color(0, 0, 192));
        plot.setRenderer((XYItemRenderer)renderer);
        return chart;
    }

    private static JFreeChart generateSeverityPieChart(String sessionIdentifier, int resultID) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        try {
            ApiScanData scanData = new ApiScanData(Application.getApplication());
            Hashtable<Definition.Severity, Integer> severities = scanData.getHTTPDefinitionMatchSeverities(sessionIdentifier, resultID);
            dataset.setValue((Comparable)((Object)"Informational"), (Number)severities.get((Object)Definition.Severity.UNDEFINED));
            dataset.setValue((Comparable)((Object)"Low"), (Number)severities.get((Object)Definition.Severity.LOW));
            dataset.setValue((Comparable)((Object)"Medium"), (Number)severities.get((Object)Definition.Severity.MEDIUM));
            dataset.setValue((Comparable)((Object)"High"), (Number)severities.get((Object)Definition.Severity.HIGH));
        }
        catch (NoSessionException scanData) {
        }
        catch (GeneralizedException scanData) {
            // empty catch block
        }
        JFreeChart chart = ChartFactory.createPieChart((String)"", (PieDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setNoDataMessage("No data available");
        plot.setIgnoreNullValues(true);
        plot.setIgnoreZeroValues(true);
        plot.setSectionPaint(0, (Paint)new Color(19, 82, 141));
        plot.setSectionPaint(1, (Paint)new Color(254, 205, 49));
        plot.setSectionPaint(2, (Paint)new Color(240, 154, 67));
        plot.setSectionPaint(3, (Paint)new Color(206, 1, 1));
        return chart;
    }

    private static JFreeChart generatePortScanDeviationsPieChart(String sessionIdentifier, int resultID) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        ApiScanData scanData = new ApiScanData(Application.getApplication());
        boolean UDP_OPEN = false;
        boolean UDP_CLOSED = true;
        int TCP_OPEN = 2;
        int TCP_CLOSED = 3;
        NameIntPair[] deviations = new NameIntPair[]{new NameIntPair("UDP:open", 0), new NameIntPair("UDP:closed", 0), new NameIntPair("TCP:open", 0), new NameIntPair("TCP:closed", 0)};
        NetworkPortRange[] diffs = null;
        try {
            ServiceScanResult result = (ServiceScanResult)scanData.getScanResult(sessionIdentifier, resultID);
            diffs = result.getDifferences();
        }
        catch (Exception result) {
            // empty catch block
        }
        if (diffs != null) {
            int c = 0;
            while (c < diffs.length) {
                if (diffs[c].getProtocol() == NetworkPortRange.Protocol.TCP && diffs[c].getState() == NetworkPortRange.SocketState.OPEN) {
                    deviations[2].setValue(deviations[2].getValue() + diffs[c].getNumberOfPorts());
                } else if (diffs[c].getProtocol() == NetworkPortRange.Protocol.TCP) {
                    deviations[3].setValue(deviations[3].getValue() + diffs[c].getNumberOfPorts());
                } else if (diffs[c].getProtocol() == NetworkPortRange.Protocol.UDP && diffs[c].getState() == NetworkPortRange.SocketState.OPEN) {
                    deviations[0].setValue(deviations[0].getValue() + diffs[c].getNumberOfPorts());
                } else {
                    deviations[1].setValue(deviations[1].getValue() + diffs[c].getNumberOfPorts());
                }
                ++c;
            }
            NameIntPair[] nameIntPairArray = deviations;
            int n = deviations.length;
            int n2 = 0;
            while (n2 < n) {
                NameIntPair devs = nameIntPairArray[n2];
                if (devs.getValue() > 0) {
                    dataset.setValue((Comparable)((Object)devs.getName()), (double)devs.getValue());
                }
                ++n2;
            }
        }
        JFreeChart chart = ChartFactory.createPieChart((String)"", (PieDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setNoDataMessage("No deviations detected");
        plot.setSectionPaint(0, (Paint)new Color(206, 1, 1));
        plot.setSectionPaint(1, (Paint)new Color(255, 93, 0));
        plot.setSectionPaint(2, (Paint)new Color(255, 131, 0));
        plot.setSectionPaint(3, (Paint)new Color(255, 182, 0));
        return chart;
    }

    private static JFreeChart generatePortScanSummaryPieChart(String sessionIdentifier, int resultID, NetworkPortRange.Protocol protocol) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        ApiScanData scanData = new ApiScanData(Application.getApplication());
        boolean OPEN = false;
        boolean CLOSED = true;
        NameIntPair[] summary = new NameIntPair[]{new NameIntPair("Open", 0), new NameIntPair("Closed", 0)};
        NetworkPortRange[] ports = null;
        try {
            ServiceScanResult result = (ServiceScanResult)scanData.getScanResult(sessionIdentifier, resultID);
            ports = result.getPortsScanned();
        }
        catch (Exception result) {
            // empty catch block
        }
        if (ports != null) {
            int c = 0;
            while (c < ports.length) {
                if (ports[c].getProtocol() == protocol && ports[c].getState() == NetworkPortRange.SocketState.OPEN) {
                    summary[0].setValue(summary[0].getValue() + ports[c].getNumberOfPorts());
                } else if (ports[c].getProtocol() == protocol) {
                    summary[1].setValue(summary[1].getValue() + ports[c].getNumberOfPorts());
                }
                ++c;
            }
            NameIntPair[] nameIntPairArray = summary;
            int n = summary.length;
            int n2 = 0;
            while (n2 < n) {
                NameIntPair devs = nameIntPairArray[n2];
                dataset.setValue((Comparable)((Object)devs.getName()), (double)devs.getValue());
                ++n2;
            }
        }
        JFreeChart chart = ChartFactory.createPieChart((String)"", (PieDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setNoDataMessage("No data available");
        plot.setSectionPaint(0, (Paint)new Color(173, 205, 221));
        plot.setSectionPaint(1, (Paint)new Color(137, 184, 210));
        plot.setSectionPaint(2, (Paint)new Color(82, 151, 184));
        return chart;
    }

    private static JFreeChart generateContentTypePieChart(String sessionIdentifier, int resultID) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        ApiScanData scanData = new ApiScanData(Application.getApplication());
        Vector<NameIntPair> mimeTypes = null;
        try {
            mimeTypes = scanData.getDiscoveredContentTypes(sessionIdentifier, resultID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mimeTypes != null) {
            for (NameIntPair currentItem : mimeTypes) {
                Integer count;
                String currentKey = currentItem.getName();
                if (currentKey == null) {
                    currentKey = "[unknown]";
                }
                if ((count = Integer.valueOf(currentItem.getValue())) == null) continue;
                String simplifiedKey = currentKey;
                if (currentKey.lastIndexOf("/x-") > 0) {
                    simplifiedKey = currentKey.substring(currentKey.lastIndexOf("/x-") + 3);
                } else if (currentKey.lastIndexOf("/") > 0) {
                    simplifiedKey = currentKey.substring(currentKey.lastIndexOf("/") + 1);
                }
                if (simplifiedKey.length() == 0) {
                    simplifiedKey = currentKey;
                }
                dataset.setValue((Comparable)((Object)simplifiedKey), (Number)count);
            }
        }
        JFreeChart chart = ChartFactory.createPieChart((String)"", (PieDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setNoDataMessage("No data available");
        if (mimeTypes != null) {
            int c = 0;
            while (c < mimeTypes.size()) {
                int rem = c % 10;
                if (rem == 0) {
                    plot.setSectionPaint(c, (Paint)new Color(173, 205, 221));
                } else if (rem == 1) {
                    plot.setSectionPaint(c, (Paint)new Color(137, 184, 210));
                } else if (rem == 2) {
                    plot.setSectionPaint(c, (Paint)new Color(82, 151, 184));
                } else if (rem == 3) {
                    plot.setSectionPaint(c, (Paint)new Color(32, 120, 157));
                } else if (rem == 4) {
                    plot.setSectionPaint(c, (Paint)new Color(181, 202, 189));
                } else if (rem == 5) {
                    plot.setSectionPaint(c, (Paint)new Color(149, 181, 160));
                } else if (rem == 6) {
                    plot.setSectionPaint(c, (Paint)new Color(99, 148, 110));
                } else if (rem == 7) {
                    plot.setSectionPaint(c, (Paint)new Color(50, 117, 58));
                } else if (rem == 8) {
                    plot.setSectionPaint(c, (Paint)new Color(198, 212, 176));
                } else if (rem == 9) {
                    plot.setSectionPaint(c, (Paint)new Color(173, 196, 143));
                } else if (rem == 10) {
                    plot.setSectionPaint(c, (Paint)new Color(134, 169, 83));
                } else {
                    plot.setSectionPaint(c, (Paint)new Color(96, 145, 46));
                }
                ++c;
            }
        }
        return chart;
    }

    private static JFreeChart generateRuleEvaluationGraph(ApplicationStateMonitor.ApplicationStateDataPoint[] metrics) {
        XYSeries rulesRejectedseries = new XYSeries((Comparable)((Object)"Rejected Rules"));
        XYSeries rulesAcceptedSeries = new XYSeries((Comparable)((Object)"Accepted Rules"));
        XYSeries rulesIncompleteSeries = new XYSeries((Comparable)((Object)"Incomplete Rules"));
        int d = 0;
        int c = 0;
        while (c < metrics.length) {
            if (metrics[c] != null) {
                rulesRejectedseries.add((double)(c + 1 - metrics.length) / 6.0, (double)metrics[c].rulesRejectedCount);
                rulesAcceptedSeries.add((double)(c + 1 - metrics.length) / 6.0, (double)metrics[c].rulesAcceptedCount);
                rulesIncompleteSeries.add((double)(c + 1 - metrics.length) / 6.0, (double)metrics[c].rulesIncompleteCount);
                ++d;
            }
            ++c;
        }
        if (d == 0) {
            rulesRejectedseries.add(0.0, 0.0);
            rulesAcceptedSeries.add(0.0, 0.0);
            rulesIncompleteSeries.add(0.0, 0.0);
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(rulesRejectedseries);
        dataset.addSeries(rulesAcceptedSeries);
        dataset.addSeries(rulesIncompleteSeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"Time (minutes)", (String)"", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, true);
        renderer.setSeriesShapesVisible(0, false);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        renderer.setSeriesPaint(0, (Paint)new Color(255, 0, 0));
        renderer.setSeriesLinesVisible(1, true);
        renderer.setSeriesShapesVisible(1, false);
        renderer.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f));
        renderer.setSeriesPaint(1, (Paint)new Color(0, 192, 0));
        renderer.setSeriesLinesVisible(2, true);
        renderer.setSeriesShapesVisible(2, false);
        renderer.setSeriesStroke(2, (Stroke)new BasicStroke(2.0f));
        renderer.setSeriesPaint(2, (Paint)new Color(255, 192, 0));
        plot.setRenderer((XYItemRenderer)renderer);
        return chart;
    }

    private String getSessionIdentifier(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        int c = 0;
        while (c < cookies.length) {
            if (cookies[c].getName().matches("SessionID")) {
                return cookies[c].getValue();
            }
            ++c;
        }
        return null;
    }

    private SessionStatus getSessionState(HttpServletRequest request, HttpServletResponse response) throws GeneralizedException {
        Cookie[] cookies = request.getCookies();
        String sessionIdentifier = null;
        if (cookies == null) {
            return SessionStatus.SESSION_NULL;
        }
        int c = 0;
        while (c < cookies.length) {
            if (cookies[c].getName().matches("SessionID")) {
                sessionIdentifier = cookies[c].getValue();
            }
            ++c;
        }
        ApiSessionManagement xSession = new ApiSessionManagement(Application.getApplication());
        SessionStatus sessionStatus = SessionStatus.getStatusById(xSession.getSessionStatus(sessionIdentifier));
        if (sessionStatus.equals(SessionStatus.SESSION_IDENTIFIER_EXPIRED)) {
            if ((sessionIdentifier = xSession.refreshSessionIdentifier(sessionIdentifier)) == null) {
                sessionStatus = SessionStatus.SESSION_NULL;
            } else {
                sessionStatus = SessionStatus.getStatusById(xSession.getSessionStatus(sessionIdentifier));
                response.addCookie(new Cookie("SessionID", sessionIdentifier));
            }
        }
        return sessionStatus;
    }
}

