/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web;

import java.util.Vector;
import net.lukemurphey.nsia.SessionManagement;

public class SessionMessages {
    private Vector<SessionMessageEntry> messages = new Vector();

    public void purgeMessages(int tracking_number) {
        this.getAndDeleteMessages(tracking_number);
    }

    public void addMessage(SessionManagement.SessionInfo session, String message, MessageSeverity sev) {
        SessionMessageEntry msg = new SessionMessageEntry(session.getTrackingNumber(), sev, message);
        this.messages.add(msg);
    }

    public SessionMessageEntry[] getAndDeleteMessages(SessionManagement.SessionInfo session) {
        return this.getAndDeleteMessages(session.getTrackingNumber());
    }

    public SessionMessageEntry[] getAndDeleteMessages(long tracking_number) {
        SessionMessageEntry[] entries;
        SessionMessageEntry[] sessionMessageEntryArray = entries = this.getMessages(tracking_number);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SessionMessageEntry sessionMessageEntry = sessionMessageEntryArray[n2];
            this.messages.remove(sessionMessageEntry);
            ++n2;
        }
        return entries;
    }

    public SessionMessageEntry[] getMessages(SessionManagement.SessionInfo session) {
        return this.getMessages(session.getTrackingNumber());
    }

    public SessionMessageEntry[] getMessages(long tracking_number) {
        Vector<SessionMessageEntry> msgs = new Vector<SessionMessageEntry>();
        for (SessionMessageEntry msg : this.messages) {
            if (msg.tracking_number != tracking_number) continue;
            msgs.add(msg);
        }
        SessionMessageEntry[] entries = new SessionMessageEntry[msgs.size()];
        msgs.toArray(entries);
        return entries;
    }

    public static enum MessageSeverity {
        INFORMATION,
        SUCCESS,
        WARNING,
        ALERT;

    }

    public class SessionMessageEntry {
        private long tracking_number;
        private MessageSeverity severity;
        private String message;

        public SessionMessageEntry(long tracking_number, MessageSeverity severity, String message) {
            this.tracking_number = tracking_number;
            this.severity = severity;
            this.message = message;
        }

        public void delete() {
            SessionMessages.this.messages.remove(this);
        }

        public String getMessage() {
            return this.message;
        }

        public String getMessageAndDelete() {
            this.delete();
            return this.message;
        }

        public MessageSeverity getSeverity() {
            return this.severity;
        }

        public boolean isInformational() {
            return this.severity == MessageSeverity.INFORMATION;
        }

        public boolean isSuccess() {
            return this.severity == MessageSeverity.SUCCESS;
        }

        public boolean isAlert() {
            return this.severity == MessageSeverity.ALERT;
        }

        public boolean isWarning() {
            return this.severity == MessageSeverity.WARNING;
        }
    }
}

